/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.transport;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.unix.ServerDomainSocketChannel;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.neo4j.annotations.service.Service;
import org.neo4j.service.PrioritizedService;
import org.neo4j.service.Services;

@Service
public interface ConnectorTransport
extends PrioritizedService {
    public static Stream<ConnectorTransport> listAvailable() {
        return Services.loadAll(ConnectorTransport.class).stream();
    }

    public static Optional<ConnectorTransport> selectOptimal(Predicate<ConnectorTransport> filter) {
        return ConnectorTransport.listAvailable().filter(filter).filter(ConnectorTransport::isAvailable).min(Comparator.comparingInt(ConnectorTransport::getPriority));
    }

    public String getName();

    default public int getPriority() {
        return 0;
    }

    public boolean isAvailable();

    public boolean isNative();

    public EventLoopGroup createEventLoopGroup(int var1, ThreadFactory var2);

    default public EventLoopGroup createEventLoopGroup(ThreadFactory threadFactory) {
        return this.createEventLoopGroup(0, threadFactory);
    }

    public Class<? extends ServerSocketChannel> getSocketChannelType();

    public Class<? extends ServerDomainSocketChannel> getDomainSocketChannelType();
}

