/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.response.metadata;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.protocol.common.fsm.response.MetadataConsumer;
import org.neo4j.bolt.protocol.common.fsm.response.metadata.MetadataHandler;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualValues;

public abstract class AbstractMetadataHandler
implements MetadataHandler {
    public static final TextValue READ_ONLY = Values.utf8Value((byte[])new byte[]{114});
    public static final TextValue READ_WRITE = Values.utf8Value((byte[])new byte[]{114, 119});
    public static final TextValue WRITE = Values.utf8Value((byte[])new byte[]{119});
    public static final TextValue SCHEMA_WRITE = Values.utf8Value((byte[])new byte[]{115});

    @Override
    public void onStatementId(MetadataConsumer consumer, long statementId) {
        consumer.onMetadata("qid", (AnyValue)Values.longValue((long)statementId));
    }

    @Override
    public void onTimeSpentPreparingResults(MetadataConsumer handler, long spent) {
        handler.onMetadata("t_first", (AnyValue)Values.longValue((long)spent));
    }

    @Override
    public void onTimeSpentStreaming(MetadataConsumer handler, long spent) {
        handler.onMetadata("t_last", (AnyValue)Values.longValue((long)spent));
    }

    @Override
    public void onFieldNames(MetadataConsumer consumer, List<String> names) {
        ListValue fieldNames = (ListValue)names.stream().map(Values::stringValue).collect(ListValueBuilder.collector());
        consumer.onMetadata("fields", (AnyValue)fieldNames);
    }

    @Override
    public void onExecutionType(MetadataConsumer handler, QueryExecutionType executionType) {
        TextValue code = switch (executionType.queryType()) {
            default -> throw new IncompatibleClassChangeError();
            case QueryExecutionType.QueryType.READ_ONLY -> READ_ONLY;
            case QueryExecutionType.QueryType.READ_WRITE -> READ_WRITE;
            case QueryExecutionType.QueryType.WRITE -> WRITE;
            case QueryExecutionType.QueryType.SCHEMA_WRITE, QueryExecutionType.QueryType.DBMS -> SCHEMA_WRITE;
        };
        handler.onMetadata("type", (AnyValue)code);
    }

    @Override
    public void onDatabase(MetadataConsumer handler, DatabaseReference reference) {
        handler.onMetadata("db", (AnyValue)Values.stringValue((String)reference.alias().name()));
    }

    @Override
    public void onQueryStatistics(MetadataConsumer handler, QueryStatistics statistics) {
        if (!statistics.containsSystemUpdates() && !statistics.containsUpdates()) {
            return;
        }
        MapValueBuilder metadata = new MapValueBuilder();
        this.generateQueryStatistics(metadata, statistics);
        handler.onMetadata("stats", (AnyValue)metadata.build());
    }

    @Override
    public void onExecutionPlan(MetadataConsumer consumer, ExecutionPlanDescription plan) {
        MapValueBuilder metadata = new MapValueBuilder();
        this.generateExecutionPlan(metadata, plan);
        String fieldName = plan.hasProfilerStatistics() ? "profile" : "plan";
        consumer.onMetadata(fieldName, (AnyValue)metadata.build());
    }

    protected void generateExecutionPlan(MapValueBuilder metadata, ExecutionPlanDescription plan) {
        boolean hasProfilerStatistics = plan.hasProfilerStatistics();
        metadata.add("operatorType", (AnyValue)Values.utf8Value((String)plan.getName()));
        metadata.add("args", (AnyValue)ValueUtils.asMapValue((Map)plan.getArguments()));
        metadata.add("identifiers", (AnyValue)ValueUtils.asListValue((Iterable)plan.getIdentifiers()));
        if (!plan.getChildren().isEmpty()) {
            ListValueBuilder children = ListValueBuilder.newListBuilder();
            this.generateExecutionPlanChildren(children, plan);
            metadata.add("children", (AnyValue)children.build());
        }
        if (hasProfilerStatistics) {
            ExecutionPlanDescription.ProfilerStatistics profile = plan.getProfilerStatistics();
            if (profile.hasDbHits()) {
                metadata.add("dbHits", (AnyValue)Values.longValue((long)profile.getDbHits()));
            }
            if (profile.hasPageCacheStats()) {
                metadata.add("pageCacheHits", (AnyValue)Values.longValue((long)profile.getPageCacheHits()));
                metadata.add("pageCacheMisses", (AnyValue)Values.longValue((long)profile.getPageCacheMisses()));
                metadata.add("pageCacheHitRatio", (AnyValue)Values.doubleValue((double)profile.getPageCacheHitRatio()));
            }
            if (profile.hasRows()) {
                metadata.add("rows", (AnyValue)Values.longValue((long)profile.getRows()));
            }
            if (profile.hasTime()) {
                metadata.add("time", (AnyValue)Values.longValue((long)profile.getTime()));
            }
        }
    }

    protected void generateExecutionPlanChildren(ListValueBuilder children, ExecutionPlanDescription plan) {
        for (ExecutionPlanDescription child : plan.getChildren()) {
            MapValueBuilder metadata = new MapValueBuilder();
            this.generateExecutionPlan(metadata, child);
            children.add((AnyValue)metadata.build());
        }
    }

    @Override
    public void onResultsRemaining(MetadataConsumer handler, boolean hasRemaining) {
        if (hasRemaining) {
            handler.onMetadata("has_more", (AnyValue)BooleanValue.TRUE);
        }
    }

    @Override
    public void onRoutingTable(MetadataConsumer consumer, String databaseName, MapValue routingTable) {
        consumer.onMetadata("rt", (AnyValue)routingTable);
    }

    @Override
    public void onBookmark(MetadataConsumer handler, String encodedBookmark) {
        handler.onMetadata("bookmark", (AnyValue)Values.utf8Value((String)encodedBookmark));
    }

    @Override
    public void onNotifications(MetadataConsumer handler, Iterable<Notification> notifications) {
        Iterator<Notification> it = notifications.iterator();
        if (!it.hasNext()) {
            return;
        }
        ListValueBuilder children = ListValueBuilder.newListBuilder();
        while (it.hasNext()) {
            Notification notification = it.next();
            InputPosition pos = notification.getPosition();
            boolean includePosition = !pos.equals((Object)InputPosition.empty);
            int size = includePosition ? 5 : 4;
            MapValueBuilder builder = new MapValueBuilder(size);
            builder.add("code", (AnyValue)Values.utf8Value((String)notification.getCode()));
            builder.add("title", (AnyValue)Values.utf8Value((String)notification.getTitle()));
            builder.add("description", (AnyValue)Values.utf8Value((String)notification.getDescription()));
            builder.add("severity", (AnyValue)Values.utf8Value((String)notification.getSeverity().toString()));
            builder.add("category", (AnyValue)Values.stringValue((String)notification.getCategory().toString()));
            if (includePosition) {
                builder.add("position", (AnyValue)VirtualValues.map((String[])new String[]{"offset", "line", "column"}, (AnyValue[])new AnyValue[]{Values.intValue((int)pos.getOffset()), Values.intValue((int)pos.getLine()), Values.intValue((int)pos.getColumn())}));
            }
            children.add((AnyValue)builder.build());
        }
        handler.onMetadata("notifications", (AnyValue)children.build());
    }

    protected void generateQueryStatistics(MapValueBuilder metadata, QueryStatistics statistics) {
        if (statistics.containsUpdates()) {
            this.generateUpdateQueryStatistics(metadata, statistics);
        } else if (statistics.containsSystemUpdates()) {
            this.generateSystemQueryStatistics(metadata, statistics);
        }
    }

    protected void generateUpdateQueryStatistics(MapValueBuilder metadata, QueryStatistics statistics) {
        AbstractMetadataHandler.addIfNonZero(metadata, "nodes-created", statistics.getNodesCreated());
        AbstractMetadataHandler.addIfNonZero(metadata, "nodes-deleted", statistics.getNodesDeleted());
        AbstractMetadataHandler.addIfNonZero(metadata, "relationships-created", statistics.getRelationshipsCreated());
        AbstractMetadataHandler.addIfNonZero(metadata, "relationships-deleted", statistics.getRelationshipsDeleted());
        AbstractMetadataHandler.addIfNonZero(metadata, "properties-set", statistics.getPropertiesSet());
        AbstractMetadataHandler.addIfNonZero(metadata, "labels-added", statistics.getLabelsAdded());
        AbstractMetadataHandler.addIfNonZero(metadata, "labels-removed", statistics.getLabelsRemoved());
        AbstractMetadataHandler.addIfNonZero(metadata, "indexes-added", statistics.getIndexesAdded());
        AbstractMetadataHandler.addIfNonZero(metadata, "indexes-removed", statistics.getIndexesRemoved());
        AbstractMetadataHandler.addIfNonZero(metadata, "constraints-added", statistics.getConstraintsAdded());
        AbstractMetadataHandler.addIfNonZero(metadata, "constraints-removed", statistics.getConstraintsRemoved());
    }

    protected void generateSystemQueryStatistics(MapValueBuilder metadata, QueryStatistics statistics) {
        AbstractMetadataHandler.addIfNonZero(metadata, "system-updates", statistics.getSystemUpdates());
    }

    protected static void addIfNonZero(MapValueBuilder builder, String key, int value) {
        if (value != 0) {
            builder.add(key, (AnyValue)Values.longValue((long)value));
        }
    }
}

