/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.time.Duration;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.memory.HeapEstimator;

public class AuthenticationTimeoutHandler
extends ChannelInboundHandlerAdapter {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(AuthenticationTimeoutHandler.class);
    private final Duration timeout;
    private Future<?> timeoutFuture;
    private Connection connection;
    private volatile boolean requestReceived;

    public AuthenticationTimeoutHandler(Duration timeout) {
        this.timeout = timeout;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.connection = Connection.getConnection(ctx.channel());
        this.timeoutFuture = ctx.executor().schedule(() -> {
            try {
                this.authTimerEnded(ctx);
            }
            catch (Exception e) {
                ctx.fireExceptionCaught((Throwable)e);
            }
        }, this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        super.handlerAdded(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        this.connection.memoryTracker().releaseHeap(SHALLOW_SIZE);
    }

    protected void authTimerEnded(ChannelHandlerContext ctx) throws Exception {
        ctx.close();
        if (this.requestReceived) {
            throw new BoltConnectionFatality(String.format("Terminated connection '%s' (%s) as the server failed to handle an authentication request within %d ms.", this.connection.id(), ctx.channel(), this.timeout.toMillis()), null);
        }
        throw new BoltConnectionFatality(String.format("Terminated connection '%s' (%s) as the client failed to authenticate within %d ms.", this.connection.id(), ctx.channel(), this.timeout.toMillis()), null);
    }

    public void setRequestReceived(boolean requestReceived) {
        this.requestReceived = requestReceived;
    }
}

