/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v50;

import java.util.Set;
import org.neo4j.bolt.fsm.StateMachineConfiguration;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.protocol.AbstractBoltProtocol;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.protocol.common.fsm.States;
import org.neo4j.bolt.protocol.common.fsm.transition.authentication.AuthenticationStateTransition;
import org.neo4j.bolt.protocol.common.fsm.transition.negotiation.HelloStateTransition;
import org.neo4j.bolt.protocol.common.message.decoder.authentication.DefaultLogoffMessageDecoder;
import org.neo4j.bolt.protocol.common.message.decoder.authentication.DefaultLogonMessageDecoder;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.io.pipeline.WriterPipeline;
import org.neo4j.bolt.protocol.io.writer.DefaultStructWriter;
import org.neo4j.bolt.protocol.v41.message.decoder.authentication.HelloMessageDecoderV41;
import org.neo4j.bolt.protocol.v44.message.decoder.transaction.RunMessageDecoderV44;
import org.neo4j.bolt.protocol.v50.message.decoder.transaction.BeginMessageDecoderV50;
import org.neo4j.packstream.struct.StructRegistry;

public final class BoltProtocolV50
extends AbstractBoltProtocol {
    private static final BoltProtocolV50 INSTANCE = new BoltProtocolV50();
    public static final ProtocolVersion VERSION = new ProtocolVersion(5, 0);

    public static BoltProtocolV50 getInstance() {
        return INSTANCE;
    }

    @Override
    public ProtocolVersion version() {
        return VERSION;
    }

    @Override
    public Set<Feature> features() {
        return Set.of(Feature.UTC_DATETIME);
    }

    @Override
    protected StateMachineConfiguration.Factory createStateMachine() {
        return super.createStateMachine().withoutState(States.NEGOTIATION).withInitialState(States.AUTHENTICATION, HelloStateTransition.getInstance().andThen(AuthenticationStateTransition.getInstance()));
    }

    @Override
    public void registerStructWriters(WriterPipeline pipeline) {
        pipeline.addLast(DefaultStructWriter.getInstance());
    }

    @Override
    protected StructRegistry.Builder<Connection, RequestMessage> createRequestMessageRegistry() {
        return super.createRequestMessageRegistry().unregister(DefaultLogonMessageDecoder.getInstance()).unregister(DefaultLogoffMessageDecoder.getInstance()).register(HelloMessageDecoderV41.getInstance()).register(BeginMessageDecoderV50.getInstance()).register(RunMessageDecoderV44.getInstance());
    }
}

