/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.util;

import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public final class PackstreamConditions {
    private PackstreamConditions() {
    }

    public static void requireLength(StructHeader header, int expected) throws IllegalStructSizeException {
        if (header.length() != (long)expected) {
            throw new IllegalStructSizeException(expected, header.length());
        }
    }

    public static void requireEmpty(StructHeader header) throws IllegalStructSizeException {
        PackstreamConditions.requireLength(header, 0);
    }

    public static void requireNonNull(String fieldName, Object fieldValue) throws IllegalStructArgumentException {
        if (fieldValue == null) {
            throw new IllegalStructArgumentException(fieldName, "Expected value to be non-null");
        }
    }

    public static void requireNonNullValue(String fieldName, AnyValue fieldValue) throws IllegalStructArgumentException {
        if (fieldValue == Values.NO_VALUE) {
            throw new IllegalStructArgumentException(fieldName, "Expected value to be non-null");
        }
    }
}

