/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.cypher.internal.cache.CacheSize;
import org.neo4j.cypher.internal.cache.CacheTracer;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;

@ScalaSignature(bytes="\u0006\u0005\u0005}a\u0001\u0002\n\u0014\u0001yA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007C\u0003<\u0001\u0011\u0005A\bC\u0003<\u0001\u0011\u0005A\tC\u0003<\u0001\u0011\u0005q\tC\u0004N\u0001\t\u0007I\u0011\u0001(\t\rq\u0003\u0001\u0015!\u0003P\u0011\u001di\u0006A1A\u0005\nyCaA\u0019\u0001!\u0002\u0013y\u0006\"B2\u0001\t\u0003!\u0007\"\u00027\u0001\t\u0003i\u0007\"\u0002:\u0001\t\u0003\u0019\b\"\u0002>\u0001\t\u0003Y\bBB@\u0001\t\u0003\t\t\u0001C\u0004\u0002\u0018\u0001!\t!!\u0007\t\r\u0005u\u0001\u0001\"\u0001|\u0005!ae)V\"bG\",'B\u0001\u000b\u0016\u0003\u0015\u0019\u0017m\u00195f\u0015\t1r#\u0001\u0005j]R,'O\\1m\u0015\tA\u0012$\u0001\u0004dsBDWM\u001d\u0006\u00035m\tQA\\3pi)T\u0011\u0001H\u0001\u0004_J<7\u0001A\u000b\u0004?Uz4C\u0001\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0019\te.\u001f*fM\u0006a1-Y2iK\u001a\u000b7\r^8ssB\u0011\u0001&K\u0007\u0002'%\u0011!f\u0005\u0002\u0015\u0007\u00064g-Z5oK\u000e\u000b7\r[3GC\u000e$xN]=\u0002\u0017%t\u0017\u000e^5bYNK'0\u001a\t\u0003Q5J!AL\n\u0003\u0013\r\u000b7\r[3TSj,\u0017A\u0002;sC\u000e,'\u000fE\u0002)cMJ!AM\n\u0003\u0017\r\u000b7\r[3Ue\u0006\u001cWM\u001d\t\u0003iUb\u0001\u0001B\u00037\u0001\t\u0007qGA\u0001L#\tA\u0004\u0005\u0005\u0002\"s%\u0011!H\t\u0002\b\u001d>$\b.\u001b8h\u0003\u0019a\u0014N\\5u}Q!Q(\u0011\"D!\u0011A\u0003a\r \u0011\u0005QzD!\u0002!\u0001\u0005\u00049$!\u0001,\t\u000b\u0019\"\u0001\u0019A\u0014\t\u000b-\"\u0001\u0019\u0001\u0017\t\u000b=\"\u0001\u0019\u0001\u0019\u0015\u0007u*e\tC\u0003'\u000b\u0001\u0007q\u0005C\u0003,\u000b\u0001\u0007A\u0006F\u0002>\u0011&CQA\n\u0004A\u0002\u001dBQa\u000b\u0004A\u0002)\u0003\"!I&\n\u00051\u0013#aA%oi\u0006y!/Z7pm\u0006dG*[:uK:,'/F\u0001P!\u0011\u0001&l\r \u000e\u0003ES!\u0001\u0006*\u000b\u0005M#\u0016\u0001C2bM\u001a,\u0017N\\3\u000b\u0005U3\u0016\u0001\u00032f]6\fg.Z:\u000b\u0005]C\u0016AB4ji\",(MC\u0001Z\u0003\r\u0019w.\\\u0005\u00037F\u0013qBU3n_Z\fG\u000eT5ti\u0016tWM]\u0001\u0011e\u0016lwN^1m\u0019&\u001cH/\u001a8fe\u0002\nQ!\u001b8oKJ,\u0012a\u0018\t\u0005!\u0002\u001cd(\u0003\u0002b#\n)1)Y2iK\u00061\u0011N\u001c8fe\u0002\nqbY8naV$X-\u00134BEN,g\u000e\u001e\u000b\u0004}\u0015<\u0007\"\u00024\f\u0001\u0004\u0019\u0014aA6fs\"1\u0001n\u0003CA\u0002%\f\u0011A\u001a\t\u0004C)t\u0014BA6#\u0005!a$-\u001f8b[\u0016t\u0014aA4fiR\u0011a.\u001d\t\u0004C=t\u0014B\u00019#\u0005\u0019y\u0005\u000f^5p]\")a\r\u0004a\u0001g\u0005\u0019\u0001/\u001e;\u0015\u0007Q<\b\u0010\u0005\u0002\"k&\u0011aO\t\u0002\u0005+:LG\u000fC\u0003g\u001b\u0001\u00071\u0007C\u0003z\u001b\u0001\u0007a(A\u0003wC2,X-A\u0007fgRLW.\u0019;fINK'0\u001a\u000b\u0002yB\u0011\u0011%`\u0005\u0003}\n\u0012A\u0001T8oO\u0006)\u0011m]'baR\u0011\u00111\u0001\t\u0007\u0003\u000b\t\u0019b\r \u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\ti!a\u0004\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003#\tAA[1wC&!\u0011QCA\u0004\u00055\u0019uN\\2veJ,g\u000e^'ba\u0006Q\u0011N\u001c<bY&$\u0017\r^3\u0015\u0007Q\fY\u0002C\u0003g!\u0001\u00071'A\u0003dY\u0016\f'\u000f")
public class LFUCache<K, V> {
    private final CacheTracer<K> tracer;
    private final RemovalListener<K, V> removalListener;
    private final Cache<K, V> inner;

    public RemovalListener<K, V> removalListener() {
        return this.removalListener;
    }

    private Cache<K, V> inner() {
        return this.inner;
    }

    public V computeIfAbsent(K key, Function0<V> f) {
        BooleanRef hit = BooleanRef.create((boolean)true);
        Object result = this.inner().get(key, x$1 -> {
            hit$1.elem = false;
            return f.apply();
        });
        if (hit.elem) {
            this.tracer.cacheHit(key, "");
        } else {
            this.tracer.cacheMiss(key, "");
        }
        return (V)result;
    }

    public Option<V> get(K key) {
        Option res = Option$.MODULE$.apply(this.inner().getIfPresent(key));
        if (res.isEmpty()) {
            this.tracer.cacheMiss(key, "");
        } else {
            this.tracer.cacheHit(key, "");
        }
        return res;
    }

    public void put(K key, V value) {
        this.inner().put(key, value);
    }

    public long estimatedSize() {
        return this.inner().estimatedSize();
    }

    public ConcurrentMap<K, V> asMap() {
        return this.inner().asMap();
    }

    public void invalidate(K key) {
        this.inner().invalidate(key);
    }

    public long clear() {
        long priorSize = this.inner().estimatedSize();
        this.inner().invalidateAll();
        this.inner().cleanUp();
        this.tracer.cacheFlush(priorSize);
        return priorSize;
    }

    public LFUCache(CaffeineCacheFactory cacheFactory, CacheSize initialSize, CacheTracer<K> tracer) {
        this.tracer = tracer;
        this.removalListener = (key, value, cause) -> $this.tracer.discard(key, "");
        this.inner = cacheFactory.createCache(initialSize, this.removalListener());
    }

    public LFUCache(CaffeineCacheFactory cacheFactory, CacheSize initialSize) {
        this(cacheFactory, initialSize, new CacheTracer<K>(){

            public void cacheHit(K key, String metaData) {
                CacheTracer.cacheHit$(this, key, metaData);
            }

            public void cacheMiss(K key, String metaData) {
                CacheTracer.cacheMiss$(this, key, metaData);
            }

            public void compute(K key, String metaData) {
                CacheTracer.compute$(this, key, metaData);
            }

            public void discard(K key, String metaData) {
                CacheTracer.discard$(this, key, metaData);
            }

            public void computeWithExpressionCodeGen(K key, String metaData) {
                CacheTracer.computeWithExpressionCodeGen$(this, key, metaData);
            }

            public void cacheStale(K key, int secondsSinceCompute, String metaData, Option<String> maybeReason) {
                CacheTracer.cacheStale$(this, key, secondsSinceCompute, metaData, maybeReason);
            }

            public void cacheFlush(long sizeOfCacheBeforeFlush) {
                CacheTracer.cacheFlush$(this, sizeOfCacheBeforeFlush);
            }
            {
                CacheTracer.$init$(this);
            }
        });
    }

    public LFUCache(CaffeineCacheFactory cacheFactory, int initialSize) {
        this(cacheFactory, new CacheSize.Static(initialSize), new CacheTracer<K>(){

            public void cacheHit(K key, String metaData) {
                CacheTracer.cacheHit$(this, key, metaData);
            }

            public void cacheMiss(K key, String metaData) {
                CacheTracer.cacheMiss$(this, key, metaData);
            }

            public void compute(K key, String metaData) {
                CacheTracer.compute$(this, key, metaData);
            }

            public void discard(K key, String metaData) {
                CacheTracer.discard$(this, key, metaData);
            }

            public void computeWithExpressionCodeGen(K key, String metaData) {
                CacheTracer.computeWithExpressionCodeGen$(this, key, metaData);
            }

            public void cacheStale(K key, int secondsSinceCompute, String metaData, Option<String> maybeReason) {
                CacheTracer.cacheStale$(this, key, secondsSinceCompute, metaData, maybeReason);
            }

            public void cacheFlush(long sizeOfCacheBeforeFlush) {
                CacheTracer.cacheFlush$(this, sizeOfCacheBeforeFlush);
            }
            {
                CacheTracer.$init$(this);
            }
        });
    }
}

