/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.event.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.shiro.event.Subscribe;
import org.apache.shiro.event.support.EventListener;
import org.apache.shiro.event.support.EventListenerResolver;
import org.apache.shiro.event.support.SingleArgumentMethodEventListener;
import org.apache.shiro.util.ClassUtils;

public class AnnotationEventListenerResolver
implements EventListenerResolver {
    private Class<? extends Annotation> annotationClass = Subscribe.class;

    @Override
    public List<EventListener> getEventListeners(Object instance) {
        if (instance == null) {
            return Collections.emptyList();
        }
        List methods = ClassUtils.getAnnotatedMethods(instance.getClass(), this.getAnnotationClass());
        if (methods == null || methods.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EventListener> listeners = new ArrayList<EventListener>(methods.size());
        for (Method m : methods) {
            listeners.add(new SingleArgumentMethodEventListener(instance, m));
        }
        return listeners;
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public void setAnnotationClass(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }
}

