/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import inet.ipaddr.IPAddressString;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.internal.ir.CSVFormat;
import org.neo4j.cypher.internal.ir.HasHeaders$;
import org.neo4j.cypher.internal.ir.NoHeaders$;
import org.neo4j.cypher.internal.runtime.ArrayBackedMap;
import org.neo4j.cypher.internal.runtime.ArrayBackedMap$;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LoadCsvIterator;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeWithSource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.exceptions.LoadExternalResourceException;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005]h!B\u0015+\u0003\u0003I\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011\t\u0003!\u0011!Q\u0001\n\rC\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"AA\r\u0001B\u0001B\u0003%Q\r\u0003\u0005i\u0001\t\u0005\t\u0015!\u0003j\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u0015)\bA\"\u0005w\u0011\u001d\ti\u0002\u0001C\t\u0003?1a!a\u0010\u0001\t\u0005\u0005\u0003BCA%\u0015\t\u0005\t\u0015!\u0003\u0002L!I\u00111\u0002\u0006\u0003\u0002\u0003\u0006Ia\u001e\u0005\ty*\u0011\t\u0011)A\u00053\"Q\u0011\u0011\u000e\u0006\u0003\u0002\u0003\u0006I!a\u001b\t\r1TA\u0011AA9\u0011%\tyH\u0003b\u0001\n\u0013\t\t\t\u0003\u0005\u0002\n*\u0001\u000b\u0011BAB\u0011%\tYI\u0003b\u0001\n\u0013\ti\tC\u0004\u0002\u0010*\u0001\u000b\u0011B@\t\u0017\u0005E%\u00021AA\u0002\u0013%\u00111\u0013\u0005\f\u0003+S\u0001\u0019!a\u0001\n\u0013\t9\n\u0003\u0006\u0002$*\u0001\r\u0011!Q!\n]D\u0011\"!*\u000b\u0001\u0004%I!a*\t\u0013\u0005%&\u00021A\u0005\n\u0005-\u0006bBAX\u0015\u0001\u0006K!\u001a\u0005\t\u0003cS\u0001\u0015\"\u0015\u00024\"9\u0011Q\u0017\u0006\u0005B\u0005\u001d\u0006bBA\\\u0015\u0011\u0005\u0013\u0011\u0018\u0005\b\u0003wSA\u0011BA]\r\u0019\ti\f\u0001\u0003\u0002@\"I\u00111\u0002\u0010\u0003\u0002\u0003\u0006Ia\u001e\u0005\tyz\u0011\t\u0011)A\u00053\"Q\u0011\u0011\u000e\u0010\u0003\u0002\u0003\u0006I!a\u001b\t\r1tB\u0011AAa\u0011!\t\tL\bQ\u0005R\u0005M\u0006bBA[=\u0011\u0005\u0013q\u0015\u0005\b\u0003osB\u0011IA]\u0011\u001d\tY\r\u0001C\u0005\u0003\u001bDq!!9\u0001\t#\n\u0019\u000fC\u0004\u0002l\u0002!I!!<\u0003'\u0005\u00137\u000f\u001e:bGRdu.\u00193D'Z\u0003\u0016\u000e]3\u000b\u0005-b\u0013!\u00029ja\u0016\u001c(BA\u0017/\u0003-Ig\u000e^3saJ,G/\u001a3\u000b\u0005=\u0002\u0014a\u0002:v]RLW.\u001a\u0006\u0003cI\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003gQ\naaY=qQ\u0016\u0014(BA\u001b7\u0003\u0015qWm\u001c\u001bk\u0015\u00059\u0014aA8sO\u000e\u00011C\u0001\u0001;!\tYD(D\u0001+\u0013\ti$F\u0001\bQSB,w+\u001b;i'>,(oY3\u0002\rM|WO]2f!\tY\u0004)\u0003\u0002BU\t!\u0001+\u001b9f\u0003\u00191wN]7biB\u0011AiR\u0007\u0002\u000b*\u0011a\tM\u0001\u0003SJL!\u0001S#\u0003\u0013\r\u001bfKR8s[\u0006$\u0018!D;sY\u0016C\bO]3tg&|g\u000e\u0005\u0002L!6\tAJ\u0003\u0002N\u001d\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tyE&\u0001\u0005d_6l\u0017M\u001c3t\u0013\t\tFJ\u0001\u0006FqB\u0014Xm]:j_:\fqBZ5fY\u0012$VM]7j]\u0006$xN\u001d\t\u0004)^KV\"A+\u000b\u0003Y\u000bQa]2bY\u0006L!\u0001W+\u0003\r=\u0003H/[8o!\tQ\u0016M\u0004\u0002\\?B\u0011A,V\u0007\u0002;*\u0011a\fO\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001,\u0016A\u0002)sK\u0012,g-\u0003\u0002cG\n11\u000b\u001e:j]\u001eT!\u0001Y+\u0002-1,w-Y2z\u0007N4\u0018+^8uK\u0016\u001b8-\u00199j]\u001e\u0004\"\u0001\u00164\n\u0005\u001d,&a\u0002\"p_2,\u0017M\\\u0001\u000bEV4g-\u001a:TSj,\u0007C\u0001+k\u0013\tYWKA\u0002J]R\fa\u0001P5oSRtDc\u00028paF\u00148\u000f\u001e\t\u0003w\u0001AQAP\u0004A\u0002}BQAQ\u0004A\u0002\rCQ!S\u0004A\u0002)CQAU\u0004A\u0002MCQ\u0001Z\u0004A\u0002\u0015DQ\u0001[\u0004A\u0002%\f\u0001b\u001e:ji\u0016\u0014vn\u001e\u000b\nonl\u0018QAA\u0005\u0003\u001b\u0001\"\u0001_=\u000e\u00039J!A\u001f\u0018\u0003\u0013\rK\b\u000f[3s%><\b\"\u0002?\t\u0001\u0004I\u0016\u0001\u00034jY\u0016t\u0017-\\3\t\u000byD\u0001\u0019A@\u0002\u00151Lg.\u001a8v[\n,'\u000fE\u0002U\u0003\u0003I1!a\u0001V\u0005\u0011auN\\4\t\r\u0005\u001d\u0001\u00021\u0001f\u0003\u0011a\u0017m\u001d;\t\r\u0005-\u0001\u00021\u0001x\u0003-\t'oZ;nK:$(k\\<\t\u000f\u0005=\u0001\u00021\u0001\u0002\u0012\u0005)a/\u00197vKB!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018Q\naA^1mk\u0016\u001c\u0018\u0002BA\u000e\u0003+\u0011\u0001\"\u00118z-\u0006dW/Z\u0001\rO\u0016$\u0018*\u001c9peR,&\u000b\u0014\u000b\u0007\u0003C\t\t$!\u000e\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005\u0019a.\u001a;\u000b\u0005\u0005-\u0012\u0001\u00026bm\u0006LA!a\f\u0002&\t\u0019QK\u0015'\t\r\u0005M\u0012\u00021\u0001Z\u0003%)(\u000f\\*ue&tw\rC\u0004\u00028%\u0001\r!!\u000f\u0002\u000f\r|g\u000e^3yiB\u0019\u00010a\u000f\n\u0007\u0005ubF\u0001\u0007Rk\u0016\u0014\u0018pQ8oi\u0016DHOA\nJi\u0016\u0014\u0018\r^8s/&$\b\u000eS3bI\u0016\u00148oE\u0002\u000b\u0003\u0007\u0002B\u0001_A#o&\u0019\u0011q\t\u0018\u0003\u001f\rcwn]5oO&#XM]1u_J\fq\u0001[3bI\u0016\u00148\u000f\u0005\u0004\u0002N\u0005]\u0013Q\f\b\u0005\u0003\u001f\n\u0019FD\u0002]\u0003#J\u0011AV\u0005\u0004\u0003+*\u0016a\u00029bG.\fw-Z\u0005\u0005\u00033\nYFA\u0002TKFT1!!\u0016V!\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$\u0002BA2\u0003+\t\u0001b\u001d;pe\u0006\u0014G.Z\u0005\u0005\u0003O\n\tGA\u0003WC2,X-A\u0003j]:,'\u000fE\u0002<\u0003[J1!a\u001c+\u0005=au.\u00193DgZLE/\u001a:bi>\u0014HCCA:\u0003o\nI(a\u001f\u0002~A\u0019\u0011Q\u000f\u0006\u000e\u0003\u0001Aq!!\u0013\u0010\u0001\u0004\tY\u0005\u0003\u0004\u0002\f=\u0001\ra\u001e\u0005\u0006y>\u0001\r!\u0017\u0005\b\u0003Sz\u0001\u0019AA6\u0003-Ig\u000e^3s]\u0006dW*\u00199\u0016\u0005\u0005\r\u0005C\u0002=\u0002\u0006f\u000b\t\"C\u0002\u0002\b:\u0012a\"\u0011:sCf\u0014\u0015mY6fI6\u000b\u0007/\u0001\u0007j]R,'O\\1m\u001b\u0006\u0004\b%A\bj]R,'O\\1m\u001b\u0006\u00048+\u001b>f+\u0005y\u0018\u0001E5oi\u0016\u0014h.\u00197NCB\u001c\u0016N_3!\u0003\u0019qWm\u001e*poV\tq/\u0001\u0006oK^\u0014vn^0%KF$B!!'\u0002 B\u0019A+a'\n\u0007\u0005uUK\u0001\u0003V]&$\b\u0002CAQ+\u0005\u0005\t\u0019A<\u0002\u0007a$\u0013'A\u0004oK^\u0014vn\u001e\u0011\u0002\u00179,W\rZ:Va\u0012\fG/Z\u000b\u0002K\u0006ya.Z3egV\u0003H-\u0019;f?\u0012*\u0017\u000f\u0006\u0003\u0002\u001a\u00065\u0006\u0002CAQ1\u0005\u0005\t\u0019A3\u0002\u00199,W\rZ:Va\u0012\fG/\u001a\u0011\u0002\u0013\rdwn]3N_J,GCAAM\u00031IgN\\3s\u0011\u0006\u001ch*\u001a=u\u0003\u0011qW\r\u001f;\u0015\u0003]\fabY8naV$XMT3yiJ{wO\u0001\fJi\u0016\u0014\u0018\r^8s/&$\bn\\;u\u0011\u0016\fG-\u001a:t'\rq\u00121\t\u000b\t\u0003\u0007\f)-a2\u0002JB\u0019\u0011Q\u000f\u0010\t\r\u0005-!\u00051\u0001x\u0011\u0015a(\u00051\u0001Z\u0011\u001d\tIG\ta\u0001\u0003W\n!cZ3u\u0019>\fGmQ*W\u0013R,'/\u0019;peRA\u00111NAh\u00033\fi\u000eC\u0004\u0002R\u001a\u0002\r!a5\u0002\u000bM$\u0018\r^3\u0011\u0007m\n).C\u0002\u0002X*\u0012!\"U;fef\u001cF/\u0019;f\u0011\u001d\tYN\na\u0001\u0003C\t1!\u001e:m\u0011\u0019\tyN\na\u0001K\u0006QQo]3IK\u0006$WM]:\u0002+%tG/\u001a:oC2\u001c%/Z1uKJ+7/\u001e7ugR1\u00111IAs\u0003SDq!a:(\u0001\u0004\t\u0019%A\u0003j]B,H\u000fC\u0004\u0002R\u001e\u0002\r!a5\u0002\u001fI,\u0007\u000f\\1dK:{g+\u00197vKN$B!a<\u0002vB1\u0011QJAy\u0003;JA!a=\u0002\\\tQ\u0011J\u001c3fq\u0016$7+Z9\t\u000f\u0005%\u0003\u00061\u0001\u0002p\u0002")
public abstract class AbstractLoadCSVPipe
extends PipeWithSource {
    private final CSVFormat format;
    private final Expression urlExpression;
    private final Option<String> fieldTerminator;
    private final boolean legacyCsvQuoteEscaping;
    private final int bufferSize;

    public abstract CypherRow writeRow(String var1, long var2, boolean var4, CypherRow var5, AnyValue var6);

    public URL getImportURL(String urlString, QueryContext context) {
        URL uRL;
        try {
            uRL = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new LoadExternalResourceException("Invalid URL '" + urlString + "': " + e.getMessage(), (Throwable)e);
        }
        URL url = uRL;
        Either either = context.getImportURL(url);
        if (either instanceof Left) {
            Left left = (Left)either;
            String error = (String)left.value();
            throw new LoadExternalResourceException("Cannot load from URL '" + urlString + "': " + error);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            URL urlToLoad = (URL)right.value();
            return urlToLoad;
        }
        throw new MatchError((Object)either);
    }

    private LoadCsvIterator getLoadCSVIterator(QueryState state, URL url, boolean useHeaders) {
        java.util.List ipBlocklist = (java.util.List)state.query().getConfig().get(GraphDatabaseInternalSettings.cypher_ip_blocklist);
        List ipBlocklistAsScala = ipBlocklist != null ? CollectionConverters$.MODULE$.ListHasAsScala(ipBlocklist).asScala().toList() : package$.MODULE$.List().empty();
        return state.resources().getCsvIterator(url, (List<IPAddressString>)ipBlocklistAsScala, this.fieldTerminator, this.legacyCsvQuoteEscaping, this.bufferSize, useHeaders);
    }

    @Override
    public ClosingIterator<CypherRow> internalCreateResults(ClosingIterator<CypherRow> input, QueryState state) {
        return input.flatMap((Function1 & Serializable)row -> {
            TextValue urlString = (TextValue)$this.urlExpression.apply((ReadableRow)row, state);
            URL url = this.getImportURL(urlString.stringValue(), state.query());
            CSVFormat cSVFormat = $this.format;
            if (HasHeaders$.MODULE$.equals(cSVFormat)) {
                LoadCsvIterator iterator = this.getLoadCSVIterator(state, url, true);
                IndexedSeq headers = ((ClosingIterator)iterator).nonEmpty() ? ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])((ClosingIterator)iterator).next())) : (IndexedSeq)package$.MODULE$.IndexedSeq().empty();
                return new IteratorWithHeaders(this, (Seq<Value>)this.replaceNoValues((IndexedSeq<Value>)headers), (CypherRow)row, url.getFile(), iterator);
            }
            if (NoHeaders$.MODULE$.equals(cSVFormat)) {
                return new IteratorWithoutHeaders(this, (CypherRow)row, url.getFile(), this.getLoadCSVIterator(state, url, false));
            }
            throw new MatchError((Object)cSVFormat);
        });
    }

    private IndexedSeq<Value> replaceNoValues(IndexedSeq<Value> headers) {
        return (IndexedSeq)headers.map((Function1 & Serializable)x0$1 -> {
            Value value = x0$1;
            if (value == Values.NO_VALUE) {
                return Values.stringValue((String)"");
            }
            return value;
        });
    }

    public AbstractLoadCSVPipe(Pipe source, CSVFormat format, Expression urlExpression, Option<String> fieldTerminator, boolean legacyCsvQuoteEscaping, int bufferSize) {
        this.format = format;
        this.urlExpression = urlExpression;
        this.fieldTerminator = fieldTerminator;
        this.legacyCsvQuoteEscaping = legacyCsvQuoteEscaping;
        this.bufferSize = bufferSize;
        super(source);
    }

    private class IteratorWithHeaders
    extends ClosingIterator<CypherRow> {
        private final CypherRow argumentRow;
        private final String filename;
        private final LoadCsvIterator inner;
        private final ArrayBackedMap<String, AnyValue> internalMap;
        private final long internalMapSize;
        private CypherRow newRow;
        private boolean needsUpdate;
        public final /* synthetic */ AbstractLoadCSVPipe $outer;

        private ArrayBackedMap<String, AnyValue> internalMap() {
            return this.internalMap;
        }

        private long internalMapSize() {
            return this.internalMapSize;
        }

        private CypherRow newRow() {
            return this.newRow;
        }

        private void newRow_$eq(CypherRow x$1) {
            this.newRow = x$1;
        }

        private boolean needsUpdate() {
            return this.needsUpdate;
        }

        private void needsUpdate_$eq(boolean x$1) {
            this.needsUpdate = x$1;
        }

        public void closeMore() {
            ((ClosingIterator)this.inner).close();
        }

        public boolean innerHasNext() {
            if (this.needsUpdate()) {
                this.newRow_$eq(this.computeNextRow());
                this.needsUpdate_$eq(false);
            }
            return this.newRow() != null;
        }

        public CypherRow next() {
            Object object = !this.hasNext() ? package$.MODULE$.Iterator().empty().next() : BoxedUnit.UNIT;
            this.needsUpdate_$eq(true);
            return this.newRow();
        }

        private CypherRow computeNextRow() {
            if (((ClosingIterator)this.inner).hasNext()) {
                Value[] row = (Value[])((ClosingIterator)this.inner).next();
                this.internalMap().putValues((Object)((AnyValue[])row));
                java.util.Map internalMapCopy = CollectionConverters$.MODULE$.MapHasAsJava((Map)this.internalMap().copy()).asJava();
                long payloadSize = 0L;
                for (int i = 0; i < row.length; ++i) {
                    payloadSize += row[i].estimatedHeapUsage();
                }
                MapValue mapValue = VirtualValues.fromMap((java.util.Map)internalMapCopy, (long)this.internalMapSize(), (long)payloadSize);
                return this.org$neo4j$cypher$internal$runtime$interpreted$pipes$AbstractLoadCSVPipe$IteratorWithHeaders$$$outer().writeRow(this.filename, this.inner.lastProcessed(), this.inner.readAll(), this.argumentRow, (AnyValue)mapValue);
            }
            return null;
        }

        public /* synthetic */ AbstractLoadCSVPipe org$neo4j$cypher$internal$runtime$interpreted$pipes$AbstractLoadCSVPipe$IteratorWithHeaders$$$outer() {
            return this.$outer;
        }

        public IteratorWithHeaders(AbstractLoadCSVPipe $outer, Seq<Value> headers, CypherRow argumentRow, String filename, LoadCsvIterator inner) {
            this.argumentRow = argumentRow;
            this.filename = filename;
            this.inner = inner;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.internalMap = new ArrayBackedMap(((IterableOnceOps)((IterableOps)headers.map((Function1 & Serializable)a -> {
                if (a == Values.NO_VALUE) {
                    return null;
                }
                return ((TextValue)a).stringValue();
            })).zipWithIndex()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)Values.NO_VALUE, ClassTag$.MODULE$.apply(AnyValue.class));
            this.internalMapSize = ArrayBackedMap$.MODULE$.SHALLOW_SIZE() + HeapEstimator.shallowSizeOfObjectArray((int)headers.size());
            this.needsUpdate = true;
        }
    }

    private class IteratorWithoutHeaders
    extends ClosingIterator<CypherRow> {
        private final CypherRow argumentRow;
        private final String filename;
        private final LoadCsvIterator inner;
        public final /* synthetic */ AbstractLoadCSVPipe $outer;

        public void closeMore() {
            ((ClosingIterator)this.inner).close();
        }

        public boolean innerHasNext() {
            return ((ClosingIterator)this.inner).hasNext();
        }

        public CypherRow next() {
            ListValue value = VirtualValues.list((AnyValue[])((AnyValue[])((ClosingIterator)this.inner).next()));
            return this.org$neo4j$cypher$internal$runtime$interpreted$pipes$AbstractLoadCSVPipe$IteratorWithoutHeaders$$$outer().writeRow(this.filename, this.inner.lastProcessed(), this.inner.readAll(), this.argumentRow, (AnyValue)value);
        }

        public /* synthetic */ AbstractLoadCSVPipe org$neo4j$cypher$internal$runtime$interpreted$pipes$AbstractLoadCSVPipe$IteratorWithoutHeaders$$$outer() {
            return this.$outer;
        }

        public IteratorWithoutHeaders(AbstractLoadCSVPipe $outer, CypherRow argumentRow, String filename, LoadCsvIterator inner) {
            this.argumentRow = argumentRow;
            this.filename = filename;
            this.inner = inner;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

