/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.function.Predicates;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexSamplingMode;
import org.neo4j.kernel.impl.api.index.IndexingService;

public class IndexProcedures {
    private final KernelTransaction ktx;
    private final IndexingService indexingService;

    public IndexProcedures(KernelTransaction tx, IndexingService indexingService) {
        this.ktx = tx;
        this.indexingService = indexingService;
    }

    void awaitIndexByName(String indexName, long timeout, TimeUnit timeoutUnits) throws ProcedureException {
        IndexDescriptor index = this.getIndex(indexName);
        this.waitUntilOnline(index, timeout, timeoutUnits);
    }

    void resampleIndex(String indexName) throws ProcedureException {
        IndexDescriptor index = this.getIndex(indexName);
        this.triggerSampling(index);
    }

    void resampleOutdatedIndexes() {
        this.indexingService.triggerIndexSampling(IndexSamplingMode.backgroundRebuildUpdated());
    }

    void resampleOutdatedIndexes(long timeOutSeconds) {
        long millis = TimeUnit.SECONDS.toMillis(timeOutSeconds);
        IndexSamplingMode mode = IndexSamplingMode.foregroundRebuildUpdated((long)millis);
        this.indexingService.triggerIndexSampling(mode);
    }

    private IndexDescriptor getIndex(String indexName) throws ProcedureException {
        IndexDescriptor indexReference = this.ktx.schemaRead().indexGetForName(indexName);
        if (indexReference == IndexDescriptor.NO_INDEX) {
            throw new ProcedureException((Status)Status.Schema.IndexNotFound, "No such index '%s'", new Object[]{indexName});
        }
        return indexReference;
    }

    private void waitUntilOnline(IndexDescriptor index, long timeout, TimeUnit timeoutUnits) throws ProcedureException {
        try {
            Predicates.awaitEx(() -> this.isOnline(index), (long)timeout, (TimeUnit)timeoutUnits);
        }
        catch (TimeoutException e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureTimedOut, "Index on '%s' did not come online within %s %s", new Object[]{index.userDescription((TokenNameLookup)this.ktx.tokenRead()), timeout, timeoutUnits});
        }
    }

    private boolean isOnline(IndexDescriptor index) throws ProcedureException {
        InternalIndexState state = this.getState(index);
        switch (state) {
            case POPULATING: {
                return false;
            }
            case ONLINE: {
                return true;
            }
            case FAILED: {
                String cause = this.getFailure(index);
                throw new ProcedureException((Status)Status.Schema.IndexCreationFailed, IndexPopulationFailure.appendCauseOfFailure((String)"Index '%s' is in failed state.", (String)cause), new Object[]{index.getName()});
            }
        }
        throw new IllegalStateException("Unknown index state " + state);
    }

    private InternalIndexState getState(IndexDescriptor index) throws ProcedureException {
        try {
            return this.ktx.schemaRead().indexGetState(index);
        }
        catch (IndexNotFoundKernelException e) {
            throw new ProcedureException((Status)Status.Schema.IndexNotFound, (Throwable)e, "No such index %s", new Object[]{index.getName()});
        }
    }

    private String getFailure(IndexDescriptor index) throws ProcedureException {
        try {
            return this.ktx.schemaRead().indexGetFailure(index);
        }
        catch (IndexNotFoundKernelException e) {
            throw new ProcedureException((Status)Status.Schema.IndexNotFound, (Throwable)e, "No such index %s", new Object[]{index.getName()});
        }
    }

    private void triggerSampling(IndexDescriptor index) {
        this.indexingService.triggerIndexSampling(index, IndexSamplingMode.backgroundRebuildAll());
    }
}

