/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.routing;

import java.util.List;
import org.neo4j.collection.RawIterator;
import org.neo4j.dbms.routing.RoutingException;
import org.neo4j.dbms.routing.RoutingResult;
import org.neo4j.dbms.routing.RoutingService;
import org.neo4j.dbms.routing.result.ParameterNames;
import org.neo4j.dbms.routing.result.RoutingResultFormat;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.procedure.Mode;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public final class GetRoutingTableProcedure
implements CallableProcedure {
    private static final String NAME = "getRoutingTable";
    private static final String DESCRIPTION = "Returns the advertised bolt capable endpoints for a given database, divided by each endpoint's capabilities. For example an endpoint may serve read queries, write queries and/or future getRoutingTable requests.";
    private final RoutingService routingService;
    private final ProcedureSignature signature;
    private final InternalLog log;

    public GetRoutingTableProcedure(List<String> namespace, RoutingService routingService, InternalLogProvider logProvider) {
        this.routingService = routingService;
        this.signature = GetRoutingTableProcedure.buildSignature(namespace);
        this.log = logProvider.getLog(this.getClass());
    }

    public ProcedureSignature signature() {
        return this.signature;
    }

    public RawIterator<AnyValue[], ProcedureException> apply(Context ctx, AnyValue[] input, ResourceMonitor resourceMonitor) throws ProcedureException {
        String user = ctx.securityContext().subject().executingUser();
        String databaseName = this.extractDatabaseName(input);
        MapValue routingContext = GetRoutingTableProcedure.extractRoutingContext(input);
        try {
            RoutingResult result = this.routingService.route(databaseName, user, routingContext);
            this.log.info("Routing result for database %s and routing context %s is %s", new Object[]{databaseName, routingContext, result});
            return RawIterator.of((Object[])new AnyValue[][]{RoutingResultFormat.build((RoutingResult)result)});
        }
        catch (RoutingException ex) {
            throw new ProcedureException(ex.status(), (Throwable)ex, ex.getMessage(), new Object[0]);
        }
    }

    private String extractDatabaseName(AnyValue[] input) {
        AnyValue arg = input[1];
        if (arg == Values.NO_VALUE) {
            return null;
        }
        if (arg instanceof TextValue) {
            return ((TextValue)arg).stringValue();
        }
        throw new IllegalArgumentException("Illegal database name argument " + arg);
    }

    private static MapValue extractRoutingContext(AnyValue[] input) {
        AnyValue arg = input[0];
        if (arg == Values.NO_VALUE) {
            return MapValue.EMPTY;
        }
        if (arg instanceof MapValue) {
            return (MapValue)arg;
        }
        throw new IllegalArgumentException("Illegal routing context argument " + arg);
    }

    private static ProcedureSignature buildSignature(List<String> namespace) {
        return ProcedureSignature.procedureSignature((QualifiedName)new QualifiedName(namespace, NAME)).in(ParameterNames.CONTEXT.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTMap).in(ParameterNames.DATABASE.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTString, DefaultParameterValue.nullValue((Neo4jTypes.AnyType)Neo4jTypes.NTString)).out(ParameterNames.TTL.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).out(ParameterNames.SERVERS.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTMap)).mode(Mode.DBMS).description(DESCRIPTION).systemProcedure().allowExpiredCredentials().build();
    }
}

