/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.Historian;
import org.neo4j.shell.commands.Begin;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.Commit;
import org.neo4j.shell.commands.Connect;
import org.neo4j.shell.commands.Disconnect;
import org.neo4j.shell.commands.Exit;
import org.neo4j.shell.commands.Help;
import org.neo4j.shell.commands.History;
import org.neo4j.shell.commands.Impersonate;
import org.neo4j.shell.commands.Param;
import org.neo4j.shell.commands.Rollback;
import org.neo4j.shell.commands.Source;
import org.neo4j.shell.commands.SysInfo;
import org.neo4j.shell.commands.Use;
import org.neo4j.shell.parameter.ParameterService;
import org.neo4j.shell.printer.Printer;
import org.neo4j.shell.terminal.CypherShellTerminal;
import org.neo4j.util.VisibleForTesting;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CommandHelper {
    private final TreeMap<String, Command> commands = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    public CommandHelper(Printer printer, Historian historian, CypherShell cypherShell, CypherShellTerminal terminal, ParameterService parameters) {
        Command.Factory.Arguments args = new Command.Factory.Arguments(printer, historian, cypherShell, terminal, parameters);
        new CommandFactoryHelper().factoryByName().forEach((key, value) -> this.commands.put((String)key, value.executor(args)));
    }

    public Command getCommand(String name) {
        return this.commands.get(name);
    }

    public static String stripEnclosingBackTicks(String input) {
        if (input.startsWith("`") && input.endsWith("`")) {
            return input.substring(1, input.length() - 1);
        }
        return input;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class CommandFactoryHelper {
        private static final Map<Class<? extends Command>, Command.Factory> factoryMap = Map.ofEntries(Map.entry(Begin.class, new Begin.Factory()), Map.entry(Commit.class, new Commit.Factory()), Map.entry(Connect.class, new Connect.Factory()), Map.entry(Disconnect.class, new Disconnect.Factory()), Map.entry(Exit.class, new Exit.Factory()), Map.entry(Help.class, new Help.Factory()), Map.entry(History.class, new History.Factory()), Map.entry(Param.class, new Param.Factory()), Map.entry(Rollback.class, new Rollback.Factory()), Map.entry(Source.class, new Source.Factory()), Map.entry(Use.class, new Use.Factory()), Map.entry(Impersonate.class, new Impersonate.Factory()), Map.entry(SysInfo.class, new SysInfo.Factory()));
        private static final Map<String, Command.Factory> factoryByName = CommandFactoryHelper.buildFactoryByName();

        public Command.Factory factoryFor(Class<? extends Command> commandClass) {
            return factoryMap.get(commandClass);
        }

        public Command.Factory factoryByName(String name) {
            return factoryByName.get(name);
        }

        public Collection<Command.Factory> factories() {
            return factoryMap.values();
        }

        public Stream<Command.Metadata> metadata() {
            return factoryMap.values().stream().map(Command.Factory::metadata);
        }

        public Map<String, Command.Factory> factoryByName() {
            return factoryByName;
        }

        @VisibleForTesting
        protected Map<Class<? extends Command>, Command.Factory> factoryByClass() {
            return factoryMap;
        }

        private static Map<String, Command.Factory> buildFactoryByName() {
            HashMap<String, Command.Factory> builder = new HashMap<String, Command.Factory>();
            for (Command.Factory factory : factoryMap.values()) {
                Command.Metadata metadata = factory.metadata();
                builder.put(metadata.name(), factory);
                metadata.aliases().forEach(alias -> builder.put((String)alias, factory));
            }
            return Map.copyOf(builder);
        }
    }
}

