/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.parser.ShellStatementParser;
import org.neo4j.shell.parser.StatementParser;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Source
implements Command {
    private final CypherShell cypherShell;
    private final StatementParser statementParser;

    public Source(CypherShell cypherShell, StatementParser statementParser) {
        this.cypherShell = cypherShell;
        this.statementParser = statementParser;
    }

    @Override
    public void execute(List<String> args) throws ExitException, CommandException {
        this.requireArgumentCount(args, 1);
        String filename = args.get(0);
        try (InputStreamReader reader = new InputStreamReader(new FileInputStream(filename));){
            this.cypherShell.execute(this.statementParser.parse(reader).statements());
        }
        catch (IOException e) {
            throw new CommandException(String.format("Cannot find file: '%s'", filename), e);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Factory
    implements Command.Factory {
        @Override
        public Command.Metadata metadata() {
            String description = "Executes Cypher statements from a file";
            String help = "Executes Cypher statements from a file";
            return new Command.Metadata(":source", description, "[filename]", help, List.of());
        }

        @Override
        public Command executor(Command.Factory.Arguments args) {
            return new Source(args.cypherShell(), new ShellStatementParser());
        }
    }
}

