/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.concurrent.atomic.LongAdder;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.DataImporter;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.util.IdGeneratorUpdatesWorkSync;
import org.neo4j.storageengine.util.IdUpdateListener;

public class DeleteDuplicateNodesStep
extends ProcessorStep<long[]> {
    private final NodeStore nodeStore;
    private final PropertyStore propertyStore;
    private final DataImporter.Monitor storeMonitor;
    private final IdGeneratorUpdatesWorkSync idUpdatesWorkSync;
    private final NeoStores neoStores;
    private final LongAdder nodesRemoved = new LongAdder();
    private final LongAdder propertiesRemoved = new LongAdder();

    public DeleteDuplicateNodesStep(StageControl control, Configuration config, NeoStores neoStores, DataImporter.Monitor storeMonitor, CursorContextFactory contextFactory, IdGeneratorUpdatesWorkSync idUpdatesWorkSync) {
        super(control, "DEDUP", config, 0, contextFactory, new StatsProvider[0]);
        this.neoStores = neoStores;
        this.nodeStore = neoStores.getNodeStore();
        this.propertyStore = neoStores.getPropertyStore();
        this.storeMonitor = storeMonitor;
        this.idUpdatesWorkSync = idUpdatesWorkSync;
    }

    protected void process(long[] batch, BatchSender sender, CursorContext cursorContext) throws Throwable {
        NodeRecord nodeRecord = (NodeRecord)this.nodeStore.newRecord();
        PropertyRecord propertyRecord = this.propertyStore.newRecord();
        try (CachedStoreCursors storeCursors = new CachedStoreCursors(this.neoStores, cursorContext);
             IdGeneratorUpdatesWorkSync.Batch idUpdates = this.idUpdatesWorkSync.newBatch(cursorContext);){
            long batchPropertiesRemoved = 0L;
            for (long duplicateNodeId : batch) {
                this.nodeStore.getRecordByCursor(duplicateNodeId, nodeRecord, RecordLoad.NORMAL, storeCursors.readCursor(RecordCursorTypes.NODE_CURSOR));
                assert (nodeRecord.inUse()) : nodeRecord;
                this.nodeStore.ensureHeavy(nodeRecord, (StoreCursors)storeCursors);
                long nextProp = nodeRecord.getNextProp();
                while (!Record.NULL_REFERENCE.is(nextProp)) {
                    this.propertyStore.getRecordByCursor(nextProp, propertyRecord, RecordLoad.NORMAL, storeCursors.readCursor(RecordCursorTypes.PROPERTY_CURSOR));
                    assert (propertyRecord.inUse()) : propertyRecord + " for " + nodeRecord;
                    this.propertyStore.ensureHeavy(propertyRecord, (StoreCursors)storeCursors);
                    batchPropertiesRemoved += (long)propertyRecord.numberOfProperties();
                    nextProp = propertyRecord.getNextProp();
                    DeleteDuplicateNodesStep.deletePropertyRecordIncludingValueRecords(propertyRecord);
                    PageCursor propertyWriteCursor = storeCursors.writeCursor(RecordCursorTypes.PROPERTY_CURSOR);
                    try {
                        this.propertyStore.updateRecord(propertyRecord, (IdUpdateListener)idUpdates, propertyWriteCursor, cursorContext, (StoreCursors)storeCursors);
                    }
                    finally {
                        if (propertyWriteCursor == null) continue;
                        propertyWriteCursor.close();
                    }
                }
                nodeRecord.setInUse(false);
                for (DynamicRecord labelRecord : nodeRecord.getDynamicLabelRecords()) {
                    labelRecord.setInUse(false);
                }
                try (PageCursor nodeWriteCursor = storeCursors.writeCursor(RecordCursorTypes.NODE_CURSOR);){
                    this.nodeStore.updateRecord(nodeRecord, (IdUpdateListener)idUpdates, nodeWriteCursor, cursorContext, (StoreCursors)storeCursors);
                }
            }
            this.propertiesRemoved.add(batchPropertiesRemoved);
            this.nodesRemoved.add(batch.length);
        }
    }

    private static void deletePropertyRecordIncludingValueRecords(PropertyRecord record) {
        for (PropertyBlock block : record) {
            for (DynamicRecord valueRecord : block.getValueRecords()) {
                assert (valueRecord.inUse());
                valueRecord.setInUse(false);
                record.addDeletedRecord(valueRecord);
            }
        }
        record.clearPropertyBlocks();
        record.setInUse(false);
    }

    public void close() throws Exception {
        super.close();
        this.storeMonitor.nodesRemoved(this.nodesRemoved.sum());
        this.storeMonitor.propertiesRemoved(this.propertiesRemoved.sum());
    }
}

