/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.Function;
import org.neo4j.common.EntityType;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.IndexImporter;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.batchimport.IndexWriterStep;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class LabelIndexWriterStep
extends IndexWriterStep<NodeRecord[]> {
    private static final String LABEL_INDEX_WRITE_STEP_TAG = "labelIndexWriteStep";
    private final long fromNodeId;
    private final CursorContext cursorContext;
    private final IndexImporter importer;
    private final NodeStore nodeStore;
    private final StoreCursors cachedStoreCursors;
    private final IndexImporter.Writer writer;

    public LabelIndexWriterStep(StageControl control, Configuration config, BatchingNeoStores neoStores, IndexImporterFactory indexImporterFactory, long fromNodeId, MemoryTracker memoryTracker, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, Function<CursorContext, StoreCursors> storeCursorsCreator) {
        super(control, "LABEL INDEX", config, 1, contextFactory);
        this.fromNodeId = fromNodeId;
        this.cursorContext = contextFactory.create(LABEL_INDEX_WRITE_STEP_TAG);
        this.importer = this.indexImporter(config.indexConfig(), indexImporterFactory, neoStores, EntityType.NODE, memoryTracker, contextFactory, pageCacheTracer, storeCursorsCreator);
        this.writer = this.importer.writer(false);
        this.cachedStoreCursors = storeCursorsCreator.apply(this.cursorContext);
        this.nodeStore = neoStores.getNodeStore();
    }

    protected void process(NodeRecord[] batch, BatchSender sender, CursorContext cursorContext) throws Throwable {
        this.cachedStoreCursors.reset(cursorContext);
        for (NodeRecord node : batch) {
            if (!node.inUse() || node.getId() < this.fromNodeId) continue;
            this.writer.add(node.getId(), NodeLabelsField.get(node, this.nodeStore, this.cachedStoreCursors));
        }
        sender.send((Object)batch);
    }

    public void close() throws Exception {
        super.close();
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.writer, this.importer, this.cursorContext, this.cachedStoreCursors});
    }
}

