/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.IOException;
import org.neo4j.internal.batchimport.InputIterator;
import org.neo4j.internal.batchimport.input.InputChunk;
import org.neo4j.internal.batchimport.input.LenientStoreInputChunk;
import org.neo4j.kernel.impl.store.CommonAbstractStore;

public abstract class LenientInputChunkIterator
implements InputIterator {
    private final int batchSize;
    private final long highId;
    private long id;

    LenientInputChunkIterator(CommonAbstractStore<?, ?> store) {
        this.batchSize = store.getRecordsPerPage() * 10;
        try {
            this.highId = (long)store.getRecordsPerPage() * (store.getLastPageId() + 1L);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized boolean next(InputChunk chunk) {
        if (this.id >= this.highId) {
            return false;
        }
        long startId = this.id;
        this.id = Long.min(this.highId, startId + (long)this.batchSize);
        ((LenientStoreInputChunk)chunk).setChunkRange(startId, this.id);
        return true;
    }

    public void close() {
    }
}

