/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.store;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Predicate;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.pagecache.ConfigurableIOBufferFactory;
import org.neo4j.counts.CountsStore;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.store.PageCacheFlusher;
import org.neo4j.internal.batchimport.store.io.IoTracer;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.CountsStoreProvider;
import org.neo4j.internal.counts.DegreeStoreProvider;
import org.neo4j.internal.counts.GBPTreeRelationshipGroupDegreesStore;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseFile;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.os.OsBeanUtil;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.store.DynamicAllocatorProvider;
import org.neo4j.kernel.impl.store.DynamicAllocatorProviders;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.PageCacheOptionsSelector;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.RecordStorageCapability;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.transaction.log.LogTailLogVersionsMetadata;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.token.TokenHolders;

public class BatchingNeoStores
implements AutoCloseable,
MemoryStatsVisitor.Visitable {
    static final long MAX_PAGE_CACHE_MEMORY = ByteUnit.gibiBytes((long)1L);
    private static final String BATCHING_STORE_CREATION_TAG = "batchingStoreCreation";
    private static final String BATCHING_STORE_SHUTDOWN_TAG = "batchingStoreShutdown";
    private static final String TEMP_STORE_NAME = "temp";
    static final long DOUBLE_RELATIONSHIP_RECORD_UNIT_THRESHOLD = 0x200000000L;
    private static final StoreType[] TEMP_STORE_TYPES = new StoreType[]{StoreType.RELATIONSHIP_GROUP, StoreType.PROPERTY, StoreType.PROPERTY_ARRAY, StoreType.PROPERTY_STRING};
    private final FileSystemAbstraction fileSystem;
    private final InternalLogProvider internalLogProvider;
    private final InternalLogProvider userLogProvider;
    private final RecordDatabaseLayout databaseLayout;
    private final RecordDatabaseLayout temporaryDatabaseLayout;
    private final Config neo4jConfig;
    private final Configuration importConfiguration;
    private final PageCache pageCache;
    private final IoTracer ioTracer;
    private final RecordFormats recordFormats;
    private final AdditionalInitialIds initialIds;
    private final boolean externalPageCache;
    private final IdGeneratorFactory idGeneratorFactory;
    private final IdGeneratorFactory tempIdGeneratorFactory;
    private final CursorContextFactory contextFactory;
    private final MemoryTracker memoryTracker;
    private final String databaseName;
    private final ImmutableSet<OpenOption> openOptions;
    private final PageCacheTracer pageCacheTracer;
    private NeoStores neoStores;
    private NeoStores temporaryNeoStores;
    private TokenHolders tokenHolders;
    private PageCacheFlusher flusher;
    private final LogTailLogVersionsMetadata logTailMetadata;
    private boolean doubleRelationshipRecordUnits;
    private boolean successful;

    private BatchingNeoStores(FileSystemAbstraction fileSystem, PageCache pageCache, RecordDatabaseLayout databaseLayout, Config neo4jConfig, Configuration importConfiguration, LogService logService, AdditionalInitialIds initialIds, LogTailLogVersionsMetadata logTailMetadata, boolean externalPageCache, IoTracer ioTracer, CursorContextFactory contextFactory, MemoryTracker memoryTracker, PageCacheTracer pageCacheTracer) {
        this.fileSystem = fileSystem;
        this.recordFormats = RecordFormatSelector.selectForStoreOrConfigForNewDbs(neo4jConfig, databaseLayout, fileSystem, pageCache, logService.getInternalLogProvider(), contextFactory);
        this.importConfiguration = importConfiguration;
        this.initialIds = initialIds;
        this.internalLogProvider = logService.getInternalLogProvider();
        this.userLogProvider = logService.getUserLogProvider();
        this.databaseLayout = databaseLayout;
        this.temporaryDatabaseLayout = RecordDatabaseLayout.ofFlat((Path)databaseLayout.file(TEMP_STORE_NAME));
        this.neo4jConfig = neo4jConfig;
        this.pageCache = pageCache;
        this.ioTracer = ioTracer;
        this.externalPageCache = externalPageCache;
        this.databaseName = databaseLayout.getDatabaseName();
        this.idGeneratorFactory = new DefaultIdGeneratorFactory(fileSystem, RecoveryCleanupWorkCollector.immediate(), pageCacheTracer, this.databaseName);
        this.tempIdGeneratorFactory = new DefaultIdGeneratorFactory(fileSystem, RecoveryCleanupWorkCollector.immediate(), pageCacheTracer, this.databaseName);
        this.contextFactory = contextFactory;
        this.memoryTracker = memoryTracker;
        this.logTailMetadata = logTailMetadata;
        this.pageCacheTracer = pageCacheTracer;
        this.openOptions = PageCacheOptionsSelector.select(this.recordFormats);
    }

    public void createNew() throws IOException {
        this.assertDatabaseIsNonExistent();
        this.deleteIndexes();
        this.deleteCountsStore();
        this.instantiateStores();
    }

    private void deleteIndexes() throws IOException {
        Path indexDirectory = IndexDirectoryStructure.baseSchemaIndexFolder((Path)this.databaseLayout.databaseDirectory());
        this.fileSystem.deleteRecursively(indexDirectory);
    }

    private void deleteCountsStore() throws IOException {
        if (this.fileSystem.fileExists(this.databaseLayout.countStore())) {
            this.fileSystem.deleteFile(this.databaseLayout.countStore());
        }
    }

    public void assertDatabaseIsNonExistent() throws DirectoryNotEmptyException {
        if (this.hasExistingDatabaseContents()) {
            throw new DirectoryNotEmptyException(this.databaseLayout.databaseDirectory() + " already contains data, cannot do import here");
        }
        if (this.hasExistingTransactionContents()) {
            throw new DirectoryNotEmptyException(this.databaseLayout.getTransactionLogsDirectory() + " already contains data, cannot do import here");
        }
    }

    private boolean hasExistingTransactionContents() {
        TransactionLogFilesHelper logFilesHelper = new TransactionLogFilesHelper(this.fileSystem, this.databaseLayout.getTransactionLogsDirectory());
        TransactionLogFilesHelper checkpointFilesHelper = new TransactionLogFilesHelper(this.fileSystem, this.databaseLayout.getTransactionLogsDirectory(), "checkpoint");
        try {
            return logFilesHelper.getMatchedFiles().length > 0 || checkpointFilesHelper.getMatchedFiles().length > 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean hasExistingDatabaseContents() {
        Path metaDataFile = this.databaseLayout.metadataStore();
        try {
            PagedFile pagedFile = this.pageCache.map(metaDataFile, this.pageCache.pageSize(), this.databaseName, Sets.immutable.of((Object)StandardOpenOption.READ));
            if (pagedFile != null) {
                pagedFile.close();
            }
        }
        catch (IOException e) {
            return false;
        }
        try (NeoStores stores = this.newStoreFactory(this.databaseLayout, this.idGeneratorFactory, this.contextFactory, (ImmutableSet<OpenOption>)Sets.immutable.empty()).openNeoStores(StoreType.NODE, StoreType.RELATIONSHIP);){
            boolean bl = stores.getNodeStore().getIdGenerator().getHighId() > 0L || stores.getRelationshipStore().getIdGenerator().getHighId() > 0L;
            return bl;
        }
    }

    public void pruneAndOpenExistingStore(Predicate<StoreType> mainStoresToKeep, Predicate<StoreType> tempStoresToKeep) throws IOException {
        this.deleteStoreFiles((DatabaseLayout)this.temporaryDatabaseLayout, tempStoresToKeep);
        this.deleteStoreFiles((DatabaseLayout)this.databaseLayout, mainStoresToKeep);
        this.instantiateStores();
    }

    private void deleteStoreFiles(DatabaseLayout databaseLayout, Predicate<StoreType> storesToKeep) {
        for (StoreType type : StoreType.STORE_TYPES) {
            if (storesToKeep.test(type)) continue;
            RecordDatabaseFile databaseFile = type.getDatabaseFile();
            databaseLayout.allFiles((DatabaseFile)databaseFile).forEach(IOUtils.uncheckedConsumer(arg_0 -> ((FileSystemAbstraction)this.fileSystem).deleteFile(arg_0)));
        }
    }

    private void instantiateStores() throws IOException {
        this.neoStores = this.newStoreFactory(this.databaseLayout, this.idGeneratorFactory, this.contextFactory, (ImmutableSet<OpenOption>)Sets.immutable.empty()).openAllNeoStores();
        DynamicAllocatorProvider allocatorProvider = DynamicAllocatorProviders.nonTransactionalAllocator(this.neoStores);
        this.tokenHolders = StoreTokens.directTokenHolders(this.neoStores, allocatorProvider, this.contextFactory, this.memoryTracker);
        this.temporaryNeoStores = this.instantiateTempStores();
        try (CursorContext cursorContext = this.contextFactory.create(BATCHING_STORE_CREATION_TAG);){
            this.neoStores.start(cursorContext);
            this.temporaryNeoStores.start(cursorContext);
            MetaDataStore metaDataStore = this.neoStores.getMetaDataStore();
            metaDataStore.setLastCommittedAndClosedTransactionId(this.initialIds.lastCommittedTransactionId(), this.initialIds.lastCommittedTransactionChecksum(), 0L, -1L, this.initialIds.lastCommittedTransactionLogByteOffset(), this.initialIds.lastCommittedTransactionLogVersion());
            metaDataStore.setCheckpointLogVersion(this.initialIds.checkpointLogVersion());
        }
    }

    private NeoStores instantiateTempStores() {
        return this.newStoreFactory(this.temporaryDatabaseLayout, this.tempIdGeneratorFactory, this.contextFactory, (ImmutableSet<OpenOption>)Sets.immutable.empty()).openNeoStores(TEMP_STORE_TYPES);
    }

    public static BatchingNeoStores batchingNeoStores(FileSystemAbstraction fileSystem, RecordDatabaseLayout databaseLayout, Configuration config, LogService logService, AdditionalInitialIds initialIds, LogTailLogVersionsMetadata logTailMetadata, Config dbConfig, JobScheduler jobScheduler, PageCacheTracer pageCacheTracer, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        Config neo4jConfig = BatchingNeoStores.getNeo4jConfig(dbConfig);
        PageCache pageCache = BatchingNeoStores.createPageCache(fileSystem, neo4jConfig, pageCacheTracer, jobScheduler, memoryTracker);
        return new BatchingNeoStores(fileSystem, pageCache, databaseLayout, neo4jConfig, config, logService, initialIds, logTailMetadata, false, () -> ((PageCacheTracer)pageCacheTracer).bytesWritten(), contextFactory, memoryTracker, pageCacheTracer);
    }

    public static BatchingNeoStores batchingNeoStoresWithExternalPageCache(FileSystemAbstraction fileSystem, PageCache pageCache, PageCacheTracer tracer, CursorContextFactory contextFactory, RecordDatabaseLayout databaseLayout, Configuration config, LogService logService, AdditionalInitialIds initialIds, LogTailLogVersionsMetadata logTailMetadata, Config dbConfig, MemoryTracker memoryTracker) {
        return new BatchingNeoStores(fileSystem, pageCache, databaseLayout, BatchingNeoStores.getNeo4jConfig(dbConfig), config, logService, initialIds, logTailMetadata, true, () -> ((PageCacheTracer)tracer).bytesWritten(), contextFactory, memoryTracker, tracer);
    }

    private static Config getNeo4jConfig(Config dbConfig) {
        dbConfig.set(GraphDatabaseSettings.pagecache_memory, (Object)BatchingNeoStores.pageCacheMemory(dbConfig));
        dbConfig.set(GraphDatabaseSettings.check_point_iops_limit, (Object)-1);
        return dbConfig;
    }

    private static long pageCacheMemory(Config dbConfig) {
        Long fromSetting = (Long)dbConfig.get(GraphDatabaseSettings.pagecache_memory);
        if (fromSetting != null) {
            return Long.min(MAX_PAGE_CACHE_MEMORY, fromSetting);
        }
        long maxFreeMemory = OsBeanUtil.getFreePhysicalMemory();
        if (0L < maxFreeMemory && maxFreeMemory < Long.MAX_VALUE) {
            return Math.min(MAX_PAGE_CACHE_MEMORY, maxFreeMemory);
        }
        return MAX_PAGE_CACHE_MEMORY;
    }

    private static PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, PageCacheTracer tracer, JobScheduler jobScheduler, MemoryTracker memoryTracker) {
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory(fileSystem, tracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        MemoryAllocator memoryAllocator = MemoryAllocator.createAllocator((long)((Long)config.get(GraphDatabaseSettings.pagecache_memory)), (MemoryTracker)memoryTracker);
        MuninnPageCache.Configuration configuration = MuninnPageCache.config((MemoryAllocator)memoryAllocator).pageCacheTracer(tracer).memoryTracker(memoryTracker).bufferFactory((IOBufferFactory)new ConfigurableIOBufferFactory(config, memoryTracker)).faultLockStriping(2048).reservedPageBytes(16).disableEvictionThread();
        return new MuninnPageCache((PageSwapperFactory)swapperFactory, jobScheduler, configuration);
    }

    private StoreFactory newStoreFactory(RecordDatabaseLayout databaseLayout, IdGeneratorFactory idGeneratorFactory, CursorContextFactory contextFactory, ImmutableSet<OpenOption> openOptions) {
        return new StoreFactory((DatabaseLayout)databaseLayout, this.neo4jConfig, idGeneratorFactory, this.pageCache, this.pageCacheTracer, this.fileSystem, this.recordFormats, this.internalLogProvider, contextFactory, false, this.logTailMetadata, openOptions);
    }

    public RecordStore<RelationshipGroupRecord> getTemporaryRelationshipGroupStore() {
        return this.temporaryNeoStores.getRelationshipGroupStore();
    }

    public PropertyStore getTemporaryPropertyStore() {
        return this.temporaryNeoStores.getPropertyStore();
    }

    public IoTracer getIoTracer() {
        return this.ioTracer;
    }

    public NodeStore getNodeStore() {
        return this.neoStores.getNodeStore();
    }

    public PropertyStore getPropertyStore() {
        return this.neoStores.getPropertyStore();
    }

    public RelationshipStore getRelationshipStore() {
        return this.neoStores.getRelationshipStore();
    }

    public RelationshipGroupStore getRelationshipGroupStore() {
        return this.neoStores.getRelationshipGroupStore();
    }

    public void buildCountsStore(CountsBuilder builder, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        FileFlushEvent flushEvent;
        CursorContext cursorContext;
        try {
            this.deleteCountsStore();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try (CountsStore countsStore = this.openCountsStore(this.pageCache, this.fileSystem, this.databaseLayout, this.userLogProvider, RecoveryCleanupWorkCollector.immediate(), builder, this.neo4jConfig, contextFactory, this.pageCacheTracer);){
            cursorContext = contextFactory.create("buildCountsStore");
            try {
                countsStore.start(cursorContext, memoryTracker);
                flushEvent = this.pageCacheTracer.beginFileFlush();
                try {
                    countsStore.checkpoint(flushEvent, cursorContext);
                }
                finally {
                    if (flushEvent != null) {
                        flushEvent.close();
                    }
                }
            }
            finally {
                if (cursorContext != null) {
                    cursorContext.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try (RelationshipGroupDegreesStore groupDegreesStore = DegreeStoreProvider.getInstance().openDegreesStore(this.pageCache, this.fileSystem, this.databaseLayout, this.userLogProvider, RecoveryCleanupWorkCollector.immediate(), this.neo4jConfig, contextFactory, this.pageCacheTracer, new GBPTreeRelationshipGroupDegreesStore.EmptyDegreesRebuilder(this.neoStores.getMetaDataStore().getLastCommittedTransactionId()), this.openOptions, false);){
            cursorContext = contextFactory.create("buildRelationshipDegreesStore");
            try {
                groupDegreesStore.start(cursorContext, memoryTracker);
                flushEvent = this.pageCacheTracer.beginFileFlush();
                try {
                    groupDegreesStore.checkpoint(flushEvent, cursorContext);
                }
                finally {
                    if (flushEvent != null) {
                        flushEvent.close();
                    }
                }
            }
            finally {
                if (cursorContext != null) {
                    cursorContext.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private CountsStore openCountsStore(PageCache pageCache, FileSystemAbstraction fs, RecordDatabaseLayout layout, InternalLogProvider userLogProvider, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, CountsBuilder builder, Config config, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer) {
        return CountsStoreProvider.getInstance().openCountsStore(pageCache, fs, layout, userLogProvider, recoveryCleanupWorkCollector, config, contextFactory, pageCacheTracer, this.getOpenOptions(), builder, false);
    }

    @Override
    public void close() throws IOException {
        this.markHighIds();
        if (this.flusher != null) {
            this.stopFlushingPageCache();
        }
        try (CursorContext cursorContext = this.contextFactory.create(BATCHING_STORE_SHUTDOWN_TAG);){
            this.flushAndForce(cursorContext);
        }
        IOUtils.closeAll((AutoCloseable[])new NeoStores[]{this.neoStores, this.temporaryNeoStores});
        if (!this.externalPageCache) {
            this.pageCache.close();
        }
        if (this.successful) {
            this.cleanup();
        }
    }

    public void markHighIds() {
        if (this.neoStores != null) {
            this.idGeneratorFactory.visit(IdGenerator::markHighestWrittenAtHighId);
        }
    }

    private void cleanup() throws IOException {
        Path tempDbDirectory = this.temporaryDatabaseLayout.databaseDirectory();
        if (!tempDbDirectory.getParent().equals(this.databaseLayout.databaseDirectory())) {
            throw new IllegalStateException("Temporary store is dislocated. It should be located under current database directory but instead located in: " + tempDbDirectory.getParent());
        }
        this.fileSystem.deleteRecursively(tempDbDirectory);
    }

    public long getLastCommittedTransactionId() {
        return this.neoStores.getMetaDataStore().getLastCommittedTransactionId();
    }

    public NeoStores getNeoStores() {
        return this.neoStores;
    }

    public NeoStores getTemporaryNeoStores() {
        return this.temporaryNeoStores;
    }

    public TokenHolders getTokenHolders() {
        return this.tokenHolders;
    }

    public void startFlushingPageCache() {
        if (this.importConfiguration.sequentialBackgroundFlushing()) {
            if (this.flusher != null) {
                throw new IllegalStateException("Flusher already started");
            }
            this.flusher = new PageCacheFlusher(this.pageCache);
            this.flusher.start();
        }
    }

    public void stopFlushingPageCache() {
        if (this.importConfiguration.sequentialBackgroundFlushing()) {
            if (this.flusher == null) {
                throw new IllegalStateException("Flusher not started");
            }
            this.flusher.halt();
            this.flusher = null;
        }
    }

    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        visitor.offHeapUsage(this.pageCache.maxCachedPages() * (long)this.pageCache.pageSize());
    }

    public PageCache getPageCache() {
        return this.pageCache;
    }

    public void flushAndForce(CursorContext cursorContext) throws IOException {
        if (this.neoStores != null) {
            this.neoStores.flush(DatabaseFlushEvent.NULL, cursorContext);
        }
        if (this.temporaryNeoStores != null) {
            this.temporaryNeoStores.flush(DatabaseFlushEvent.NULL, cursorContext);
        }
    }

    public FileSystemAbstraction fileSystem() {
        return this.fileSystem;
    }

    public DatabaseLayout databaseLayout() {
        return this.databaseLayout;
    }

    public RecordFormats recordFormats() {
        return this.recordFormats;
    }

    public void success() {
        this.successful = true;
    }

    public boolean determineDoubleRelationshipRecordUnits(Input.Estimates inputEstimates) {
        this.doubleRelationshipRecordUnits = this.recordFormats.hasCapability(RecordStorageCapability.SECONDARY_RECORD_UNITS) && inputEstimates.numberOfRelationships() > 0x200000000L;
        return this.doubleRelationshipRecordUnits;
    }

    public boolean usesDoubleRelationshipRecordUnits() {
        return this.doubleRelationshipRecordUnits;
    }

    public ImmutableSet<OpenOption> getOpenOptions() {
        return this.openOptions;
    }
}

