/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.store;

import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.util.concurrent.BinaryLatch;

class PageCacheFlusher
extends Thread {
    private final PageCache pageCache;
    private final BinaryLatch halt = new BinaryLatch();
    private volatile boolean halted;
    private volatile Throwable error;

    PageCacheFlusher(PageCache pageCache) {
        super("PageCacheFlusher");
        this.pageCache = pageCache;
    }

    @Override
    public void run() {
        try {
            while (!this.halted) {
                try {
                    this.pageCache.flushAndForce(DatabaseFlushEvent.NULL);
                }
                catch (Throwable e) {
                    this.error = e;
                    break;
                }
            }
        }
        finally {
            this.halt.release();
        }
    }

    void halt() {
        this.halted = true;
        this.halt.await();
        if (this.error != null) {
            Exceptions.throwIfUnchecked((Throwable)this.error);
            throw new RuntimeException(this.error);
        }
    }

    @VisibleForTesting
    public Throwable getError() {
        return this.error;
    }
}

