/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.counts.CountUpdater;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.internal.counts.DegreeUpdater;
import org.neo4j.internal.counts.DegreesRebuilder;
import org.neo4j.internal.counts.GBPTreeGenericCountsStore;
import org.neo4j.internal.counts.GroupDegreeVisitor;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipDirection;

public class GBPTreeRelationshipGroupDegreesStore
extends GBPTreeGenericCountsStore
implements RelationshipGroupDegreesStore {
    private static final String NAME = "Relationship group degrees store";
    static final byte TYPE_DEGREE = 3;

    public GBPTreeRelationshipGroupDegreesStore(PageCache pageCache, Path file, FileSystemAbstraction fileSystem, RecoveryCleanupWorkCollector recoveryCollector, DegreesRebuilder rebuilder, boolean readOnly, GBPTreeGenericCountsStore.Monitor monitor, String databaseName, int maxCacheSize, InternalLogProvider userLogProvider, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, ImmutableSet<OpenOption> openOptions) throws IOException {
        super(pageCache, file, fileSystem, recoveryCollector, (GBPTreeGenericCountsStore.Rebuilder)new RebuilderWrapper(rebuilder), readOnly, NAME, monitor, databaseName, maxCacheSize, userLogProvider, contextFactory, pageCacheTracer, openOptions);
    }

    public DegreeUpdater updater(long txId, boolean isLast, CursorContext cursorContext) {
        CountUpdater updater = this.updaterImpl(txId, isLast, cursorContext);
        return updater != null ? new TreeUpdater(updater) : DegreeUpdater.NO_OP_UPDATER;
    }

    public DegreeUpdater directApply(CursorContext cursorContext) throws IOException {
        return this.directApply(false, cursorContext);
    }

    public DegreeUpdater directApply(boolean applyDeltas, CursorContext cursorContext) throws IOException {
        return new TreeUpdater(this.directUpdater(applyDeltas, cursorContext));
    }

    public long degree(long groupId, RelationshipDirection direction, CursorContext cursorContext) {
        return this.read(GBPTreeRelationshipGroupDegreesStore.degreeKey(groupId, direction), cursorContext);
    }

    public void accept(GroupDegreeVisitor visitor, CursorContext cursorContext) {
        this.visitAllCounts((key, count) -> visitor.degree(GBPTreeRelationshipGroupDegreesStore.groupIdOf(key), GBPTreeRelationshipGroupDegreesStore.directionOf(key), count), cursorContext);
    }

    public void start(CursorContext cursorContext, MemoryTracker memoryTracker) throws IOException {
        super.start(cursorContext, memoryTracker);
    }

    static CountsKey degreeKey(long groupId, RelationshipDirection direction) {
        return new CountsKey(3, groupId << 2 | (long)direction.id(), 0);
    }

    static String keyToString(CountsKey key) {
        if (key.type == 3) {
            return String.format("Degree[groupId:%d, direction:%s]", GBPTreeRelationshipGroupDegreesStore.groupIdOf(key), GBPTreeRelationshipGroupDegreesStore.directionOf(key));
        }
        throw new IllegalArgumentException("Unknown type " + key.type);
    }

    private static RelationshipDirection directionOf(CountsKey key) {
        return RelationshipDirection.ofId((int)((int)(key.first & 3L)));
    }

    private static long groupIdOf(CountsKey key) {
        return key.first >> 2;
    }

    public static void dump(PageCache pageCache, FileSystemAbstraction fileSystem, Path file, PrintStream out, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, ImmutableSet<OpenOption> openOptions) throws IOException {
        GBPTreeGenericCountsStore.dump((PageCache)pageCache, (FileSystemAbstraction)fileSystem, (Path)file, (PrintStream)out, (String)"neo4j", (String)NAME, (CursorContextFactory)contextFactory, (PageCacheTracer)pageCacheTracer, GBPTreeRelationshipGroupDegreesStore::keyToString, openOptions);
    }

    private static class RebuilderWrapper
    implements GBPTreeGenericCountsStore.Rebuilder {
        private final DegreesRebuilder rebuilder;

        RebuilderWrapper(DegreesRebuilder rebuilder) {
            this.rebuilder = rebuilder;
        }

        public void rebuild(CountUpdater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
            this.rebuilder.rebuild((DegreeUpdater)new TreeUpdater(updater), cursorContext, memoryTracker);
        }

        public long lastCommittedTxId() {
            return this.rebuilder.lastCommittedTxId();
        }
    }

    private static class TreeUpdater
    implements DegreeUpdater,
    AutoCloseable {
        private final CountUpdater actual;

        TreeUpdater(CountUpdater actual) {
            this.actual = actual;
        }

        public void increment(long groupId, RelationshipDirection direction, long delta) {
            this.actual.increment(GBPTreeRelationshipGroupDegreesStore.degreeKey(groupId, direction), delta);
        }

        @Override
        public void close() {
            this.actual.close();
        }
    }

    public static class EmptyDegreesRebuilder
    implements DegreesRebuilder {
        private final long lastTxId;

        public EmptyDegreesRebuilder(long lastTxId) {
            this.lastTxId = lastTxId;
        }

        public void rebuild(DegreeUpdater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
        }

        public long lastCommittedTxId() {
            return this.lastTxId;
        }
    }
}

