/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.RecordRelationshipScanCursor;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplierFactory;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.storageengine.api.CommandBatchToApply;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.util.Preconditions;

class ConsistencyCheckingApplierFactory
implements TransactionApplierFactory {
    private final NeoStores neoStores;

    ConsistencyCheckingApplierFactory(NeoStores neoStores) {
        this.neoStores = neoStores;
    }

    @Override
    public TransactionApplier startTx(CommandBatchToApply transaction, BatchContext batchContext) {
        return new ConsistencyCheckingApplier(this.neoStores, transaction.cursorContext());
    }

    static class ConsistencyCheckingApplier
    extends TransactionApplier.Adapter {
        private final MutableLongSet touchedRelationshipIds = LongSets.mutable.empty();
        private final RecordRelationshipScanCursor cursor;
        private final RecordRelationshipScanCursor otherCursor;
        private final CachedStoreCursors storeCursors;

        ConsistencyCheckingApplier(NeoStores neoStores, CursorContext cursorContext) {
            RelationshipStore relationshipStore = neoStores.getRelationshipStore();
            this.storeCursors = new CachedStoreCursors(neoStores, cursorContext);
            this.cursor = new RecordRelationshipScanCursor(relationshipStore, cursorContext, (StoreCursors)this.storeCursors);
            this.otherCursor = new RecordRelationshipScanCursor(relationshipStore, cursorContext, (StoreCursors)this.storeCursors);
        }

        @Override
        public boolean visitRelationshipCommand(Command.RelationshipCommand command) {
            this.touchedRelationshipIds.add(command.getKey());
            return false;
        }

        @Override
        public void close() throws Exception {
            MutableLongIterator ids = this.touchedRelationshipIds.longIterator();
            while (ids.hasNext()) {
                long id = ids.next();
                this.checkRelationship(id);
            }
            IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.cursor, this.otherCursor, this.storeCursors});
        }

        private void checkRelationship(long id) {
            this.cursor.single(id);
            if (!this.cursor.next()) {
                return;
            }
            this.checkPrevPointer(this.cursor, this.cursor.isFirstInFirstChain(), this.cursor.getFirstPrevRel(), this.cursor.getFirstNode());
            this.checkPrevPointer(this.cursor, this.cursor.isFirstInSecondChain(), this.cursor.getSecondPrevRel(), this.cursor.getSecondNode());
            this.checkNextPointer(this.cursor, this.cursor.getFirstNextRel(), this.cursor.getFirstNode());
            this.checkNextPointer(this.cursor, this.cursor.getSecondNextRel(), this.cursor.getSecondNode());
        }

        private void checkPrevPointer(RecordRelationshipScanCursor cursor, boolean firstInChain, long prevRel, long node) {
            if (firstInChain) {
                return;
            }
            this.otherCursor.single(prevRel);
            Preconditions.checkState((boolean)this.otherCursor.next(), (String)"%s prev refers to unused %s", (Object[])new Object[]{cursor, this.otherCursor});
            Preconditions.checkState((this.otherCursor.getFirstNode() == node || this.otherCursor.getSecondNode() == node ? 1 : 0) != 0, (String)"%s prev refers to %s which is a relationship between other nodes", (Object[])new Object[]{cursor, this.otherCursor});
            long nextRel = this.otherCursor.getFirstNode() == node ? this.otherCursor.getFirstNextRel() : this.otherCursor.getSecondNextRel();
            Preconditions.checkState((nextRel == cursor.getId() ? 1 : 0) != 0, (String)"%s prev refers to %s that doesn't refer back", (Object[])new Object[]{cursor, this.otherCursor});
        }

        private void checkNextPointer(RecordRelationshipScanCursor cursor, long nextRel, long node) {
            if (Record.NULL_REFERENCE.is(nextRel)) {
                return;
            }
            this.otherCursor.single(nextRel);
            Preconditions.checkState((boolean)this.otherCursor.next(), (String)"%s next refers to unused %s", (Object[])new Object[]{cursor, this.otherCursor});
            Preconditions.checkState((this.otherCursor.getFirstNode() == node || this.otherCursor.getSecondNode() == node ? 1 : 0) != 0, (String)"%s next refers to %s which is a relationship between other nodes", (Object[])new Object[]{cursor, this.otherCursor});
            long prevRel = this.otherCursor.getFirstNode() == node ? this.otherCursor.getFirstPrevRel() : this.otherCursor.getSecondPrevRel();
            Preconditions.checkState((prevRel == cursor.getId() ? 1 : 0) != 0, (String)"%s next refers to %s that doesn't refer back", (Object[])new Object[]{cursor, this.otherCursor});
        }
    }
}

