/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.CommandSelector;
import org.neo4j.internal.recordstorage.EntityCommandGrouper;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.kernel.impl.store.NodeLabelsField;

public class IndexUpdatesExtractor
extends TransactionApplier.Adapter {
    private final CommandSelector commandSelector;
    private EntityCommandGrouper<Command.NodeCommand> nodeCommands;
    private EntityCommandGrouper<Command.RelationshipCommand> relationshipCommands;
    private boolean hasUpdates;

    public IndexUpdatesExtractor(CommandSelector commandSelector) {
        this.commandSelector = commandSelector;
        this.nodeCommands = new EntityCommandGrouper<Command.NodeCommand>(Command.NodeCommand.class, 16);
        this.relationshipCommands = new EntityCommandGrouper<Command.RelationshipCommand>(Command.RelationshipCommand.class, 16);
    }

    @Override
    public void close() {
        this.nodeCommands = null;
        this.relationshipCommands = null;
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) {
        this.nodeCommands.add(command);
        if (!this.hasUpdates && this.mayResultInIndexUpdates(command)) {
            this.hasUpdates = true;
        }
        return false;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) {
        this.relationshipCommands.add(command);
        this.hasUpdates = true;
        return false;
    }

    private boolean mayResultInIndexUpdates(Command.NodeCommand command) {
        long after;
        long before = this.commandSelector.getBefore(command).getLabelField();
        return before != (after = this.commandSelector.getAfter(command).getLabelField()) || NodeLabelsField.fieldPointsToDynamicRecordOfLabels(before) || NodeLabelsField.fieldPointsToDynamicRecordOfLabels(after);
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) {
        if (this.commandSelector.getAfter(command).isNodeSet()) {
            this.nodeCommands.add(command);
            this.hasUpdates = true;
        } else if (this.commandSelector.getAfter(command).isRelSet()) {
            this.relationshipCommands.add(command);
            this.hasUpdates = true;
        }
        return false;
    }

    public boolean containsAnyEntityOrPropertyUpdate() {
        return this.hasUpdates;
    }

    public EntityCommandGrouper.Cursor getNodeCommands() {
        return this.nodeCommands.sortAndAccessGroups();
    }

    public EntityCommandGrouper.Cursor getRelationshipCommands() {
        return this.relationshipCommands.sortAndAccessGroups();
    }
}

