/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.kernel.api.exceptions.DeletedNodeStillHasRelationshipsException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;

class IntegrityValidator {
    IntegrityValidator() {
    }

    static void validateNodeRecord(NodeRecord record) throws TransactionFailureException {
        if (!record.inUse() && record.getNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            throw new DeletedNodeStillHasRelationshipsException(record.getId());
        }
    }

    static void validateSchemaRule(SchemaRule schemaRule, KernelVersion kernelVersion) throws TransactionFailureException {
        ConstraintDescriptor constraint;
        if (kernelVersion.isLessThan(KernelVersion.VERSION_REL_UNIQUE_CONSTRAINTS_INTRODUCED) && schemaRule instanceof ConstraintDescriptor && ((constraint = (ConstraintDescriptor)schemaRule).isRelationshipKeyConstraint() || constraint.isRelationshipUniquenessConstraint())) {
            throw new TransactionFailureException((Status)Status.General.UpgradeRequired, "Operation on constraint '%s' not allowed. Required kernel version for this transaction is %s, but actual version was %s.", new Object[]{constraint, KernelVersion.VERSION_REL_UNIQUE_CONSTRAINTS_INTRODUCED.name(), kernelVersion.name()});
        }
    }
}

