/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplierFactory;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionRepository;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.storageengine.api.CommandBatchToApply;

public class KernelVersionTransactionApplier
extends TransactionApplier.Adapter {
    private final KernelVersionRepository kernelVersionRepository;

    public KernelVersionTransactionApplier(KernelVersionRepository kernelVersionRepository) {
        this.kernelVersionRepository = kernelVersionRepository;
    }

    @Override
    public boolean visitMetaDataCommand(Command.MetaDataCommand command) {
        KernelVersion kernelVersion = KernelVersion.getForVersion((byte)Numbers.safeCastLongToByte((long)((MetaDataRecord)command.getAfter()).getValue()));
        this.kernelVersionRepository.setKernelVersion(kernelVersion);
        return false;
    }

    public static class Factory
    implements TransactionApplierFactory {
        private final KernelVersionRepository kernelVersionRepository;

        public Factory(KernelVersionRepository kernelVersionRepository) {
            this.kernelVersionRepository = kernelVersionRepository;
        }

        @Override
        public TransactionApplier startTx(CommandBatchToApply transaction, BatchContext batchContext) throws IOException {
            return new KernelVersionTransactionApplier(this.kernelVersionRepository);
        }
    }
}

