/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.recordstorage.CommandLockVerification;
import org.neo4j.internal.recordstorage.LockVerificationMonitor;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;

public interface LockVerificationFactory {
    public static final LockVerificationFactory STRICT = new StrictLockVerificationFactory();
    public static final LockVerificationFactory NONE = new EmptyLockVerificationFactory();

    public static LockVerificationFactory select(Config config) {
        boolean enabled = (Boolean)config.get(GraphDatabaseInternalSettings.additional_lock_verification) != false && !"multiversion".equals(config.get(GraphDatabaseSettings.db_format));
        return enabled ? STRICT : NONE;
    }

    public CommandLockVerification createCommandVerification(ResourceLocker var1, ReadableTransactionState var2, NeoStores var3, SchemaRuleAccess var4, StoreCursors var5);

    public RecordAccess.LoadMonitor createLockVerification(ResourceLocker var1, ReadableTransactionState var2, NeoStores var3, SchemaRuleAccess var4, StoreCursors var5);

    public static class StrictLockVerificationFactory
    implements LockVerificationFactory {
        @Override
        public CommandLockVerification createCommandVerification(ResourceLocker locker, ReadableTransactionState txState, NeoStores neoStores, SchemaRuleAccess schemaRuleAccess, StoreCursors storeCursors) {
            return new CommandLockVerification.RealChecker(locker, txState, neoStores, schemaRuleAccess, storeCursors);
        }

        @Override
        public RecordAccess.LoadMonitor createLockVerification(ResourceLocker locks, ReadableTransactionState txState, NeoStores neoStores, SchemaRuleAccess schemaRuleAccess, StoreCursors storeCursors) {
            return new LockVerificationMonitor(locks, txState, new LockVerificationMonitor.NeoStoresLoader(neoStores, schemaRuleAccess, storeCursors));
        }
    }

    public static class EmptyLockVerificationFactory
    implements LockVerificationFactory {
        @Override
        public CommandLockVerification createCommandVerification(ResourceLocker locker, ReadableTransactionState txState, NeoStores neoStores, SchemaRuleAccess schemaRuleAccess, StoreCursors storeCursors) {
            return CommandLockVerification.IGNORE;
        }

        @Override
        public RecordAccess.LoadMonitor createLockVerification(ResourceLocker locks, ReadableTransactionState txState, NeoStores neoStores, SchemaRuleAccess schemaRuleAccess, StoreCursors storeCursors) {
            return RecordAccess.LoadMonitor.NULL_MONITOR;
        }
    }
}

