/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.recordstorage.LogCommandSerializationV5_10;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

class LogCommandSerializationV5_11
extends LogCommandSerializationV5_10 {
    static final LogCommandSerializationV5_11 INSTANCE = new LogCommandSerializationV5_11();

    LogCommandSerializationV5_11() {
    }

    @Override
    public void writeCreatedNodeCommand(WritableChannel channel, Command.NodeCommand command) throws IOException {
        channel.put((byte)22);
        channel.putLong(((NodeRecord)command.getAfter()).getId());
        LogCommandSerializationV5_11.writeNodeRecord(channel, (NodeRecord)command.getAfter());
    }

    @Override
    public void writeDeletedNodeCommand(WritableChannel channel, Command.NodeCommand command) throws IOException {
        channel.put((byte)23);
        channel.putLong(((NodeRecord)command.getBefore()).getId());
        LogCommandSerializationV5_11.writeNodeRecord(channel, (NodeRecord)command.getBefore());
    }

    @Override
    public void writeDeletedPropertyCommand(WritableChannel channel, Command.PropertyCommand command) throws IOException {
        channel.put((byte)25);
        channel.putLong(((PropertyRecord)command.getBefore()).getId());
        LogCommandSerializationV5_11.writePropertyRecord(channel, (PropertyRecord)command.getBefore());
    }

    @Override
    public void writeCreatedPropertyCommand(WritableChannel channel, Command.PropertyCommand command) throws IOException {
        channel.put((byte)24);
        channel.putLong(((PropertyRecord)command.getAfter()).getId());
        LogCommandSerializationV5_11.writePropertyRecord(channel, (PropertyRecord)command.getAfter());
    }

    @Override
    public void writeCreatedRelationshipCommand(WritableChannel channel, Command.RelationshipCommand command) throws IOException {
        channel.put((byte)26);
        channel.putLong(((RelationshipRecord)command.getAfter()).getId());
        LogCommandSerializationV5_11.writeRelationshipRecord(channel, (RelationshipRecord)command.getAfter());
    }

    @Override
    public void writeDeletedRelationshipCommand(WritableChannel channel, Command.RelationshipCommand command) throws IOException {
        channel.put((byte)27);
        channel.putLong(((RelationshipRecord)command.getBefore()).getId());
        LogCommandSerializationV5_11.writeRelationshipRecord(channel, (RelationshipRecord)command.getBefore());
    }

    @Override
    protected Command readDeletedNodeCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        NodeRecord before = LogCommandSerializationV5_11.readNodeRecord(id, channel);
        NodeRecord after = new NodeRecord(before.getId());
        List<DynamicRecord> beforeRecords = before.getDynamicLabelRecords();
        ArrayList<DynamicRecord> afterRecords = new ArrayList<DynamicRecord>(beforeRecords.size());
        for (DynamicRecord beforeRecord : beforeRecords) {
            DynamicRecord dynamicRecord = new DynamicRecord(beforeRecord);
            dynamicRecord.setInUse(false);
            afterRecords.add(dynamicRecord);
        }
        after.setLabelField(Record.NO_LABELS_FIELD.longValue(), afterRecords);
        return new Command.NodeCommand((LogCommandSerialization)this, before, after);
    }

    @Override
    protected Command readCreatedNodeCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        NodeRecord after = LogCommandSerializationV5_11.readNodeRecord(id, channel);
        NodeRecord before = new NodeRecord(after.getId());
        before.setInUse(false);
        return new Command.NodeCommand((LogCommandSerialization)this, before, after);
    }

    @Override
    protected Command readCreatedPropertyCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        PropertyRecord after = LogCommandSerializationV5_11.readPropertyRecord(id, channel);
        PropertyRecord before = new PropertyRecord(after);
        before.clearPropertyBlocks();
        before.setInUse(false);
        before.setCreated(false);
        return new Command.PropertyCommand((LogCommandSerialization)this, before, after);
    }

    @Override
    protected Command readDeletedPropertyCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        PropertyRecord before = LogCommandSerializationV5_11.readPropertyRecord(id, channel);
        PropertyRecord after = new PropertyRecord(before);
        for (PropertyBlock block : after) {
            for (DynamicRecord valueRecord : block.getValueRecords()) {
                assert (valueRecord.inUse());
                valueRecord.setInUse(false);
                after.addDeletedRecord(valueRecord);
            }
        }
        after.clearPropertyBlocks();
        after.setInUse(false);
        return new Command.PropertyCommand((LogCommandSerialization)this, before, after);
    }

    @Override
    protected Command readCreatedRelationshipCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipRecord after = LogCommandSerializationV5_11.readRelationshipRecord(id, channel);
        RelationshipRecord before = new RelationshipRecord(id);
        before.clear();
        return new Command.RelationshipCommand((LogCommandSerialization)this, before, after);
    }

    @Override
    protected Command readDeletedRelationshipCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipRecord before = LogCommandSerializationV5_11.readRelationshipRecord(id, channel);
        RelationshipRecord after = new RelationshipRecord(id);
        after.clear();
        return new Command.RelationshipCommand((LogCommandSerialization)this, before, after);
    }

    @Override
    public KernelVersion kernelVersion() {
        return KernelVersion.V5_11;
    }
}

