/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.common.EntityType;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.CommandSelector;
import org.neo4j.internal.recordstorage.EntityCommandGrouper;
import org.neo4j.internal.recordstorage.IndexUpdates;
import org.neo4j.internal.recordstorage.PropertyPhysicalToLogicalConverter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaCache;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.util.VisibleForTesting;

public class OnlineIndexUpdates
implements IndexUpdates {
    private final NodeStore nodeStore;
    private final SchemaCache schemaCache;
    private final PropertyPhysicalToLogicalConverter converter;
    private final StorageReader reader;
    private final CursorContext cursorContext;
    private final MemoryTracker memoryTracker;
    private final StoreCursors storeCursors;
    private final Collection<IndexEntryUpdate<IndexDescriptor>> updates = new ArrayList<IndexEntryUpdate<IndexDescriptor>>();
    private StorageNodeCursor nodeCursor;
    private StorageRelationshipScanCursor relationshipCursor;

    public OnlineIndexUpdates(NodeStore nodeStore, SchemaCache schemaCache, PropertyPhysicalToLogicalConverter converter, StorageReader reader, CursorContext cursorContext, MemoryTracker memoryTracker, StoreCursors storeCursors) {
        this.nodeStore = nodeStore;
        this.schemaCache = schemaCache;
        this.converter = converter;
        this.reader = reader;
        this.cursorContext = cursorContext;
        this.memoryTracker = memoryTracker;
        this.storeCursors = storeCursors;
    }

    @Override
    public Iterator<IndexEntryUpdate<IndexDescriptor>> iterator() {
        return this.updates.iterator();
    }

    @Override
    public void feed(EntityCommandGrouper.Cursor nodeCommands, EntityCommandGrouper.Cursor relationshipCommands, CommandSelector commandSelector) {
        while (nodeCommands.nextEntity()) {
            this.gatherUpdatesFor(nodeCommands.currentEntityId(), (Command.NodeCommand)nodeCommands.currentEntityCommand(), nodeCommands, commandSelector);
        }
        while (relationshipCommands.nextEntity()) {
            this.gatherUpdatesFor(relationshipCommands.currentEntityId(), (Command.RelationshipCommand)relationshipCommands.currentEntityCommand(), relationshipCommands, commandSelector);
        }
    }

    @Override
    public boolean hasUpdates() {
        return !this.updates.isEmpty();
    }

    private void gatherUpdatesFor(long nodeId, Command.NodeCommand nodeCommand, EntityCommandGrouper.Cursor propertyCommands, CommandSelector commandSelector) {
        EntityUpdates nodeUpdates = this.gatherUpdatesFromCommandsForNode(nodeId, nodeCommand, propertyCommands, commandSelector);
        this.eagerlyGatherValueIndexUpdates(nodeUpdates, EntityType.NODE);
        this.eagerlyGatherTokenIndexUpdates(nodeUpdates, EntityType.NODE);
    }

    private void gatherUpdatesFor(long relationshipId, Command.RelationshipCommand relationshipCommand, EntityCommandGrouper.Cursor propertyCommands, CommandSelector commandSelector) {
        EntityUpdates relationshipUpdates = this.gatherUpdatesFromCommandsForRelationship(relationshipId, relationshipCommand, propertyCommands, commandSelector);
        this.eagerlyGatherValueIndexUpdates(relationshipUpdates, EntityType.RELATIONSHIP);
        this.eagerlyGatherTokenIndexUpdates(relationshipUpdates, EntityType.RELATIONSHIP);
    }

    private void eagerlyGatherValueIndexUpdates(EntityUpdates entityUpdates, EntityType entityType) {
        Set relatedIndexes = this.schemaCache.getValueIndexesRelatedTo(entityUpdates.entityTokensChanged(), entityUpdates.entityTokensUnchanged(), entityUpdates.propertiesChanged(), entityUpdates.isPropertyListComplete(), entityType);
        entityUpdates.valueUpdatesForIndexKeys((Iterable)relatedIndexes, this.reader, entityType, this.cursorContext, this.storeCursors, this.memoryTracker).forEach(this.updates::add);
    }

    private EntityUpdates gatherUpdatesFromCommandsForNode(long nodeId, Command.NodeCommand nodeChanges, EntityCommandGrouper.Cursor propertyCommandsForNode, CommandSelector commandSelector) {
        long[] nodeLabelsAfter;
        long[] nodeLabelsBefore;
        if (nodeChanges != null) {
            nodeLabelsBefore = NodeLabelsField.getNoEnsureHeavy(commandSelector.getBefore(nodeChanges), this.nodeStore, this.storeCursors);
            nodeLabelsAfter = NodeLabelsField.getNoEnsureHeavy(commandSelector.getAfter(nodeChanges), this.nodeStore, this.storeCursors);
        } else {
            StorageNodeCursor nodeCursor = this.loadNode(nodeId);
            nodeLabelsBefore = nodeLabelsAfter = nodeCursor.labels();
        }
        boolean complete = OnlineIndexUpdates.providesCompleteListOfProperties(nodeChanges);
        EntityUpdates.Builder nodePropertyUpdates = EntityUpdates.forEntity((long)nodeId, (boolean)complete).withTokensBefore(nodeLabelsBefore).withTokensAfter(nodeLabelsAfter);
        this.converter.convertPropertyRecord(propertyCommandsForNode, nodePropertyUpdates, commandSelector);
        return nodePropertyUpdates.build();
    }

    private void eagerlyGatherTokenIndexUpdates(EntityUpdates entityUpdates, EntityType entityType) {
        IndexDescriptor relatedToken = this.schemaCache.indexForSchemaAndType((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)entityType), IndexType.LOOKUP);
        entityUpdates.tokenUpdateForIndexKey((SchemaDescriptorSupplier)relatedToken).ifPresent(this.updates::add);
    }

    private static boolean providesCompleteListOfProperties(Command entityCommand) {
        return entityCommand != null && (entityCommand.getMode() == Command.Mode.CREATE || entityCommand.getMode() == Command.Mode.DELETE);
    }

    private EntityUpdates gatherUpdatesFromCommandsForRelationship(long relationshipId, Command.RelationshipCommand relationshipCommand, EntityCommandGrouper.Cursor propertyCommands, CommandSelector commandSelector) {
        long reltypeAfter;
        long reltypeBefore;
        if (relationshipCommand != null) {
            reltypeBefore = commandSelector.getBefore(relationshipCommand).getType();
            reltypeAfter = commandSelector.getAfter(relationshipCommand).getType();
        } else {
            reltypeBefore = reltypeAfter = (long)this.loadRelationship(relationshipId).type();
        }
        boolean complete = OnlineIndexUpdates.providesCompleteListOfProperties(relationshipCommand);
        EntityUpdates.Builder relationshipPropertyUpdates = EntityUpdates.forEntity((long)relationshipId, (boolean)complete);
        if (reltypeBefore != -1L) {
            relationshipPropertyUpdates.withTokensBefore(new long[]{reltypeBefore});
        }
        if (reltypeAfter != -1L) {
            relationshipPropertyUpdates.withTokensAfter(new long[]{reltypeAfter});
        }
        this.converter.convertPropertyRecord(propertyCommands, relationshipPropertyUpdates, commandSelector);
        return relationshipPropertyUpdates.build();
    }

    private StorageNodeCursor loadNode(long nodeId) {
        if (this.nodeCursor == null) {
            this.nodeCursor = this.reader.allocateNodeCursor(this.cursorContext, this.storeCursors);
        }
        this.nodeCursor.single(nodeId);
        if (!this.nodeCursor.next()) {
            throw new IllegalStateException("Node[" + nodeId + "] doesn't exist");
        }
        return this.nodeCursor;
    }

    private StorageRelationshipScanCursor loadRelationship(long relationshipId) {
        if (this.relationshipCursor == null) {
            this.relationshipCursor = this.reader.allocateRelationshipScanCursor(this.cursorContext, this.storeCursors);
        }
        this.relationshipCursor.single(relationshipId);
        if (!this.relationshipCursor.next()) {
            throw new IllegalStateException("Relationship[" + relationshipId + "] doesn't exist");
        }
        return this.relationshipCursor;
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.nodeCursor, this.relationshipCursor, this.reader});
    }

    @Override
    public void reset() {
        this.updates.clear();
    }

    @VisibleForTesting
    protected Collection<IndexEntryUpdate<IndexDescriptor>> getUpdates() {
        return this.updates;
    }

    public String toString() {
        return "OnlineIndexUpdates[" + this.updates + "]";
    }
}

