/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.recordstorage.InconsistentDataDeletion;
import org.neo4j.internal.recordstorage.InconsistentDataReadException;
import org.neo4j.internal.recordstorage.PropertyTraverser;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RecordPropertyCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.LongReference;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.values.storable.Value;

public class PropertyDeleter {
    private final PropertyTraverser traverser;
    private final NeoStores neoStores;
    private final TokenNameLookup tokenNameLookup;
    private final InternalLogProvider logProvider;
    private final Config config;
    private final CursorContext cursorContext;
    private final StoreCursors storeCursors;

    public PropertyDeleter(PropertyTraverser traverser, NeoStores neoStores, TokenNameLookup tokenNameLookup, InternalLogProvider logProvider, Config config, CursorContext cursorContext, StoreCursors storeCursors) {
        this.traverser = traverser;
        this.neoStores = neoStores;
        this.tokenNameLookup = tokenNameLookup;
        this.logProvider = logProvider;
        this.config = config;
        this.cursorContext = cursorContext;
        this.storeCursors = storeCursors;
    }

    public void deletePropertyChain(PrimitiveRecord primitive, RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords, MemoryTracker memoryTracker) {
        long nextProp = primitive.getNextProp();
        MutableLongSet seenPropertyIds = null;
        int count = 0;
        try {
            while (nextProp != Record.NO_NEXT_PROPERTY.longValue()) {
                RecordAccess.RecordProxy<PropertyRecord, PrimitiveRecord> propertyChange = propertyRecords.getOrLoad(nextProp, primitive);
                PropertyRecord propRecord = propertyChange.forChangingData();
                PropertyDeleter.deletePropertyRecordIncludingValueRecords(propRecord);
                PropertyRecord before = propertyChange.getBefore();
                this.markValueRecordsAsCreated(before);
                if (++count >= 100000) {
                    if (seenPropertyIds == null) {
                        seenPropertyIds = LongSets.mutable.empty();
                    }
                    if (!seenPropertyIds.add(nextProp)) {
                        throw new InconsistentDataReadException("Cycle detected in property chain for %s", primitive);
                    }
                }
                nextProp = propRecord.getNextProp();
                propRecord.setChanged(primitive);
            }
        }
        catch (InvalidRecordException e) {
            this.logInconsistentPropertyChain(primitive, memoryTracker, "unused record", (Throwable)((Object)e));
        }
        catch (InconsistentDataReadException e) {
            this.logInconsistentPropertyChain(primitive, memoryTracker, "cycle", e);
        }
        primitive.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
    }

    private void markValueRecordsAsCreated(PropertyRecord beforeRecord) {
        for (PropertyBlock beforeBlock : beforeRecord) {
            this.markValueRecordsAsCreated(beforeBlock);
        }
    }

    private void markValueRecordsAsCreated(PropertyBlock beforeBlock) {
        assert (beforeBlock != null);
        for (DynamicRecord beforeDynamicRecord : beforeBlock.getValueRecords()) {
            assert (beforeDynamicRecord.inUse());
            beforeDynamicRecord.setCreated();
        }
    }

    private void logInconsistentPropertyChain(PrimitiveRecord primitive, MemoryTracker memoryTracker, String causeMessage, Throwable cause) {
        if (!((Boolean)this.config.get(GraphDatabaseInternalSettings.log_inconsistent_data_deletion)).booleanValue()) {
            return;
        }
        StringBuilder message = new StringBuilder(String.format("Deleted inconsistent property chain with %s for %s", causeMessage, primitive));
        try (RecordPropertyCursor propertyCursor = new RecordPropertyCursor(this.neoStores.getPropertyStore(), this.cursorContext, this.storeCursors, memoryTracker);){
            if (primitive instanceof NodeRecord) {
                NodeRecord node = (NodeRecord)primitive;
                message.append(" with labels: ");
                long[] labelIds = NodeLabelsField.parseLabelsField(node).get(this.neoStores.getNodeStore(), this.storeCursors);
                message.append(LongStream.of(labelIds).mapToObj(labelId -> this.tokenNameLookup.labelGetName(StrictMath.toIntExact(labelId))).collect(Collectors.toList()));
                propertyCursor.initNodeProperties(LongReference.longReference((long)node.getNextProp()), PropertySelection.ALL_PROPERTIES, node.getId());
            } else if (primitive instanceof RelationshipRecord) {
                RelationshipRecord relationship = (RelationshipRecord)primitive;
                message.append(String.format(" with relationship type: %s", this.tokenNameLookup.relationshipTypeGetName(relationship.getType())));
                propertyCursor.initRelationshipProperties(LongReference.longReference((long)relationship.getNextProp()), PropertySelection.ALL_PROPERTIES, relationship.getId());
            }
            MutableIntSet seenKeyIds = IntSets.mutable.empty();
            while (propertyCursor.next()) {
                Value value;
                int keyId = propertyCursor.propertyKey();
                if (!seenKeyIds.add(keyId)) continue;
                String key = this.tokenNameLookup.propertyKeyGetName(keyId);
                try {
                    value = propertyCursor.propertyValue();
                }
                catch (Exception e) {
                    value = null;
                }
                String valueToString = value != null ? value.toString() : "<value could not be read>";
                message.append(String.format("%n  %s = %s", key, valueToString));
            }
        }
        catch (InconsistentDataReadException inconsistentDataReadException) {
            // empty catch block
        }
        this.logProvider.getLog(InconsistentDataDeletion.class).error(message.toString(), cause);
    }

    static void deletePropertyRecordIncludingValueRecords(PropertyRecord record) {
        for (PropertyBlock block : record) {
            PropertyDeleter.deleteValueRecords(record, block);
        }
        record.clearPropertyBlocks();
        record.setInUse(false);
    }

    public <P extends PrimitiveRecord> void removeProperty(RecordAccess.RecordProxy<P, Void> primitiveProxy, int propertyKey, RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveProxy.forReadingData();
        long propertyId = this.traverser.findPropertyRecordContaining(primitive, propertyKey, propertyRecords, true);
        this.removeProperty(primitiveProxy, propertyKey, propertyRecords, primitive, propertyId);
    }

    private <P extends PrimitiveRecord> void removeProperty(RecordAccess.RecordProxy<P, Void> primitiveProxy, int propertyKey, RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords, PrimitiveRecord primitive, long propertyId) {
        RecordAccess.RecordProxy<PropertyRecord, PrimitiveRecord> recordChange = propertyRecords.getOrLoad(propertyId, primitive);
        PropertyRecord propRecord = recordChange.forChangingData();
        if (!propRecord.inUse()) {
            throw new IllegalStateException("Unable to delete property[" + propertyId + "] since it is already deleted.");
        }
        PropertyBlock block = propRecord.removePropertyBlock(propertyKey);
        if (block == null) {
            throw new IllegalStateException("Property with index[" + propertyKey + "] is not present in property[" + propertyId + "]");
        }
        PropertyDeleter.deleteValueRecords(propRecord, block);
        PropertyRecord before = recordChange.getBefore();
        this.markValueRecordsAsCreated(before.getPropertyBlock(propertyKey));
        if (propRecord.size() > 0) {
            propRecord.setChanged(primitive);
            assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
        } else {
            this.unlinkPropertyRecord(propRecord, propertyRecords, primitiveProxy);
        }
    }

    private static void deleteValueRecords(PropertyRecord propRecord, PropertyBlock block) {
        for (DynamicRecord valueRecord : block.getValueRecords()) {
            assert (valueRecord.inUse());
            valueRecord.setInUse(false, block.getType().intValue());
            propRecord.addDeletedRecord(valueRecord);
        }
    }

    private <P extends PrimitiveRecord> void unlinkPropertyRecord(PropertyRecord propRecord, RecordAccess<PropertyRecord, PrimitiveRecord> propertyRecords, RecordAccess.RecordProxy<P, Void> primitiveRecordChange) {
        PrimitiveRecord primitive = (PrimitiveRecord)primitiveRecordChange.forReadingLinkage();
        assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
        assert (propRecord.size() == 0);
        long prevProp = propRecord.getPrevProp();
        long nextProp = propRecord.getNextProp();
        if (primitive.getNextProp() == propRecord.getId()) {
            assert (propRecord.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue()) : propRecord + " for " + primitive;
            ((PrimitiveRecord)primitiveRecordChange.forChangingLinkage()).setNextProp(nextProp);
        }
        if (prevProp != (long)Record.NO_PREVIOUS_PROPERTY.intValue()) {
            PropertyRecord prevPropRecord = propertyRecords.getOrLoad(prevProp, primitive).forChangingLinkage();
            assert (prevPropRecord.inUse()) : prevPropRecord + "->" + propRecord + " for " + primitive;
            prevPropRecord.setNextProp(nextProp);
            prevPropRecord.setChanged(primitive);
        }
        if (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord nextPropRecord = propertyRecords.getOrLoad(nextProp, primitive).forChangingLinkage();
            assert (nextPropRecord.inUse()) : propRecord + "->" + nextPropRecord + " for " + primitive;
            nextPropRecord.setPrevProp(prevProp);
            nextPropRecord.setChanged(primitive);
        }
        propRecord.setInUse(false);
        propRecord.setPrevProp(Record.NO_PREVIOUS_PROPERTY.intValue());
        propRecord.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
        propRecord.setChanged(primitive);
        assert (this.traverser.assertPropertyChain(primitive, propertyRecords));
    }
}

