/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RecordLoadOverride;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;

class RecordRelationshipGroupCursor
extends RelationshipGroupRecord
implements AutoCloseable {
    private final RelationshipStore relationshipStore;
    private final RelationshipGroupStore groupStore;
    private final RelationshipGroupDegreesStore groupDegreesStore;
    private final CursorContext cursorContext;
    private final RelationshipRecord edge = new RelationshipRecord(-1L);
    private PageCursor page;
    private PageCursor edgePage;
    private boolean open;
    RecordLoadOverride loadMode;
    private final StoreCursors storeCursors;

    RecordRelationshipGroupCursor(RelationshipStore relationshipStore, RelationshipGroupStore groupStore, RelationshipGroupDegreesStore groupDegreesStore, RecordLoadOverride loadMode, CursorContext cursorContext, StoreCursors storeCursors) {
        super(-1L);
        this.relationshipStore = relationshipStore;
        this.groupStore = groupStore;
        this.groupDegreesStore = groupDegreesStore;
        this.cursorContext = cursorContext;
        this.loadMode = loadMode;
        this.storeCursors = storeCursors;
    }

    void init(long nodeReference, long reference, boolean nodeIsDense) {
        if (reference != -1L && !nodeIsDense) {
            throw new UnsupportedOperationException("Not a dense node");
        }
        this.direct(nodeReference, reference);
        this.open = true;
    }

    void direct(long nodeReference, long reference) {
        this.clear();
        this.setOwningNode(nodeReference);
        this.setNext(reference);
        this.ensureCursor();
    }

    boolean next() {
        do {
            if (this.getNext() == -1L) {
                return false;
            }
            this.group(this, this.getNext(), this.page);
        } while (!this.inUse());
        return true;
    }

    boolean degree(Degrees.Mutator mutator, RelationshipSelection selection) {
        if (selection.test(this.getType())) {
            return this.count(this.outgoingRawId(), this.hasExternalDegreesOut(), RelationshipDirection.OUTGOING, mutator, selection) && this.count(this.incomingRawId(), this.hasExternalDegreesIn(), RelationshipDirection.INCOMING, mutator, selection) && this.count(this.loopsRawId(), this.hasExternalDegreesLoop(), RelationshipDirection.LOOP, mutator, selection);
        }
        return true;
    }

    private boolean count(long reference, boolean hasExternal, RelationshipDirection direction, Degrees.Mutator mutator, RelationshipSelection selection) {
        int count;
        if (reference == -1L || !selection.test(direction)) {
            return true;
        }
        if (!this.add(direction, mutator, 1)) {
            return false;
        }
        if (hasExternal) {
            count = Numbers.safeCastLongToInt((long)this.groupDegreesStore.degree(this.getId(), direction, this.cursorContext));
        } else {
            if (this.edgePage == null) {
                this.edgePage = this.storeCursors.readCursor((CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR);
            }
            this.relationshipStore.getRecordByCursor(reference, this.edge, this.loadMode.orElse(RecordLoad.ALWAYS), this.edgePage);
            count = (int)this.edge.getPrevRel(this.getOwningNode());
        }
        return this.add(direction, mutator, Math.max(count - 1, 0));
    }

    private boolean add(RelationshipDirection direction, Degrees.Mutator mutator, int count) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case RelationshipDirection.OUTGOING -> mutator.add(this.getType(), count, 0, 0);
            case RelationshipDirection.INCOMING -> mutator.add(this.getType(), 0, count, 0);
            case RelationshipDirection.LOOP -> mutator.add(this.getType(), 0, 0, count);
        };
    }

    @Override
    public String toString() {
        if (!this.open) {
            return "RelationshipGroupCursor[closed state]";
        }
        return "RelationshipGroupCursor[id=" + this.getId() + ", open state with: underlying record=" + super.toString() + "]";
    }

    long outgoingRawId() {
        return this.getFirstOut();
    }

    long incomingRawId() {
        return this.getFirstIn();
    }

    long loopsRawId() {
        return this.getFirstLoop();
    }

    @Override
    public void close() {
        this.page = null;
        this.edgePage = null;
    }

    private void ensureCursor() {
        if (this.page == null) {
            this.page = this.storeCursors.readCursor((CursorType)RecordCursorTypes.GROUP_CURSOR);
        }
    }

    private void group(RelationshipGroupRecord record, long reference, PageCursor page) {
        this.groupStore.getRecordByCursor(reference, record, this.loadMode.orElse(RecordLoad.ALWAYS), page);
    }
}

