/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.collection.diffset.LongDiffSets;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.counts.CountsStore;
import org.neo4j.counts.CountsUpdater;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingAction;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.CountsStoreProvider;
import org.neo4j.internal.counts.DegreeStoreProvider;
import org.neo4j.internal.counts.DegreesRebuildFromStore;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.diagnostics.DiagnosticsManager;
import org.neo4j.internal.diagnostics.DiagnosticsProvider;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.SchemaIdType;
import org.neo4j.internal.kernel.api.exceptions.TransactionApplyKernelException;
import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.BatchContextImpl;
import org.neo4j.internal.recordstorage.BridgingCacheAccess;
import org.neo4j.internal.recordstorage.CacheAccessBackDoor;
import org.neo4j.internal.recordstorage.CacheInvalidationTransactionApplierFactory;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.CommandLockVerification;
import org.neo4j.internal.recordstorage.ConsistencyCheckingApplierFactory;
import org.neo4j.internal.recordstorage.CountsRecordState;
import org.neo4j.internal.recordstorage.CountsStoreTransactionApplierFactory;
import org.neo4j.internal.recordstorage.HighIdTransactionApplierFactory;
import org.neo4j.internal.recordstorage.IdRollbackTransactionApplier;
import org.neo4j.internal.recordstorage.IndexTransactionApplierFactory;
import org.neo4j.internal.recordstorage.KernelVersionTransactionApplier;
import org.neo4j.internal.recordstorage.LockGuardedNeoStoreTransactionApplierFactory;
import org.neo4j.internal.recordstorage.LockVerificationFactory;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.recordstorage.MultiversionCountsStoreTransactionApplierFactory;
import org.neo4j.internal.recordstorage.NeoStoreTransactionApplierFactory;
import org.neo4j.internal.recordstorage.NeoStoresDiagnostics;
import org.neo4j.internal.recordstorage.PreAllocationTransactionApplier;
import org.neo4j.internal.recordstorage.RecordIdType;
import org.neo4j.internal.recordstorage.RecordStorageCommandCreationContext;
import org.neo4j.internal.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.internal.recordstorage.RecordStorageIndexingBehaviour;
import org.neo4j.internal.recordstorage.RecordStorageLocks;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplierFactory;
import org.neo4j.internal.recordstorage.TransactionApplierFactoryChain;
import org.neo4j.internal.recordstorage.TransactionRecordState;
import org.neo4j.internal.recordstorage.TransactionToRecordStateVisitor;
import org.neo4j.internal.recordstorage.validation.TransactionCommandValidatorFactory;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.SchemaCache;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseFile;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.OutOfDiskSpaceException;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionRepository;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.kernel.impl.store.stats.RecordDatabaseEntityCounters;
import org.neo4j.kernel.impl.store.stats.StoreEntityCounters;
import org.neo4j.kernel.impl.transaction.log.LogTailLogVersionsMetadata;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.lock.LockGroup;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.storageengine.api.CommandBatchToApply;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.CommandStream;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.CountsDelta;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.InternalErrorTracer;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.enrichment.Enrichment;
import org.neo4j.storageengine.api.enrichment.EnrichmentCommand;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TransactionCountingStateVisitor;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidatorFactory;
import org.neo4j.storageengine.util.IdGeneratorUpdatesWorkSync;
import org.neo4j.storageengine.util.IdUpdateListener;
import org.neo4j.storageengine.util.IndexUpdatesWorkSync;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

public class RecordStorageEngine
implements StorageEngine,
Lifecycle {
    private static final String STORAGE_ENGINE_START_TAG = "storageEngineStart";
    private static final String SCHEMA_CACHE_START_TAG = "schemaCacheStart";
    private static final String TOKENS_INIT_TAG = "tokensInitialisation";
    private final NeoStores neoStores;
    private final RecordDatabaseLayout databaseLayout;
    private final Config config;
    private final InternalLogProvider internalLogProvider;
    private final TokenHolders tokenHolders;
    private final DatabaseHealth databaseHealth;
    private final SchemaCache schemaCache;
    private final CacheAccessBackDoor cacheAccess;
    private final SchemaState schemaState;
    private final SchemaRuleAccess schemaRuleAccess;
    private final ConstraintRuleAccessor constraintSemantics;
    private final LockService lockService;
    private final boolean consistencyCheckApply;
    private final boolean parallelIndexUpdatesApply;
    private final InternalLog log;
    private IndexUpdatesWorkSync indexUpdatesSync;
    private final IdGeneratorFactory idGeneratorFactory;
    private final CursorContextFactory contextFactory;
    private final MemoryTracker otherMemoryTracker;
    final KernelVersionRepository kernelVersionRepository;
    private final LockVerificationFactory lockVerificationFactory;
    private final CountsStore countsStore;
    private final RelationshipGroupDegreesStore groupDegreesStore;
    private final int denseNodeThreshold;
    private final IdGeneratorUpdatesWorkSync idGeneratorWorkSyncs;
    private final Map<TransactionApplicationMode, TransactionApplierFactoryChain> applierChains = new EnumMap<TransactionApplicationMode, TransactionApplierFactoryChain>(TransactionApplicationMode.class);
    private final RecordDatabaseEntityCounters storeEntityCounters;
    private final RecordStorageIndexingBehaviour indexingBehaviour;
    private IndexUpdateListener indexUpdateListener;
    private volatile boolean closed;

    public RecordStorageEngine(RecordDatabaseLayout databaseLayout, Config config, PageCache pageCache, FileSystemAbstraction fs, InternalLogProvider internalLogProvider, InternalLogProvider userLogProvider, TokenHolders tokenHolders, SchemaState schemaState, ConstraintRuleAccessor constraintSemantics, IndexConfigCompleter indexConfigCompleter, LockService lockService, DatabaseHealth databaseHealth, IdGeneratorFactory idGeneratorFactory, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, MemoryTracker otherMemoryTracker, LogTailMetadata logTailMetadata, KernelVersionRepository kernelVersionRepository, LockVerificationFactory lockVerificationFactory, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer) {
        this.databaseLayout = databaseLayout;
        this.config = config;
        this.internalLogProvider = internalLogProvider;
        this.log = internalLogProvider.getLog(this.getClass());
        this.tokenHolders = tokenHolders;
        this.schemaState = schemaState;
        this.lockService = lockService;
        this.databaseHealth = databaseHealth;
        this.constraintSemantics = constraintSemantics;
        this.idGeneratorFactory = idGeneratorFactory;
        this.contextFactory = contextFactory;
        this.otherMemoryTracker = otherMemoryTracker;
        this.kernelVersionRepository = kernelVersionRepository;
        this.lockVerificationFactory = lockVerificationFactory;
        this.neoStores = new StoreFactory((DatabaseLayout)databaseLayout, config, idGeneratorFactory, pageCache, pageCacheTracer, fs, internalLogProvider, contextFactory, false, (LogTailLogVersionsMetadata)logTailMetadata).openAllNeoStores();
        this.idGeneratorWorkSyncs = new IdGeneratorUpdatesWorkSync(false);
        Stream.of(RecordIdType.values()).forEach(idType -> this.idGeneratorWorkSyncs.add(idGeneratorFactory.get((IdType)idType)));
        Stream.of(SchemaIdType.values()).forEach(idType -> this.idGeneratorWorkSyncs.add(idGeneratorFactory.get((IdType)idType)));
        this.indexingBehaviour = new RecordStorageIndexingBehaviour(this.neoStores.getNodeStore().getRecordsPerPage(), this.neoStores.getRelationshipStore().getRecordsPerPage());
        try {
            this.schemaRuleAccess = SchemaRuleAccess.getSchemaRuleAccess(this.neoStores.getSchemaStore(), tokenHolders);
            this.schemaCache = new SchemaCache(constraintSemantics, indexConfigCompleter, (StorageEngineIndexingBehaviour)this.indexingBehaviour);
            this.cacheAccess = new BridgingCacheAccess(this.schemaCache, schemaState, tokenHolders);
            this.denseNodeThreshold = (Integer)config.get(GraphDatabaseSettings.dense_node_threshold);
            this.countsStore = this.openCountsStore(pageCache, fs, databaseLayout, internalLogProvider, userLogProvider, recoveryCleanupWorkCollector, config, contextFactory, pageCacheTracer);
            this.groupDegreesStore = this.openDegreesStore(pageCache, fs, databaseLayout, internalLogProvider, userLogProvider, recoveryCleanupWorkCollector, config, contextFactory, pageCacheTracer);
            this.consistencyCheckApply = (Boolean)config.get(GraphDatabaseInternalSettings.consistency_check_on_apply);
            this.storeEntityCounters = new RecordDatabaseEntityCounters(idGeneratorFactory, this.countsStore);
            this.parallelIndexUpdatesApply = (Boolean)config.get(GraphDatabaseInternalSettings.parallel_index_updates_apply);
        }
        catch (Throwable failure) {
            this.neoStores.close();
            throw failure;
        }
    }

    private void buildApplierChains() {
        for (TransactionApplicationMode mode : TransactionApplicationMode.values()) {
            this.applierChains.put(mode, this.buildApplierFacadeChain(mode));
        }
    }

    private TransactionApplierFactoryChain buildApplierFacadeChain(TransactionApplicationMode mode) {
        TransactionApplierFactoryChain.IdUpdateListenerFactory idUpdateListenerFunction = mode.isReverseStep() ? (w, c) -> IdUpdateListener.IGNORE : IdGeneratorUpdatesWorkSync::newBatch;
        ArrayList<TransactionApplierFactory> appliers = new ArrayList<TransactionApplierFactory>();
        if (this.consistencyCheckApply && mode.needsAuxiliaryStores()) {
            appliers.add(new ConsistencyCheckingApplierFactory(this.neoStores));
        }
        appliers.add(new KernelVersionTransactionApplier.Factory(this.kernelVersionRepository));
        if (this.isMultiVersionedFormat()) {
            appliers.add(new NeoStoreTransactionApplierFactory(mode, this.neoStores, this.cacheAccess));
        } else {
            appliers.add(new LockGuardedNeoStoreTransactionApplierFactory(mode, this.neoStores, this.cacheAccess, this.lockService(mode)));
        }
        if (mode.rollbackIdProcessing()) {
            appliers.add((transaction, batchContext) -> new IdRollbackTransactionApplier(this.idGeneratorFactory, transaction.cursorContext()));
        }
        if (mode.needsHighIdTracking()) {
            appliers.add(new HighIdTransactionApplierFactory(this.neoStores));
        }
        if (mode.needsCacheInvalidationOnUpdates()) {
            appliers.add(new CacheInvalidationTransactionApplierFactory(this.neoStores, this.cacheAccess));
        }
        if (this.isMultiVersionedFormat()) {
            appliers.add(new MultiversionCountsStoreTransactionApplierFactory(mode, this.countsStore, this.groupDegreesStore));
        } else if (mode.needsAuxiliaryStores()) {
            appliers.add(new CountsStoreTransactionApplierFactory(this.countsStore, this.groupDegreesStore));
        }
        if (mode.needsAuxiliaryStores()) {
            appliers.add(new IndexTransactionApplierFactory(mode, this.indexUpdateListener));
        }
        return new TransactionApplierFactoryChain(idUpdateListenerFunction, (TransactionApplierFactory[])appliers.toArray(TransactionApplierFactory[]::new));
    }

    private CountsStore openCountsStore(PageCache pageCache, FileSystemAbstraction fs, RecordDatabaseLayout layout, InternalLogProvider internalLogProvider, InternalLogProvider userLogProvider, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Config config, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer) {
        return CountsStoreProvider.getInstance().openCountsStore(pageCache, fs, layout, userLogProvider, recoveryCleanupWorkCollector, config, contextFactory, pageCacheTracer, this.getOpenOptions(), (CountsBuilder)new RecordCountsBuilder(internalLogProvider, pageCache, contextFactory, layout), false);
    }

    private RelationshipGroupDegreesStore openDegreesStore(PageCache pageCache, FileSystemAbstraction fs, RecordDatabaseLayout layout, InternalLogProvider internalLogProvider, InternalLogProvider userLogProvider, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Config config, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer) {
        return DegreeStoreProvider.getInstance().openDegreesStore(pageCache, fs, layout, userLogProvider, recoveryCleanupWorkCollector, config, contextFactory, pageCacheTracer, new DegreesRebuildFromStore(pageCache, this.neoStores, (DatabaseLayout)this.databaseLayout, contextFactory, internalLogProvider, Configuration.DEFAULT), this.getOpenOptions(), false);
    }

    public String name() {
        return "record";
    }

    public byte id() {
        return 1;
    }

    public RecordStorageReader newReader() {
        return new RecordStorageReader(this.tokenHolders, this.neoStores, this.countsStore, this.groupDegreesStore, this.schemaCache);
    }

    public RecordStorageCommandCreationContext newCommandCreationContext(boolean multiVersioned) {
        return new RecordStorageCommandCreationContext(this.neoStores, (TokenNameLookup)this.tokenHolders, this.internalLogProvider, this.denseNodeThreshold, this.config, multiVersioned);
    }

    public TransactionValidatorFactory createTransactionValidatorFactory(StorageEngineFactory storageEngineFactory, Config config, SystemNanoClock clock) {
        if (!this.isMultiVersionedFormat()) {
            return TransactionValidatorFactory.EMPTY_VALIDATOR_FACTORY;
        }
        return new TransactionCommandValidatorFactory(this.neoStores, storageEngineFactory, config, clock, (LogProvider)this.internalLogProvider);
    }

    private boolean isMultiVersionedFormat() {
        return this.neoStores.getOpenOptions().contains((Object)PageCacheOpenOptions.MULTI_VERSIONED);
    }

    public StoreCursors createStorageCursors(CursorContext cursorContext) {
        return new CachedStoreCursors(this.neoStores, cursorContext);
    }

    public StorageLocks createStorageLocks(ResourceLocker locker) {
        return new RecordStorageLocks(locker);
    }

    public void addIndexUpdateListener(IndexUpdateListener listener) {
        Preconditions.checkState((this.indexUpdateListener == null ? 1 : 0) != 0, (String)("Only supports a single listener. Tried to add " + listener + ", but " + this.indexUpdateListener + " has already been added"));
        this.indexUpdateListener = listener;
        this.indexUpdatesSync = new IndexUpdatesWorkSync(listener, this.parallelIndexUpdatesApply);
    }

    public List<StorageCommand> createCommands(ReadableTransactionState txState, StorageReader storageReader, CommandCreationContext commandCreationContext, LockTracer lockTracer, TxStateVisitor.Decorator additionalTxStateVisitor, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) throws KernelException {
        if (txState == null) {
            return Collections.emptyList();
        }
        HeapTrackingArrayList commands = HeapTrackingCollections.newArrayList((MemoryTracker)memoryTracker);
        RecordStorageCommandCreationContext creationContext = (RecordStorageCommandCreationContext)commandCreationContext;
        LogCommandSerialization serialization = RecordStorageCommandReaderFactory.INSTANCE.get(commandCreationContext.kernelVersion());
        ResourceLocker locks = creationContext.getLocks();
        TransactionRecordState recordState = creationContext.createTransactionRecordState(locks, lockTracer, serialization, memoryTracker, this.lockVerificationFactory.createLockVerification(locks, txState, this.neoStores, this.schemaRuleAccess, storeCursors));
        TransactionToRecordStateVisitor txStateVisitor = new TransactionToRecordStateVisitor(recordState, this.schemaState, this.schemaRuleAccess, this.constraintSemantics, cursorContext, storeCursors);
        CountsRecordState countsRecordState = new CountsRecordState(serialization);
        txStateVisitor = (TxStateVisitor)additionalTxStateVisitor.apply((Object)txStateVisitor);
        try (TransactionToRecordStateVisitor visitor = txStateVisitor = new TransactionCountingStateVisitor((TxStateVisitor)txStateVisitor, storageReader, txState, (CountsDelta)countsRecordState, cursorContext, storeCursors);){
            txState.accept((TxStateVisitor)visitor);
        }
        recordState.extractCommands((Collection<StorageCommand>)commands, memoryTracker);
        countsRecordState.extractCommands((Collection<StorageCommand>)commands, memoryTracker);
        CommandLockVerification commandLockVerification = this.lockVerificationFactory.createCommandVerification(locks, txState, this.neoStores, this.schemaRuleAccess, storeCursors);
        commandLockVerification.verifySufficientlyLocked((Collection<StorageCommand>)commands);
        this.unallocateIds(txState.addedAndRemovedNodes().getRemovedFromAdded(), (IdType)RecordIdType.NODE, cursorContext);
        this.unallocateIds(txState.addedAndRemovedRelationships().getRemovedFromAdded(), (IdType)RecordIdType.RELATIONSHIP, cursorContext);
        return commands;
    }

    public List<StorageCommand> createUpgradeCommands(KernelVersion versionToUpgradeFrom, KernelVersion versionToUpgradeTo) {
        Preconditions.checkState((boolean)versionToUpgradeTo.isGreaterThan(versionToUpgradeFrom), (String)"Can not downgrade from %s to %s", (Object[])new Object[]{versionToUpgradeFrom, versionToUpgradeTo});
        MetaDataStore metaDataStore = this.metadataProvider();
        MetaDataRecord before = metaDataStore.newRecord();
        before.initialize(true, versionToUpgradeFrom.version());
        MetaDataRecord after = metaDataStore.newRecord();
        after.initialize(true, versionToUpgradeTo.version());
        LogCommandSerialization serialization = RecordStorageCommandReaderFactory.INSTANCE.get(versionToUpgradeTo);
        return List.of(new Command.MetaDataCommand(serialization, before, after));
    }

    public EnrichmentCommand createEnrichmentCommand(KernelVersion kernelVersion, Enrichment enrichment) {
        return new Command.RecordEnrichmentCommand(RecordStorageCommandReaderFactory.INSTANCE.get(kernelVersion), enrichment);
    }

    public void lockRecoveryCommands(CommandStream commands, LockService lockService, LockGroup lockGroup, TransactionApplicationMode mode) {
        for (StorageCommand command : commands) {
            ((Command)command).lockForRecovery(lockService, lockGroup, mode);
        }
    }

    public void apply(CommandBatchToApply batch, TransactionApplicationMode mode) throws Exception {
        TransactionApplierFactoryChain batchApplier = this.applierChain(mode);
        CommandBatchToApply initialBatch = batch;
        try (BatchContext context = this.createBatchContext(batchApplier, batch);){
            while (batch != null) {
                try (TransactionApplier txApplier = batchApplier.startTx(batch, context);){
                    batch.accept((Visitor)txApplier);
                }
                batch = batch.next();
            }
        }
        catch (Throwable cause) {
            TransactionApplyKernelException kernelException = new TransactionApplyKernelException(cause, "Failed to apply transaction: %s", new Object[]{batch == null ? initialBatch : batch});
            this.databaseHealth.panic((Throwable)kernelException);
            throw kernelException;
        }
    }

    public void rollback(ReadableTransactionState txState, CursorContext cursorContext) {
        this.unallocateIds(txState.addedAndRemovedNodes(), (IdType)RecordIdType.NODE, cursorContext);
        this.unallocateIds(txState.addedAndRemovedRelationships(), (IdType)RecordIdType.RELATIONSHIP, cursorContext);
    }

    private void unallocateIds(LongDiffSets ids, IdType idType, CursorContext cursorContext) {
        this.unallocateIds(ids.getAdded(), idType, cursorContext);
        this.unallocateIds(ids.getRemovedFromAdded(), idType, cursorContext);
    }

    private void unallocateIds(LongSet ids, IdType idType, CursorContext cursorContext) {
        if (!ids.isEmpty()) {
            try (IdGenerator.TransactionalMarker marker = this.idGeneratorFactory.get(idType).transactionalMarker(cursorContext);){
                ids.forEach(arg_0 -> ((IdGenerator.TransactionalMarker)marker).markUnallocated(arg_0));
            }
        }
    }

    private BatchContext createBatchContext(TransactionApplierFactoryChain batchApplier, CommandBatchToApply initialBatch) {
        return new BatchContextImpl(this.indexUpdateListener, this.indexUpdatesSync, this.neoStores.getNodeStore(), this.neoStores.getPropertyStore(), this, this.schemaCache, initialBatch.cursorContext(), this.otherMemoryTracker, batchApplier.getIdUpdateListener(this.idGeneratorWorkSyncs, initialBatch.cursorContext()), initialBatch.storeCursors());
    }

    protected TransactionApplierFactoryChain applierChain(TransactionApplicationMode mode) {
        return this.applierChains.get(mode);
    }

    private LockService lockService(TransactionApplicationMode mode) {
        return mode == TransactionApplicationMode.RECOVERY || mode.isReverseStep() ? LockService.NO_LOCK_SERVICE : this.lockService;
    }

    public void init() {
        this.buildApplierChains();
    }

    public void start() throws Exception {
        try (CursorContext cursorContext = this.contextFactory.create(STORAGE_ENGINE_START_TAG);){
            this.neoStores.start(cursorContext);
            this.countsStore.start(cursorContext, this.otherMemoryTracker);
            this.groupDegreesStore.start(cursorContext, this.otherMemoryTracker);
        }
    }

    @VisibleForTesting
    public void loadSchemaCache() {
        try (CursorContext cursorContext = this.contextFactory.create(SCHEMA_CACHE_START_TAG);
             CachedStoreCursors storeCursors = new CachedStoreCursors(this.neoStores, cursorContext);){
            this.schemaCache.load(this.schemaRuleAccess.getAll((StoreCursors)storeCursors));
        }
    }

    public void stop() throws Exception {
    }

    public void shutdown() {
        if (!this.closed) {
            try {
                ThrowingAction[] throwingActionArray = new ThrowingAction[3];
                throwingActionArray[0] = () -> ((CountsStore)this.countsStore).close();
                throwingActionArray[1] = () -> ((RelationshipGroupDegreesStore)this.groupDegreesStore).close();
                throwingActionArray[2] = this.neoStores::close;
                ThrowingAction.executeAll((ThrowingAction[])throwingActionArray);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            finally {
                this.closed = true;
            }
        }
    }

    public void checkpoint(DatabaseFlushEvent flushEvent, CursorContext cursorContext) throws IOException {
        this.log.debug("Checkpointing %s", new Object[]{RecordDatabaseFile.COUNTS_STORE.getName()});
        try (FileFlushEvent fileFlushEvent = flushEvent.beginFileFlush();){
            this.countsStore.checkpoint(fileFlushEvent, cursorContext);
        }
        this.log.debug("Checkpointing %s", new Object[]{RecordDatabaseFile.RELATIONSHIP_GROUP_DEGREES_STORE.getName()});
        fileFlushEvent = flushEvent.beginFileFlush();
        try {
            this.groupDegreesStore.checkpoint(fileFlushEvent, cursorContext);
        }
        finally {
            if (fileFlushEvent != null) {
                fileFlushEvent.close();
            }
        }
        this.neoStores.checkpoint(flushEvent, cursorContext);
    }

    public void dumpDiagnostics(InternalLog errorLog, DiagnosticsLogger diagnosticsLog) {
        DiagnosticsManager.dump((DiagnosticsProvider)new NeoStoresDiagnostics.NeoStoreIdUsage(this.neoStores), (InternalLog)errorLog, (DiagnosticsLogger)diagnosticsLog);
        DiagnosticsManager.dump((DiagnosticsProvider)new NeoStoresDiagnostics.NeoStoreRecords(this.neoStores), (InternalLog)errorLog, (DiagnosticsLogger)diagnosticsLog);
    }

    public void listStorageFiles(Collection<StoreFileMetadata> atomic, Collection<StoreFileMetadata> replayable) {
        atomic.add(new StoreFileMetadata(this.databaseLayout.countStore(), 1));
        atomic.add(new StoreFileMetadata(this.databaseLayout.relationshipGroupDegreesStore(), 1));
        for (StoreType type : StoreType.STORE_TYPES) {
            RecordStore recordStore = this.neoStores.getRecordStore(type);
            StoreFileMetadata metadata = new StoreFileMetadata(recordStore.getStorageFile(), recordStore.getRecordSize());
            replayable.add(metadata);
        }
    }

    @VisibleForTesting
    public NeoStores testAccessNeoStores() {
        return this.neoStores;
    }

    @VisibleForTesting
    public SchemaRuleAccess testAccessSchemaRules() {
        return this.schemaRuleAccess;
    }

    public StoreId retrieveStoreId() {
        return this.metadataProvider().getStoreId();
    }

    public Lifecycle schemaAndTokensLifecycle() {
        return new LifecycleAdapter(){

            public void init() {
                try (CursorContext cursorContext = RecordStorageEngine.this.contextFactory.create(RecordStorageEngine.TOKENS_INIT_TAG);
                     CachedStoreCursors storeCursors = new CachedStoreCursors(RecordStorageEngine.this.neoStores, cursorContext);){
                    RecordStorageEngine.this.tokenHolders.setInitialTokens(StoreTokens.allTokens(RecordStorageEngine.this.neoStores), (StoreCursors)storeCursors);
                }
                RecordStorageEngine.this.loadSchemaCache();
            }
        };
    }

    public CountsStore countsAccessor() {
        return this.countsStore;
    }

    @VisibleForTesting
    public RelationshipGroupDegreesStore relationshipGroupDegreesStore() {
        return this.groupDegreesStore;
    }

    public MetaDataStore metadataProvider() {
        return this.neoStores.getMetaDataStore();
    }

    public StoreEntityCounters storeEntityCounters() {
        return this.storeEntityCounters;
    }

    public InternalErrorTracer internalErrorTracer() {
        return InternalErrorTracer.NO_TRACER;
    }

    public ImmutableSet<OpenOption> getOpenOptions() {
        return this.neoStores.getOpenOptions();
    }

    public StorageEngineIndexingBehaviour indexingBehaviour() {
        return this.indexingBehaviour;
    }

    public void preAllocateStoreFilesForCommands(CommandBatchToApply batch, TransactionApplicationMode mode) throws IOException {
        if (!mode.isReverseStep() && batch != null) {
            try (PreAllocationTransactionApplier txApplier = new PreAllocationTransactionApplier(this.neoStores);){
                while (batch != null) {
                    batch.accept((Visitor)txApplier);
                    batch = batch.next();
                }
            }
            catch (OutOfDiskSpaceException e) {
                this.databaseHealth.outOfDiskSpace((Throwable)e);
                throw e;
            }
        }
    }

    private class RecordCountsBuilder
    implements CountsBuilder {
        private final InternalLog log;
        private final PageCache pageCache;
        private final CursorContextFactory contextFactory;
        private final RecordDatabaseLayout layout;

        public RecordCountsBuilder(InternalLogProvider internalLogProvider, PageCache pageCache, CursorContextFactory contextFactory, RecordDatabaseLayout layout) {
            this.pageCache = pageCache;
            this.contextFactory = contextFactory;
            this.layout = layout;
            this.log = internalLogProvider.getLog(MetaDataStore.class);
        }

        public void initialize(CountsUpdater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
            this.log.warn("Missing counts store, rebuilding it.");
            new CountsComputer(RecordStorageEngine.this.neoStores, this.pageCache, this.contextFactory, (DatabaseLayout)this.layout, memoryTracker, this.log).initialize(updater, cursorContext, memoryTracker);
            this.log.warn("Counts store rebuild completed.");
        }

        public long lastCommittedTxId() {
            MetaDataStore txIdStore = RecordStorageEngine.this.metadataProvider();
            return txIdStore.getLastCommittedTransactionId();
        }
    }
}

