/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.counts.DegreeUpdater;
import org.neo4j.internal.recordstorage.DirectionWrapper;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RecordAccessSet;
import org.neo4j.internal.recordstorage.RelationshipGroupGetter;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;

public class RelationshipCreator {
    public static final ConnectToDenseMonitor NO_CONNECT_TO_DENSE_MONITOR = (createdRelationship, group, direction) -> {};
    private final int denseNodeThreshold;
    private final long externalDegreesThreshold;
    private final CursorContext cursorContext;

    public RelationshipCreator(int denseNodeThreshold, long externalDegreesThreshold, CursorContext cursorContext) {
        this.denseNodeThreshold = denseNodeThreshold;
        this.externalDegreesThreshold = externalDegreesThreshold;
        this.cursorContext = cursorContext;
    }

    public void relationshipCreate(RelationshipModifications.RelationshipBatch creations, RecordAccessSet recordChanges, DegreeUpdater groupDegreesUpdater, NodeDataLookup nodeDataLookup) {
        creations.forEach((id, type, firstNodeId, secondNodeId, addedProperties) -> this.relationshipCreate(id, type, firstNodeId, secondNodeId, recordChanges, groupDegreesUpdater, nodeDataLookup));
    }

    public void relationshipCreate(long id, int type, long firstNodeId, long secondNodeId, RecordAccessSet recordChanges, DegreeUpdater groupDegreesUpdater, NodeDataLookup nodeDataLookup) {
        RecordAccess.RecordProxy<NodeRecord, Object> firstNode = recordChanges.getNodeRecords().getOrLoad(firstNodeId, null);
        RecordAccess.RecordProxy<NodeRecord, Object> secondNode = firstNodeId == secondNodeId ? firstNode : recordChanges.getNodeRecords().getOrLoad(secondNodeId, null);
        RecordAccess<RelationshipRecord, Void> relRecords = recordChanges.getRelRecords();
        this.convertNodeToDenseIfNecessary(firstNode, relRecords, groupDegreesUpdater, nodeDataLookup);
        this.convertNodeToDenseIfNecessary(secondNode, relRecords, groupDegreesUpdater, nodeDataLookup);
        RelationshipRecord record = relRecords.create(id, null, this.cursorContext).forChangingLinkage();
        record.setLinks(firstNodeId, secondNodeId, type);
        record.setInUse(true);
        record.setCreated();
        this.connectRelationship(firstNode, secondNode, record, relRecords, groupDegreesUpdater, nodeDataLookup);
    }

    static int relCount(long nodeId, RelationshipRecord rel) {
        return (int)rel.getPrevRel(nodeId);
    }

    private void convertNodeToDenseIfNecessary(RecordAccess.RecordProxy<NodeRecord, Void> nodeChange, RecordAccess<RelationshipRecord, Void> relRecords, DegreeUpdater groupDegreesUpdater, NodeDataLookup nodeDataLookup) {
        NodeRecord node = nodeChange.forReadingLinkage();
        if (node.isDense()) {
            return;
        }
        long relId = node.getNextRel();
        if (!Record.isNull(relId)) {
            RecordAccess.RecordProxy<RelationshipRecord, Object> relProxy = relRecords.getOrLoad(relId, null);
            if (RelationshipCreator.relCount(node.getId(), relProxy.forReadingData()) >= this.denseNodeThreshold) {
                this.convertNodeToDenseNode(nodeChange, relProxy.forChangingLinkage(), relRecords, groupDegreesUpdater, nodeDataLookup, NO_CONNECT_TO_DENSE_MONITOR);
            }
        }
    }

    private void connectRelationship(RecordAccess.RecordProxy<NodeRecord, Void> firstNodeChange, RecordAccess.RecordProxy<NodeRecord, Void> secondNodeChange, RelationshipRecord rel, RecordAccess<RelationshipRecord, Void> relRecords, DegreeUpdater groupDegreesUpdater, NodeDataLookup nodeDataLookup) {
        boolean loop;
        NodeRecord firstNode = firstNodeChange.forReadingLinkage();
        NodeRecord secondNode = secondNodeChange.forReadingLinkage();
        assert (firstNode.getNextRel() != rel.getId() || firstNode.isDense());
        assert (secondNode.getNextRel() != rel.getId() || secondNode.isDense());
        if (!firstNode.isDense()) {
            rel.setFirstNextRel(firstNode.getNextRel());
        }
        if (!secondNode.isDense()) {
            rel.setSecondNextRel(secondNode.getNextRel());
        }
        boolean bl = loop = firstNode.getId() == secondNode.getId();
        if (!firstNode.isDense()) {
            this.connectSparse(firstNode.getId(), firstNode.getNextRel(), rel, relRecords);
        } else {
            int index = loop ? 2 : 0;
            this.connectRelationshipToDenseNode(firstNodeChange, rel, relRecords, groupDegreesUpdater, nodeDataLookup.insertionPoint(firstNode.getId(), rel.getType(), index), nodeDataLookup, NO_CONNECT_TO_DENSE_MONITOR);
        }
        if (!secondNode.isDense()) {
            if (!loop) {
                this.connectSparse(secondNode.getId(), secondNode.getNextRel(), rel, relRecords);
            } else {
                rel.setFirstInFirstChain(true);
                rel.setSecondPrevRel(rel.getFirstPrevRel());
            }
        } else if (!loop) {
            this.connectRelationshipToDenseNode(secondNodeChange, rel, relRecords, groupDegreesUpdater, nodeDataLookup.insertionPoint(secondNode.getId(), rel.getType(), 1), nodeDataLookup, NO_CONNECT_TO_DENSE_MONITOR);
        }
        if (!firstNode.isDense()) {
            firstNodeChange.forChangingLinkage();
            firstNode.setNextRel(rel.getId());
        }
        if (!secondNode.isDense()) {
            secondNodeChange.forChangingLinkage();
            secondNode.setNextRel(rel.getId());
        }
    }

    private void connectRelationshipToDenseNode(RecordAccess.RecordProxy<NodeRecord, Void> nodeChange, RelationshipRecord createdRelationship, RecordAccess<RelationshipRecord, Void> relRecords, DegreeUpdater groupDegreesUpdater, RecordAccess.RecordProxy<RelationshipRecord, Void> insertionPoint, NodeDataLookup nodeDataLookup, ConnectToDenseMonitor connectToDenseMonitor) {
        NodeRecord node = nodeChange.forReadingLinkage();
        DirectionWrapper dir = DirectionWrapper.wrapDirection(createdRelationship, node);
        this.connectDense(node, nodeDataLookup.group(nodeChange.getKey(), createdRelationship.getType(), true), dir, createdRelationship, relRecords, groupDegreesUpdater, insertionPoint, connectToDenseMonitor);
    }

    public void convertNodeToDenseNode(RecordAccess.RecordProxy<NodeRecord, Void> nodeChange, RelationshipRecord firstRel, RecordAccess<RelationshipRecord, Void> relRecords, DegreeUpdater groupDegreesUpdater, NodeDataLookup nodeDataLookup, ConnectToDenseMonitor connectToDenseMonitor) {
        NodeRecord node = nodeChange.forChangingLinkage();
        node.setDense(true);
        node.setNextRel(Record.NO_NEXT_RELATIONSHIP.intValue());
        long relId = firstRel.getId();
        RelationshipRecord relRecord = firstRel;
        while (!Record.isNull(relId)) {
            relId = relRecord.getNextRel(node.getId());
            relRecord.setPrevRel(Record.NO_NEXT_RELATIONSHIP.longValue(), node.getId());
            relRecord.setNextRel(Record.NO_NEXT_RELATIONSHIP.longValue(), node.getId());
            this.connectRelationshipToDenseNode(nodeChange, relRecord, relRecords, groupDegreesUpdater, null, nodeDataLookup, connectToDenseMonitor);
            if (Record.isNull(relId)) continue;
            relRecord = relRecords.getOrLoad(relId, null).forChangingLinkage();
        }
    }

    private void connectDense(NodeRecord node, RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> groupProxy, DirectionWrapper direction, RelationshipRecord createdRelationship, RecordAccess<RelationshipRecord, Void> relRecords, DegreeUpdater groupDegreesUpdater, RecordAccess.RecordProxy<RelationshipRecord, Void> insertionPoint, ConnectToDenseMonitor monitor) {
        long nodeId = node.getId();
        RelationshipGroupRecord group = groupProxy.forReadingLinkage();
        long firstRelId = direction.getNextRel(group);
        RecordAccess.RecordProxy<RelationshipRecord, Void> relationshipBefore = null;
        RecordAccess.RecordProxy<RelationshipRecord, Object> relationshipAfter = null;
        if (insertionPoint != null) {
            relationshipBefore = insertionPoint;
            long next = insertionPoint.forReadingLinkage().getNextRel(nodeId);
            if (!Record.isNull(next)) {
                relationshipAfter = relRecords.getOrLoad(next, null);
            }
        }
        if (relationshipBefore == null) {
            if (!Record.isNull(firstRelId)) {
                RelationshipRecord firstRel = relRecords.getOrLoad(firstRelId, null).forChangingLinkage();
                if (!firstRel.isFirstInChain(nodeId)) {
                    throw new IllegalStateException("Expected " + firstRel + " to be first in chain for " + nodeId);
                }
                firstRel.setFirstInChain(false, nodeId);
                createdRelationship.setNextRel(firstRelId, nodeId);
                createdRelationship.setPrevRel(firstRel.getPrevRel(nodeId), nodeId);
                firstRel.setPrevRel(createdRelationship.getId(), nodeId);
            } else {
                createdRelationship.setPrevRel(0L, nodeId);
                monitor.firstRelationshipInChainInserted(createdRelationship, group, direction);
            }
            group = groupProxy.forChangingData();
            direction.setNextRel(group, createdRelationship.getId());
            createdRelationship.setFirstInChain(true, nodeId);
            firstRelId = createdRelationship.getId();
        } else if (relationshipAfter != null) {
            createdRelationship.setFirstInChain(false, nodeId);
            RelationshipRecord before = relationshipBefore.forChangingLinkage();
            before.setNextRel(createdRelationship.getId(), nodeId);
            createdRelationship.setPrevRel(before.getId(), nodeId);
            RelationshipRecord after = relationshipAfter.forChangingLinkage();
            createdRelationship.setNextRel(after.getId(), nodeId);
            after.setPrevRel(createdRelationship.getId(), nodeId);
        } else {
            createdRelationship.setFirstInChain(false, nodeId);
            RelationshipRecord lastRelationship = relationshipBefore.forChangingLinkage();
            lastRelationship.setNextRel(createdRelationship.getId(), nodeId);
            createdRelationship.setPrevRel(lastRelationship.getId(), nodeId);
        }
        if (direction.hasExternalDegrees(group)) {
            groupDegreesUpdater.increment(group.getId(), direction.direction(), 1L);
        } else {
            RecordAccess.RecordProxy<RelationshipRecord, Object> firstRelProxy = relRecords.getOrLoad(firstRelId, null);
            long prevCount = firstRelProxy.forReadingLinkage().getPrevRel(nodeId);
            long count = prevCount + 1L;
            if (count > this.externalDegreesThreshold) {
                group = groupProxy.forChangingData();
                direction.setHasExternalDegrees(group);
                groupDegreesUpdater.increment(group.getId(), direction.direction(), count);
            } else {
                firstRelProxy.forChangingLinkage().setPrevRel(count, nodeId);
            }
        }
    }

    private void connectSparse(long nodeId, long firstRelId, RelationshipRecord createdRelationship, RecordAccess<RelationshipRecord, Void> relRecords) {
        long newCount = 1L;
        if (!Record.isNull(firstRelId)) {
            RelationshipRecord firstRel = relRecords.getOrLoad(firstRelId, null).forChangingLinkage();
            boolean changed = false;
            if (firstRel.getFirstNode() == nodeId) {
                newCount = firstRel.getFirstPrevRel() + 1L;
                firstRel.setFirstPrevRel(createdRelationship.getId());
                firstRel.setFirstInFirstChain(false);
                changed = true;
            }
            if (firstRel.getSecondNode() == nodeId) {
                newCount = firstRel.getSecondPrevRel() + 1L;
                firstRel.setSecondPrevRel(createdRelationship.getId());
                firstRel.setFirstInSecondChain(false);
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(nodeId + " doesn't match " + firstRel);
            }
        }
        if (createdRelationship.getFirstNode() == nodeId) {
            createdRelationship.setFirstPrevRel(newCount);
            createdRelationship.setFirstInFirstChain(true);
        }
        if (createdRelationship.getSecondNode() == nodeId) {
            createdRelationship.setSecondPrevRel(newCount);
            createdRelationship.setFirstInSecondChain(true);
        }
    }

    public static interface NodeDataLookup
    extends RelationshipGroupGetter.GroupLookup {
        public static final int DIR_OUT = 0;
        public static final int DIR_IN = 1;
        public static final int DIR_LOOP = 2;

        public RecordAccess.RecordProxy<RelationshipRecord, Void> insertionPoint(long var1, int var3, int var4);

        public RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> group(long var1, int var3, boolean var4);
    }

    public static interface ConnectToDenseMonitor {
        public void firstRelationshipInChainInserted(RelationshipRecord var1, RelationshipGroupRecord var2, DirectionWrapper var3);
    }

    public static class InsertFirst
    extends RelationshipGroupGetter.DirectGroupLookup
    implements NodeDataLookup {
        private final RelationshipGroupGetter relationshipGroupGetter;

        public InsertFirst(RelationshipGroupGetter relationshipGroupGetter, RecordAccessSet recordChanges, CursorContext cursorContext) {
            super(recordChanges, cursorContext);
            this.relationshipGroupGetter = relationshipGroupGetter;
        }

        @Override
        public RecordAccess.RecordProxy<RelationshipRecord, Void> insertionPoint(long nodeId, int type, int direction) {
            return null;
        }

        @Override
        public RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> group(long nodeId, int type, boolean create) {
            RecordAccess.RecordProxy<NodeRecord, Object> nodeChange = this.recordChanges.getNodeRecords().getOrLoad(nodeId, null);
            return this.relationshipGroupGetter.getOrCreateRelationshipGroup(nodeChange, type, this.recordChanges.getRelGroupRecords());
        }
    }
}

