/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.function.Predicate;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.internal.counts.DegreeUpdater;
import org.neo4j.internal.recordstorage.DirectionWrapper;
import org.neo4j.internal.recordstorage.MappedNodeDataLookup;
import org.neo4j.internal.recordstorage.NodeContext;
import org.neo4j.internal.recordstorage.PropertyDeleter;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RecordAccessSet;
import org.neo4j.internal.recordstorage.RelationshipCreator;
import org.neo4j.internal.recordstorage.RelationshipDeleter;
import org.neo4j.internal.recordstorage.RelationshipGroupGetter;
import org.neo4j.internal.recordstorage.RelationshipLockHelper;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.lock.ResourceType;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;

public class RelationshipModifier {
    public static final int DEFAULT_EXTERNAL_DEGREES_THRESHOLD_SWITCH = 10;
    private final RelationshipGroupGetter relGroupGetter;
    private final int denseNodeThreshold;
    private final boolean multiVersioned;
    private final MemoryTracker memoryTracker;
    private final RelationshipCreator creator;
    private final RelationshipDeleter deleter;

    public RelationshipModifier(RelationshipGroupGetter relGroupGetter, PropertyDeleter propertyChainDeleter, int denseNodeThreshold, boolean multiVersioned, CursorContext cursorContext, MemoryTracker memoryTracker) {
        this.relGroupGetter = relGroupGetter;
        this.denseNodeThreshold = denseNodeThreshold;
        this.multiVersioned = multiVersioned;
        this.memoryTracker = memoryTracker;
        this.creator = new RelationshipCreator(denseNodeThreshold, 10L, cursorContext);
        this.deleter = new RelationshipDeleter(relGroupGetter, propertyChainDeleter, 10L);
    }

    public void modifyRelationships(RelationshipModifications modifications, RecordAccessSet recordChanges, DegreeUpdater groupDegreesUpdater, ResourceLocker locks, LockTracer lockTracer) {
        try (HeapTrackingLongObjectHashMap contexts = HeapTrackingCollections.newLongObjectMap((MemoryTracker)this.memoryTracker);){
            MappedNodeDataLookup nodeDataLookup = new MappedNodeDataLookup((MutableLongObjectMap<NodeContext>)contexts, this.relGroupGetter, recordChanges, this.memoryTracker);
            this.acquireMostOfTheNodeAndGroupsLocks(modifications, recordChanges, locks, lockTracer, (MutableLongObjectMap<NodeContext>)contexts, nodeDataLookup);
            this.acquireRelationshipLocksAndSomeOthers(modifications, recordChanges, locks, lockTracer, (MutableLongObjectMap<NodeContext>)contexts);
            this.creator.relationshipCreate(modifications.creations(), recordChanges, groupDegreesUpdater, nodeDataLookup);
            this.deleter.relationshipDelete(modifications.deletions(), recordChanges, groupDegreesUpdater, nodeDataLookup, this.memoryTracker, locks);
        }
    }

    private void acquireMostOfTheNodeAndGroupsLocks(RelationshipModifications modifications, RecordAccessSet recordChanges, ResourceLocker locks, LockTracer lockTracer, MutableLongObjectMap<NodeContext> contexts, MappedNodeDataLookup nodeDataLookup) {
        modifications.forEachSplit(byNode -> {
            long nodeId = byNode.nodeId();
            RecordAccess.RecordProxy<NodeRecord, Object> nodeProxy = recordChanges.getNodeRecords().getOrLoad(nodeId, null);
            NodeRecord node = nodeProxy.forReadingLinkage();
            boolean nodeIsAddedInTx = node.isCreated();
            if (!node.isDense() && !nodeIsAddedInTx) {
                locks.acquireExclusive(lockTracer, ResourceType.NODE, new long[]{nodeId});
                nodeProxy = recordChanges.getNodeRecords().getOrLoad(nodeId, null);
                node = nodeProxy.forReadingLinkage();
                if (node.isDense()) {
                    locks.releaseExclusive(ResourceType.NODE, new long[]{nodeId});
                } else if (byNode.hasCreations()) {
                    locks.acquireExclusive(lockTracer, ResourceType.RELATIONSHIP_GROUP, new long[]{nodeId});
                }
            }
            if (node.isDense()) {
                locks.acquireShared(lockTracer, ResourceType.RELATIONSHIP_GROUP, new long[]{nodeId});
                NodeContext nodeContext = NodeContext.createNodeContext(nodeProxy, this.memoryTracker);
                contexts.put(nodeId, (Object)nodeContext);
                if (byNode.hasCreations()) {
                    byNode.forEachCreationSplit(byType -> {
                        RelationshipGroupGetter.RelationshipGroupPosition groupPosition = this.findRelationshipGroup(recordChanges, nodeContext, (RelationshipModifications.NodeRelationshipTypeIds)byType);
                        nodeContext.setCurrentGroup(groupPosition.group() != null ? groupPosition.group() : groupPosition.closestPrevious());
                        RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> groupProxy = groupPosition.group();
                        if (groupProxy == null) {
                            if (!nodeContext.hasExclusiveGroupLock()) {
                                locks.releaseShared(ResourceType.RELATIONSHIP_GROUP, new long[]{nodeId});
                                locks.acquireExclusive(lockTracer, ResourceType.NODE, new long[]{nodeId});
                                locks.acquireExclusive(lockTracer, ResourceType.RELATIONSHIP_GROUP, new long[]{nodeId});
                            }
                            nodeContext.setNode(recordChanges.getNodeRecords().getOrLoad(nodeId, null));
                            long groupStartingId = nodeContext.node().forReadingLinkage().getNextRel();
                            long groupStartingPrevId = Record.NULL_REFERENCE.longValue();
                            if (groupPosition.closestPrevious() != null) {
                                groupStartingId = groupPosition.closestPrevious().getKey();
                                groupStartingPrevId = groupPosition.closestPrevious().forReadingLinkage().getPrev();
                            }
                            groupProxy = this.relGroupGetter.getOrCreateRelationshipGroup(nodeContext.node(), byType.type(), recordChanges.getRelGroupRecords(), groupStartingPrevId, groupStartingId);
                            if (!nodeContext.hasExclusiveGroupLock()) {
                                nodeContext.markExclusiveGroupLock();
                            } else if (groupProxy.isCreated()) {
                                nodeContext.clearDenseContext();
                            }
                        }
                        nodeContext.denseContext(byType.type()).setGroup(groupProxy);
                    });
                    if (!nodeContext.hasExclusiveGroupLock()) {
                        byNode.forEachCreationSplitInterruptible(byType -> {
                            RelationshipGroupRecord group = nodeContext.denseContext(byType.type()).group().forReadingLinkage();
                            if (byType.hasOut() && (!group.hasExternalDegreesOut() || Record.isNull(group.getFirstOut())) || byType.hasIn() && (!group.hasExternalDegreesIn() || Record.isNull(group.getFirstIn())) || byType.hasLoop() && (!group.hasExternalDegreesLoop() || Record.isNull(group.getFirstLoop()))) {
                                locks.releaseShared(ResourceType.RELATIONSHIP_GROUP, new long[]{nodeId});
                                locks.acquireExclusive(lockTracer, ResourceType.RELATIONSHIP_GROUP, new long[]{nodeId});
                                nodeContext.markExclusiveGroupLock();
                                return true;
                            }
                            return false;
                        });
                    }
                }
                if (byNode.hasDeletions() && !nodeContext.hasExclusiveGroupLock()) {
                    byNode.forEachDeletionSplitInterruptible(byType -> {
                        boolean hasAnyFirst;
                        NodeContext.DenseContext denseContext = nodeContext.denseContext(byType.type());
                        RelationshipGroupRecord group = denseContext.getOrLoadGroup(this.relGroupGetter, nodeContext.node().forReadingLinkage(), byType.type(), recordChanges.getRelGroupRecords());
                        if (byType.hasOut() && !group.hasExternalDegreesOut() || byType.hasIn() && !group.hasExternalDegreesIn() || byType.hasLoop() && !group.hasExternalDegreesLoop()) {
                            locks.releaseShared(ResourceType.RELATIONSHIP_GROUP, new long[]{nodeId});
                            locks.acquireExclusive(lockTracer, ResourceType.RELATIONSHIP_GROUP, new long[]{nodeId});
                            nodeContext.markExclusiveGroupLock();
                            return true;
                        }
                        boolean bl = hasAnyFirst = RelationshipModifier.batchContains(byType.out(), group.getFirstOut()) || RelationshipModifier.batchContains(byType.in(), group.getFirstIn()) || RelationshipModifier.batchContains(byType.loop(), group.getFirstLoop());
                        if (hasAnyFirst) {
                            locks.releaseShared(ResourceType.RELATIONSHIP_GROUP, new long[]{nodeId});
                            locks.acquireExclusive(lockTracer, ResourceType.RELATIONSHIP_GROUP, new long[]{nodeId});
                            nodeContext.markExclusiveGroupLock();
                            return true;
                        }
                        return false;
                    });
                }
                if (nodeContext.hasExclusiveGroupLock() && nodeContext.hasAnyEmptyGroup() && locks.tryExclusiveLock(ResourceType.NODE_RELATIONSHIP_GROUP_DELETE, nodeId) && (!nodeContext.hasEmptyFirstGroup() || locks.tryExclusiveLock(ResourceType.NODE, nodeId))) {
                    if (nodeContext.hasEmptyFirstGroup()) {
                        nodeContext.setNode(recordChanges.getNodeRecords().getOrLoad(nodeId, null));
                    }
                    Predicate<RelationshipGroupRecord> canDeleteGroup = group -> !byNode.hasCreations(group.getType());
                    if (RelationshipGroupGetter.deleteEmptyGroups(nodeContext.node(), canDeleteGroup, nodeDataLookup)) {
                        nodeContext.clearDenseContext();
                    }
                }
            }
        });
    }

    private RelationshipGroupGetter.RelationshipGroupPosition findRelationshipGroup(RecordAccessSet recordChanges, NodeContext nodeContext, RelationshipModifications.NodeRelationshipTypeIds byType) {
        return this.relGroupGetter.getRelationshipGroup(nodeContext.groupStartingPrevId(), nodeContext.groupStartingId(), byType.type(), recordChanges.getRelGroupRecords(), group -> {
            if (group.getType() != byType.type()) {
                nodeContext.checkEmptyGroup(group);
            }
        });
    }

    private void acquireRelationshipLocksAndSomeOthers(RelationshipModifications modifications, RecordAccessSet recordChanges, ResourceLocker locks, LockTracer lockTracer, MutableLongObjectMap<NodeContext> contexts) {
        RecordAccess<RelationshipRecord, Void> relRecords = recordChanges.getRelRecords();
        modifications.forEachSplit(byNode -> {
            long nodeId = byNode.nodeId();
            NodeRecord node = recordChanges.getNodeRecords().getOrLoad(nodeId, null).forReadingLinkage();
            if (!node.isDense()) {
                if (!this.checkAndLockRelationshipsIfNodeIsGoingToBeDense(node, (RelationshipModifications.NodeRelationshipIds)byNode, relRecords, locks, lockTracer)) {
                    long firstRel;
                    if (byNode.hasDeletions()) {
                        RelationshipLockHelper.lockRelationshipsInOrder(byNode.deletions(), node.getNextRel(), relRecords, locks, this.memoryTracker);
                    } else if (byNode.hasCreations() && !Record.isNull(firstRel = node.getNextRel())) {
                        locks.acquireExclusive(lockTracer, ResourceType.RELATIONSHIP, new long[]{firstRel});
                    }
                }
            } else {
                NodeContext nodeContext = (NodeContext)contexts.get(nodeId);
                if (byNode.hasDeletions()) {
                    byNode.forEachDeletionSplit(byType -> {
                        NodeContext.DenseContext context = nodeContext.denseContext(byType.type());
                        RelationshipGroupRecord group = context.getOrLoadGroup(this.relGroupGetter, node, byType.type(), recordChanges.getRelGroupRecords());
                        long outFirstInChainForDegrees = group.hasExternalDegreesOut() ? Record.NULL_REFERENCE.longValue() : group.getFirstOut();
                        long inFirstInChainForDegrees = group.hasExternalDegreesIn() ? Record.NULL_REFERENCE.longValue() : group.getFirstIn();
                        long loopFirstInChainForDegrees = group.hasExternalDegreesLoop() ? Record.NULL_REFERENCE.longValue() : group.getFirstLoop();
                        RelationshipLockHelper.lockRelationshipsInOrder(byType.out(), outFirstInChainForDegrees, relRecords, locks, this.memoryTracker);
                        RelationshipLockHelper.lockRelationshipsInOrder(byType.in(), inFirstInChainForDegrees, relRecords, locks, this.memoryTracker);
                        RelationshipLockHelper.lockRelationshipsInOrder(byType.loop(), loopFirstInChainForDegrees, relRecords, locks, this.memoryTracker);
                        context.setInsertionPoint(0, this.insertionPointFromDeletion(byType.out(), relRecords));
                        context.setInsertionPoint(1, this.insertionPointFromDeletion(byType.in(), relRecords));
                        context.setInsertionPoint(2, this.insertionPointFromDeletion(byType.loop(), relRecords));
                    });
                }
                if (byNode.hasCreations()) {
                    byNode.forEachCreationSplit(byType -> {
                        NodeContext.DenseContext context = nodeContext.denseContext(byType.type());
                        RelationshipGroupRecord group = context.getOrLoadGroup(this.relGroupGetter, node, byType.type(), recordChanges.getRelGroupRecords());
                        context.setInsertionPoint(0, this.findAndLockInsertionPointForDense(byType.out(), context.insertionPoint(0), relRecords, locks, lockTracer, group, DirectionWrapper.OUTGOING, nodeId));
                        context.setInsertionPoint(1, this.findAndLockInsertionPointForDense(byType.in(), context.insertionPoint(1), relRecords, locks, lockTracer, group, DirectionWrapper.INCOMING, nodeId));
                        context.setInsertionPoint(2, this.findAndLockInsertionPointForDense(byType.loop(), context.insertionPoint(2), relRecords, locks, lockTracer, group, DirectionWrapper.LOOP, nodeId));
                        context.markInsertionPointsAsChanged();
                    });
                }
                if (!nodeContext.hasExclusiveGroupLock()) {
                    locks.releaseShared(ResourceType.RELATIONSHIP_GROUP, new long[]{byNode.nodeId()});
                }
            }
        });
    }

    private boolean checkAndLockRelationshipsIfNodeIsGoingToBeDense(NodeRecord node, RelationshipModifications.NodeRelationshipIds byNode, RecordAccess<RelationshipRecord, Void> relRecords, ResourceLocker locks, LockTracer lockTracer) {
        long nextRel = node.getNextRel();
        if (!Record.isNull(nextRel)) {
            long nodeId;
            RelationshipRecord rel = relRecords.getOrLoad(nextRel, null).forReadingData();
            if (!rel.isFirstInChain(nodeId = node.getId())) {
                throw new IllegalStateException("Expected node " + rel + " to be first in chain for node " + nodeId);
            }
            int currentDegree = RelationshipCreator.relCount(nodeId, rel);
            if (currentDegree + byNode.creations().size() >= this.denseNodeThreshold) {
                MutableLongList ids = LongLists.mutable.withInitialCapacity(currentDegree);
                do {
                    ids.add(nextRel);
                } while (!Record.isNull(nextRel = relRecords.getOrLoad(nextRel, null).forReadingData().getNextRel(nodeId)));
                locks.acquireExclusive(lockTracer, ResourceType.RELATIONSHIP, ids.toSortedArray());
                return true;
            }
        }
        return false;
    }

    private RecordAccess.RecordProxy<RelationshipRecord, Void> insertionPointFromDeletion(RelationshipModifications.RelationshipBatch deletions, RecordAccess<RelationshipRecord, Void> relRecords) {
        return deletions.isEmpty() ? null : relRecords.getOrLoad(deletions.first(), null, RecordLoad.ALWAYS);
    }

    private RecordAccess.RecordProxy<RelationshipRecord, Void> findAndLockInsertionPointForDense(RelationshipModifications.RelationshipBatch creations, RecordAccess.RecordProxy<RelationshipRecord, Void> potentialInsertionPointFromDeletion, RecordAccess<RelationshipRecord, Void> relRecords, ResourceLocker locks, LockTracer lockTracer, RelationshipGroupRecord group, DirectionWrapper direction, long nodeId) {
        if (!creations.isEmpty()) {
            if (potentialInsertionPointFromDeletion != null) {
                return potentialInsertionPointFromDeletion;
            }
            long firstInChain = direction.getNextRel(group);
            if (!Record.isNull(firstInChain)) {
                if (!direction.hasExternalDegrees(group)) {
                    locks.acquireExclusive(lockTracer, ResourceType.RELATIONSHIP, new long[]{firstInChain});
                }
                return RelationshipLockHelper.findAndLockInsertionPoint(firstInChain, nodeId, relRecords, this.multiVersioned, locks, lockTracer);
            }
        }
        return null;
    }

    private static boolean batchContains(RelationshipModifications.RelationshipBatch batch, long id) {
        return !Record.isNull(id) && batch.contains(id);
    }
}

