/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplierFacade;
import org.neo4j.internal.recordstorage.TransactionApplierFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.storageengine.api.CommandBatchToApply;
import org.neo4j.storageengine.util.IdGeneratorUpdatesWorkSync;
import org.neo4j.storageengine.util.IdUpdateListener;

public class TransactionApplierFactoryChain
implements TransactionApplierFactory {
    private final IdUpdateListenerFactory idUpdateListenerFunction;
    private final TransactionApplierFactory[] appliers;

    public TransactionApplierFactoryChain(IdUpdateListenerFactory idUpdateListenerFunction, TransactionApplierFactory ... appliers) {
        this.idUpdateListenerFunction = idUpdateListenerFunction;
        this.appliers = appliers;
    }

    public IdUpdateListener getIdUpdateListener(IdGeneratorUpdatesWorkSync idGeneratorUpdatesWorkSync, CursorContext cursorContext) {
        return this.idUpdateListenerFunction.create(idGeneratorUpdatesWorkSync, cursorContext);
    }

    @Override
    public TransactionApplier startTx(CommandBatchToApply transaction, BatchContext batchContext) throws IOException {
        TransactionApplier[] txAppliers = new TransactionApplier[this.appliers.length];
        for (int i = 0; i < this.appliers.length; ++i) {
            txAppliers[i] = this.appliers[i].startTx(transaction, batchContext);
        }
        return new TransactionApplierFacade(txAppliers);
    }

    @FunctionalInterface
    public static interface IdUpdateListenerFactory {
        public IdUpdateListener create(IdGeneratorUpdatesWorkSync var1, CursorContext var2);
    }
}

