/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.mutable.MutableLong;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;
import org.neo4j.internal.counts.DegreeUpdater;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.IntegrityValidator;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.recordstorage.PropertyCreator;
import org.neo4j.internal.recordstorage.PropertyDeleter;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RecordAccessSet;
import org.neo4j.internal.recordstorage.RecordChangeSet;
import org.neo4j.internal.recordstorage.RecordState;
import org.neo4j.internal.recordstorage.RelationshipGroupGetter;
import org.neo4j.internal.recordstorage.RelationshipModifier;
import org.neo4j.internal.recordstorage.id.IdSequenceProvider;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.store.DynamicAllocatorProvider;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.lock.ResourceType;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;

public class TransactionRecordState
implements RecordState {
    private static final CommandComparator COMMAND_COMPARATOR = new CommandComparator();
    private static final Command[] EMPTY_COMMANDS = new Command[0];
    private static final Function<Command.Mode, List<Command>> MODE_TO_ARRAY_LIST = mode -> new ArrayList();
    private final KernelVersionProvider kernelVersionProvider;
    private final NeoStores neoStores;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final PropertyStore propertyStore;
    private final RecordStore<RelationshipGroupRecord> relationshipGroupStore;
    private final RecordAccessSet recordChangeSet;
    private final ResourceLocker locks;
    private final LockTracer lockTracer;
    private final RelationshipModifier relationshipModifier;
    private final PropertyCreator propertyCreator;
    private final PropertyDeleter propertyDeleter;
    private final CursorContext cursorContext;
    private final StoreCursors storeCursors;
    private final MemoryTracker memoryTracker;
    private final LogCommandSerialization commandSerialization;
    private final DynamicAllocatorProvider dynamicAllocators;
    private final IdSequenceProvider transactionIdSequenceProvider;
    private final DegreesUpdater groupDegreesUpdater = new DegreesUpdater();
    private boolean prepared;
    private final RelationshipGroupGetter.DirectGroupLookup directGroupLookup;

    TransactionRecordState(KernelVersionProvider kernelVersionProvider, RecordChangeSet recordChangeSet, NeoStores neoStores, ResourceLocker locks, LockTracer lockTracer, RelationshipModifier relationshipModifier, PropertyCreator propertyCreator, PropertyDeleter propertyDeleter, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker, LogCommandSerialization commandSerialization, DynamicAllocatorProvider dynamicAllocators, IdSequenceProvider transactionIdSequenceProvider) {
        this.kernelVersionProvider = kernelVersionProvider;
        this.neoStores = neoStores;
        this.nodeStore = neoStores.getNodeStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.propertyStore = neoStores.getPropertyStore();
        this.relationshipGroupStore = neoStores.getRelationshipGroupStore();
        this.recordChangeSet = recordChangeSet;
        this.locks = locks;
        this.lockTracer = lockTracer;
        this.relationshipModifier = relationshipModifier;
        this.propertyCreator = propertyCreator;
        this.propertyDeleter = propertyDeleter;
        this.cursorContext = cursorContext;
        this.storeCursors = storeCursors;
        this.memoryTracker = memoryTracker;
        this.commandSerialization = commandSerialization;
        this.dynamicAllocators = dynamicAllocators;
        this.transactionIdSequenceProvider = transactionIdSequenceProvider;
        this.directGroupLookup = new RelationshipGroupGetter.DirectGroupLookup(recordChangeSet, cursorContext);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void extractCommands(Collection<StorageCommand> commands, MemoryTracker memoryTracker) throws TransactionFailureException {
        void var7_13;
        void var8_16;
        assert (!this.prepared) : "Transaction has already been prepared";
        int noOfCommands = this.recordChangeSet.changeSize();
        Collection<RecordAccess.RecordProxy<LabelTokenRecord, Void>> labelTokenChanges = this.recordChangeSet.getLabelTokenChanges().changes();
        memoryTracker.allocateHeap((long)labelTokenChanges.size() * Command.LabelTokenCommand.HEAP_SIZE);
        for (RecordAccess.RecordProxy<LabelTokenRecord, Void> recordProxy : labelTokenChanges) {
            commands.add(new Command.LabelTokenCommand(this.commandSerialization, recordProxy.getBefore(), recordProxy.forReadingLinkage()));
        }
        Collection<RecordAccess.RecordProxy<RelationshipTypeTokenRecord, Void>> relationshipTypeTokenChanges = this.recordChangeSet.getRelationshipTypeTokenChanges().changes();
        memoryTracker.allocateHeap((long)relationshipTypeTokenChanges.size() * Command.RelationshipTypeTokenCommand.HEAP_SIZE);
        for (RecordAccess.RecordProxy<RelationshipTypeTokenRecord, Void> recordProxy : relationshipTypeTokenChanges) {
            commands.add(new Command.RelationshipTypeTokenCommand(this.commandSerialization, recordProxy.getBefore(), recordProxy.forReadingLinkage()));
        }
        Collection<RecordAccess.RecordProxy<PropertyKeyTokenRecord, Void>> collection = this.recordChangeSet.getPropertyKeyTokenChanges().changes();
        memoryTracker.allocateHeap((long)collection.size() * Command.PropertyKeyTokenCommand.HEAP_SIZE);
        for (RecordAccess.RecordProxy<PropertyKeyTokenRecord, Void> recordProxy : collection) {
            commands.add(new Command.PropertyKeyTokenCommand(this.commandSerialization, recordProxy.getBefore(), recordProxy.forReadingLinkage()));
        }
        Command[] commandArray = EMPTY_COMMANDS;
        boolean bl = false;
        Collection<RecordAccess.RecordProxy<NodeRecord, Void>> nodeChanges = this.recordChangeSet.getNodeRecords().changes();
        if (!nodeChanges.isEmpty()) {
            memoryTracker.allocateHeap((long)nodeChanges.size() * Command.NodeCommand.HEAP_SIZE);
            Command[] commandArray2 = new Command[nodeChanges.size()];
            int i = 0;
            IdSequence nodeIdSequence = this.transactionIdSequenceProvider.getIdSequence(StoreType.NODE);
            for (RecordAccess.RecordProxy<NodeRecord, Void> change : nodeChanges) {
                NodeRecord record = this.prepared(change, nodeIdSequence, this.nodeStore);
                IntegrityValidator.validateNodeRecord(record);
                commandArray2[i++] = new Command.NodeCommand(this.commandSerialization, change.getBefore(), record);
            }
            Arrays.sort(commandArray2, COMMAND_COMPARATOR);
        }
        Command[] relCommands = EMPTY_COMMANDS;
        Collection<RecordAccess.RecordProxy<RelationshipRecord, Void>> relationshipChanges = this.recordChangeSet.getRelRecords().changes();
        if (!relationshipChanges.isEmpty()) {
            memoryTracker.allocateHeap((long)relationshipChanges.size() * Command.RelationshipCommand.HEAP_SIZE);
            relCommands = new Command[relationshipChanges.size()];
            int i = 0;
            IdSequence relIdSequence = this.transactionIdSequenceProvider.getIdSequence(StoreType.RELATIONSHIP);
            for (RecordAccess.RecordProxy<RelationshipRecord, Void> change : relationshipChanges) {
                relCommands[i++] = new Command.RelationshipCommand(this.commandSerialization, change.getBefore(), this.prepared(change, relIdSequence, this.relationshipStore));
            }
            Arrays.sort(relCommands, COMMAND_COMPARATOR);
        }
        Command[] propCommands = EMPTY_COMMANDS;
        Collection<RecordAccess.RecordProxy<PropertyRecord, PrimitiveRecord>> propertyChanges = this.recordChangeSet.getPropertyRecords().changes();
        if (!propertyChanges.isEmpty()) {
            memoryTracker.allocateHeap((long)propertyChanges.size() * Command.PropertyCommand.HEAP_SIZE);
            propCommands = new Command[propertyChanges.size()];
            int i = 0;
            IdSequence propertyIdSequence = this.transactionIdSequenceProvider.getIdSequence(StoreType.PROPERTY);
            for (RecordAccess.RecordProxy<PropertyRecord, PrimitiveRecord> change : propertyChanges) {
                propCommands[i++] = new Command.PropertyCommand(this.commandSerialization, change.getBefore(), this.prepared(change, propertyIdSequence, this.propertyStore));
            }
            Arrays.sort(propCommands, COMMAND_COMPARATOR);
        }
        Command[] relGroupCommands = EMPTY_COMMANDS;
        Collection<RecordAccess.RecordProxy<RelationshipGroupRecord, Integer>> relationshipGroupChanges = this.recordChangeSet.getRelGroupRecords().changes();
        if (!relationshipGroupChanges.isEmpty()) {
            memoryTracker.allocateHeap((long)relationshipGroupChanges.size() * Command.RelationshipGroupCommand.HEAP_SIZE);
            relGroupCommands = new Command[relationshipGroupChanges.size()];
            int i = 0;
            IdSequence relGroupSequence = this.transactionIdSequenceProvider.getIdSequence(StoreType.RELATIONSHIP_GROUP);
            for (RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> recordProxy : relationshipGroupChanges) {
                if (recordProxy.isCreated() && !recordProxy.forReadingLinkage().inUse()) {
                    ++var8_16;
                    continue;
                }
                relGroupCommands[i++] = new Command.RelationshipGroupCommand(this.commandSerialization, recordProxy.getBefore(), this.prepared(recordProxy, relGroupSequence, this.relationshipGroupStore));
            }
            relGroupCommands = i < relGroupCommands.length ? Arrays.copyOf(relGroupCommands, i) : relGroupCommands;
            Arrays.sort(relGroupCommands, COMMAND_COMPARATOR);
        }
        TransactionRecordState.addFiltered(commands, Command.Mode.CREATE, new Command[][]{propCommands, relCommands, relGroupCommands, var7_13});
        TransactionRecordState.addFiltered(commands, Command.Mode.UPDATE, new Command[][]{propCommands, relCommands, relGroupCommands, var7_13});
        TransactionRecordState.addFiltered(commands, Command.Mode.DELETE, new Command[][]{relCommands, relGroupCommands, var7_13});
        EnumMap<Command.Mode, List<Command>> schemaChangeByMode = new EnumMap<Command.Mode, List<Command>>(Command.Mode.class);
        Collection<RecordAccess.RecordProxy<SchemaRecord, SchemaRule>> schemaRuleChange = this.recordChangeSet.getSchemaRuleChanges().changes();
        memoryTracker.allocateHeap((long)schemaRuleChange.size() * Command.SchemaRuleCommand.HEAP_SIZE);
        for (RecordAccess.RecordProxy<AbstractBaseRecord, Integer> recordProxy : schemaRuleChange) {
            SchemaRecord schemaRecord = (SchemaRecord)recordProxy.forReadingLinkage();
            SchemaRule rule = (SchemaRule)recordProxy.getAdditionalData();
            if (schemaRecord.inUse()) {
                IntegrityValidator.validateSchemaRule(rule, this.kernelVersionProvider.kernelVersion());
            }
            Command.SchemaRuleCommand cmd = new Command.SchemaRuleCommand(this.commandSerialization, (SchemaRecord)recordProxy.getBefore(), (SchemaRecord)recordProxy.forChangingData(), rule);
            schemaChangeByMode.computeIfAbsent(cmd.getMode(), MODE_TO_ARRAY_LIST).add(cmd);
        }
        commands.addAll(schemaChangeByMode.getOrDefault((Object)Command.Mode.DELETE, Collections.emptyList()));
        commands.addAll(schemaChangeByMode.getOrDefault((Object)Command.Mode.CREATE, Collections.emptyList()));
        commands.addAll(schemaChangeByMode.getOrDefault((Object)Command.Mode.UPDATE, Collections.emptyList()));
        TransactionRecordState.addFiltered(commands, Command.Mode.DELETE, new Command[][]{propCommands});
        assert (commands.size() == noOfCommands - var8_16) : String.format("Expected %d final commands, got %d instead, with %d skipped", noOfCommands, commands.size(), (int)var8_16);
        if (this.groupDegreesUpdater.degrees != null) {
            memoryTracker.allocateHeap((long)this.groupDegreesUpdater.degrees.size() * Command.GroupDegreeCommand.SHALLOW_SIZE);
            this.groupDegreesUpdater.degrees.forEachKeyValue((LongObjectProcedure & Serializable)(key, delta) -> {
                if (delta.longValue() != 0L) {
                    long groupId = Command.GroupDegreeCommand.groupIdFromCombinedKey(key);
                    RelationshipDirection direction = Command.GroupDegreeCommand.directionFromCombinedKey(key);
                    commands.add(new Command.GroupDegreeCommand(this.commandSerialization, groupId, direction, delta.longValue()));
                }
            });
        }
        this.prepared = true;
    }

    private <RECORD extends AbstractBaseRecord> RECORD prepared(RecordAccess.RecordProxy<RECORD, ?> proxy, IdSequence idSequence, RecordStore<RECORD> store) {
        RECORD after = proxy.forReadingLinkage();
        store.prepareForCommit(after, idSequence, this.cursorContext);
        return after;
    }

    void relModify(RelationshipModifications modifications) {
        this.relationshipModifier.modifyRelationships(modifications, this.recordChangeSet, this.groupDegreesUpdater, this.locks, this.lockTracer);
    }

    private static void addFiltered(Collection<StorageCommand> target, Command.Mode mode, Command[] ... commands) {
        Command[][] commandArray = commands;
        int n = commandArray.length;
        for (int i = 0; i < n; ++i) {
            Command[] c;
            for (Command command : c = commandArray[i]) {
                if (command.getMode() != mode) continue;
                target.add(command);
            }
        }
    }

    public void nodeDelete(long nodeId) {
        RecordAccess.RecordProxy<NodeRecord, Object> nodeChange = this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null);
        NodeRecord nodeRecord = nodeChange.forChangingData();
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Unable to delete Node[" + nodeId + "] since it has already been deleted.");
        }
        if (nodeRecord.isDense()) {
            RelationshipGroupGetter.deleteEmptyGroups(nodeChange, g -> {
                this.locks.acquireExclusive(this.lockTracer, ResourceType.RELATIONSHIP_GROUP, new long[]{nodeId});
                return true;
            }, this.directGroupLookup);
        }
        nodeRecord.setInUse(false);
        nodeRecord.setLabelField(Record.NO_LABELS_FIELD.intValue(), TransactionRecordState.markNotInUse(nodeRecord.getDynamicLabelRecords()));
        this.getAndDeletePropertyChain(nodeRecord);
    }

    private static List<DynamicRecord> markNotInUse(List<DynamicRecord> dynamicLabelRecords) {
        for (DynamicRecord record : dynamicLabelRecords) {
            record.setInUse(false);
        }
        return dynamicLabelRecords;
    }

    private void getAndDeletePropertyChain(PrimitiveRecord record) {
        this.propertyDeleter.deletePropertyChain(record, this.recordChangeSet.getPropertyRecords(), this.memoryTracker);
    }

    void relRemoveProperty(long relId, int propertyKey) {
        RecordAccess.RecordProxy<RelationshipRecord, Object> rel = this.recordChangeSet.getRelRecords().getOrLoad(relId, null);
        this.propertyDeleter.removeProperty(rel, propertyKey, this.recordChangeSet.getPropertyRecords());
    }

    public void nodeRemoveProperty(long nodeId, int propertyKey) {
        RecordAccess.RecordProxy<NodeRecord, Object> node = this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null);
        this.propertyDeleter.removeProperty(node, propertyKey, this.recordChangeSet.getPropertyRecords());
    }

    void relChangeProperty(long relId, int propertyKey, Value value) {
        RecordAccess.RecordProxy<RelationshipRecord, Object> rel = this.recordChangeSet.getRelRecords().getOrLoad(relId, null);
        this.propertyCreator.primitiveSetProperty(rel, propertyKey, value, this.recordChangeSet.getPropertyRecords(), this.memoryTracker);
    }

    void nodeChangeProperty(long nodeId, int propertyKey, Value value) {
        RecordAccess.RecordProxy<NodeRecord, Object> node = this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null);
        this.propertyCreator.primitiveSetProperty(node, propertyKey, value, this.recordChangeSet.getPropertyRecords(), this.memoryTracker);
    }

    void relAddProperty(long relId, int propertyKey, Value value) {
        RecordAccess.RecordProxy<RelationshipRecord, Object> rel = this.recordChangeSet.getRelRecords().getOrLoad(relId, null);
        this.propertyCreator.primitiveSetProperty(rel, propertyKey, value, this.recordChangeSet.getPropertyRecords(), this.memoryTracker);
    }

    void nodeAddProperty(long nodeId, int propertyKey, Value value) {
        RecordAccess.RecordProxy<NodeRecord, Object> node = this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null);
        this.propertyCreator.primitiveSetProperty(node, propertyKey, value, this.recordChangeSet.getPropertyRecords(), this.memoryTracker);
    }

    void addLabelToNode(long labelId, long nodeId) {
        NodeRecord nodeRecord = this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forChangingData();
        NodeLabelsField.parseLabelsField(nodeRecord).add(labelId, this.nodeStore, this.dynamicAllocators.allocator(StoreType.NODE_LABEL), this.cursorContext, this.storeCursors, this.memoryTracker);
    }

    void removeLabelFromNode(long labelId, long nodeId) {
        NodeRecord nodeRecord = this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forChangingData();
        NodeLabelsField.parseLabelsField(nodeRecord).remove(labelId, this.nodeStore, this.dynamicAllocators.allocator(StoreType.NODE_LABEL), this.cursorContext, this.storeCursors, this.memoryTracker);
    }

    public void nodeCreate(long nodeId) {
        NodeRecord nodeRecord = this.recordChangeSet.getNodeRecords().create(nodeId, null, this.cursorContext).forChangingData();
        nodeRecord.setInUse(true);
        nodeRecord.setCreated();
    }

    void createPropertyKeyToken(String key, long id, boolean internal) {
        TransactionRecordState.createToken(this.neoStores.getPropertyKeyTokenStore(), key, id, internal, this.recordChangeSet.getPropertyKeyTokenChanges(), this.dynamicAllocators.allocator(StoreType.PROPERTY_KEY_TOKEN_NAME), this.cursorContext, this.memoryTracker);
    }

    void createLabelToken(String name, long id, boolean internal) {
        TransactionRecordState.createToken(this.neoStores.getLabelTokenStore(), name, id, internal, this.recordChangeSet.getLabelTokenChanges(), this.dynamicAllocators.allocator(StoreType.LABEL_TOKEN_NAME), this.cursorContext, this.memoryTracker);
    }

    void createRelationshipTypeToken(String name, long id, boolean internal) {
        TransactionRecordState.createToken(this.neoStores.getRelationshipTypeTokenStore(), name, id, internal, this.recordChangeSet.getRelationshipTypeTokenChanges(), this.dynamicAllocators.allocator(StoreType.RELATIONSHIP_TYPE_TOKEN_NAME), this.cursorContext, this.memoryTracker);
    }

    private static <R extends TokenRecord> void createToken(TokenStore<R> store, String name, long id, boolean internal, RecordAccess<R, Void> recordAccess, DynamicRecordAllocator nameStoreRecordAllocator, CursorContext cursorContext, MemoryTracker memoryTracker) {
        TokenRecord record = (TokenRecord)recordAccess.create(id, null, cursorContext).forChangingData();
        record.setInUse(true);
        record.setInternal(internal);
        record.setCreated();
        Collection<DynamicRecord> nameRecords = store.allocateNameRecords(PropertyStore.encodeString(name), nameStoreRecordAllocator, cursorContext, memoryTracker);
        record.setNameId((int)((DynamicRecord)Iterables.first(nameRecords)).getId());
        record.addNameRecords(nameRecords);
    }

    void schemaRuleCreate(long ruleId, boolean isConstraint, SchemaRule rule) {
        SchemaRecord record = this.recordChangeSet.getSchemaRuleChanges().create(ruleId, rule, this.cursorContext).forChangingData();
        record.setInUse(true);
        record.setCreated();
        record.setConstraint(isConstraint);
    }

    void schemaRuleDelete(long ruleId, SchemaRule rule) {
        RecordAccess.RecordProxy<SchemaRecord, SchemaRule> proxy = this.recordChangeSet.getSchemaRuleChanges().getOrLoad(ruleId, rule, RecordLoad.CHECK);
        SchemaRecord record = proxy.forReadingData();
        if (record.inUse()) {
            record = proxy.forChangingData();
            record.setInUse(false);
            this.getAndDeletePropertyChain(record);
        }
    }

    void schemaRuleSetProperty(long ruleId, int propertyKeyId, Value value, SchemaRule rule) {
        RecordAccess.RecordProxy<SchemaRecord, SchemaRule> record = this.recordChangeSet.getSchemaRuleChanges().getOrLoad(ruleId, rule);
        this.propertyCreator.primitiveSetProperty(record, propertyKeyId, value, this.recordChangeSet.getPropertyRecords(), this.memoryTracker);
    }

    void schemaRuleSetIndexOwner(IndexDescriptor rule, long constraintId, int propertyKeyId, Value value) {
        long ruleId = rule.getId();
        rule = rule.withOwningConstraintId(constraintId);
        RecordAccess<SchemaRecord, SchemaRule> changes = this.recordChangeSet.getSchemaRuleChanges();
        RecordAccess.RecordProxy<SchemaRecord, SchemaRule> record = changes.getOrLoad(ruleId, (SchemaRule)rule);
        changes.setRecord(ruleId, record.forReadingData(), (SchemaRule)rule, this.cursorContext).forChangingData();
        this.propertyCreator.primitiveSetProperty(record, propertyKeyId, value, this.recordChangeSet.getPropertyRecords(), this.memoryTracker);
    }

    @VisibleForTesting
    Long groupDegreeDelta(long groupId, RelationshipDirection direction) {
        MutableLong delta;
        if (this.groupDegreesUpdater.degrees != null && (delta = (MutableLong)this.groupDegreesUpdater.degrees.get(Command.GroupDegreeCommand.combinedKeyOnGroupAndDirection(groupId, direction))) != null) {
            return delta.getValue();
        }
        return null;
    }

    private static class DegreesUpdater
    implements DegreeUpdater {
        private MutableLongObjectMap<MutableLong> degrees;

        private DegreesUpdater() {
        }

        public void increment(long groupId, RelationshipDirection direction, long delta) {
            if (this.degrees == null) {
                this.degrees = LongObjectMaps.mutable.empty();
            }
            ((MutableLong)this.degrees.getIfAbsentPut(Command.GroupDegreeCommand.combinedKeyOnGroupAndDirection(groupId, direction), MutableLong::new)).add(delta);
        }

        public void close() {
        }
    }

    private static class CommandComparator
    implements Comparator<Command> {
        private CommandComparator() {
        }

        @Override
        public int compare(Command o1, Command o2) {
            long id1 = o1.getKey();
            long id2 = o2.getKey();
            return Long.compare(id1, id2);
        }
    }
}

