/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.LabelIdArray;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.util.Bits;

public class InlineNodeLabels
implements NodeLabels {
    private static final int LABEL_BITS = 36;
    private final NodeRecord node;

    public InlineNodeLabels(NodeRecord node) {
        this.node = node;
    }

    @Override
    public long[] get(NodeStore nodeStore, StoreCursors storeCursors) {
        return InlineNodeLabels.get(this.node);
    }

    public static long[] get(NodeRecord node) {
        return InlineNodeLabels.parseInlined(node.getLabelField());
    }

    @Override
    public Collection<DynamicRecord> put(long[] labelIds, NodeStore nodeStore, DynamicRecordAllocator allocator, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        Arrays.sort(labelIds);
        return InlineNodeLabels.putSorted(this.node, labelIds, nodeStore, allocator, cursorContext, storeCursors, memoryTracker);
    }

    public static Collection<DynamicRecord> putSorted(NodeRecord node, long[] labelIds, NodeStore nodeStore, DynamicRecordAllocator allocator, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        if (InlineNodeLabels.tryInlineInNodeRecord(node, labelIds, node.getDynamicLabelRecords())) {
            return Collections.emptyList();
        }
        return DynamicNodeLabels.putSorted(node, labelIds, nodeStore, allocator, cursorContext, storeCursors, memoryTracker);
    }

    @Override
    public Collection<DynamicRecord> add(long labelId, NodeStore nodeStore, DynamicRecordAllocator allocator, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        long[] lArray;
        if (InlineNodeLabels.labelCount(this.node.getLabelField()) == 0) {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = labelId;
        } else {
            lArray = LabelIdArray.concatAndSort(InlineNodeLabels.parseInlined(this.node.getLabelField()), labelId);
        }
        long[] augmentedLabelIds = lArray;
        return InlineNodeLabels.putSorted(this.node, augmentedLabelIds, nodeStore, allocator, cursorContext, storeCursors, memoryTracker);
    }

    @Override
    public Collection<DynamicRecord> remove(long labelId, NodeStore nodeStore, DynamicRecordAllocator allocator, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        long[] newLabelIds = LabelIdArray.filter(InlineNodeLabels.parseInlined(this.node.getLabelField()), labelId);
        boolean inlined = InlineNodeLabels.tryInlineInNodeRecord(this.node, newLabelIds, this.node.getDynamicLabelRecords());
        assert (inlined);
        return Collections.emptyList();
    }

    static boolean tryInlineInNodeRecord(NodeRecord node, long[] ids, List<DynamicRecord> changedDynamicRecords) {
        Bits bits;
        if (ids.length > 7) {
            return false;
        }
        byte bitsPerLabel = (byte)(ids.length > 0 ? 36 / ids.length : 36);
        if (!InlineNodeLabels.inlineValues(ids, bitsPerLabel, bits = Bits.bits((int)5))) {
            return false;
        }
        node.setLabelField(InlineNodeLabels.combineLabelCountAndLabelStorage((byte)ids.length, bits.getLongs()[0]), changedDynamicRecords);
        return true;
    }

    private static boolean inlineValues(long[] values, int maxBitsPerLabel, Bits target) {
        long limit = 1L << maxBitsPerLabel;
        for (long value : values) {
            if (Long.highestOneBit(value) >= limit) {
                return false;
            }
            target.put(value, maxBitsPerLabel);
        }
        return true;
    }

    public static long[] parseInlined(long labelField) {
        int numberOfLabels = InlineNodeLabels.labelCount(labelField);
        if (numberOfLabels == 0) {
            return ArrayUtils.EMPTY_LONG_ARRAY;
        }
        long existingLabelsField = NodeLabelsField.parseLabelsBody(labelField);
        byte bitsPerLabel = (byte)(36 / numberOfLabels);
        long mask = (1L << bitsPerLabel) - 1L;
        long[] result = new long[numberOfLabels];
        for (int i = 0; i < numberOfLabels; ++i) {
            result[i] = existingLabelsField & mask;
            existingLabelsField >>>= bitsPerLabel;
        }
        return result;
    }

    public static boolean hasLabel(NodeRecord node, int label) {
        long labelField = node.getLabelField();
        int numberOfLabels = InlineNodeLabels.labelCount(labelField);
        if (numberOfLabels == 0) {
            return false;
        }
        long existingLabelsField = NodeLabelsField.parseLabelsBody(labelField);
        byte bitsPerLabel = (byte)(36 / numberOfLabels);
        long mask = (1L << bitsPerLabel) - 1L;
        for (int i = 0; i < numberOfLabels; ++i) {
            if ((existingLabelsField & mask) == (long)label) {
                return true;
            }
            existingLabelsField >>>= bitsPerLabel;
        }
        return false;
    }

    private static long combineLabelCountAndLabelStorage(byte labelCount, long labelBits) {
        return (long)labelCount << 36 | labelBits;
    }

    private static byte labelCount(long labelField) {
        return (byte)((labelField & 0xF000000000L) >>> 36);
    }

    @Override
    public boolean isInlined() {
        return true;
    }

    public String toString() {
        return String.format("Inline(0x%x:%s)", this.node.getLabelField(), Arrays.toString(InlineNodeLabels.parseInlined(this.node.getLabelField())));
    }
}

