/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.configuration.Config;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.NoStoreHeaderFormat;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.util.IdUpdateListener;
import org.neo4j.token.api.NamedToken;

public abstract class TokenStore<RECORD extends TokenRecord>
extends CommonAbstractStore<RECORD, NoStoreHeader> {
    public static final int NAME_STORE_BLOCK_SIZE = 30;
    private final DynamicStringStore nameStore;
    private final CursorType cursorType;
    private final CursorType dynamicCursorType;

    public TokenStore(FileSystemAbstraction fileSystem, Path path, Path idFile, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, PageCacheTracer pageCacheTracer, InternalLogProvider logProvider, DynamicStringStore nameStore, String typeDescriptor, RecordFormat<RECORD> recordFormat, boolean readOnly, String databaseName, CursorType cursorType, CursorType dynamicCursorType, ImmutableSet<OpenOption> openOptions) {
        super(fileSystem, path, idFile, configuration, idType, idGeneratorFactory, pageCache, pageCacheTracer, logProvider, typeDescriptor, recordFormat, NoStoreHeaderFormat.NO_STORE_HEADER_FORMAT, readOnly, databaseName, openOptions);
        this.nameStore = nameStore;
        this.cursorType = cursorType;
        this.dynamicCursorType = dynamicCursorType;
    }

    public DynamicStringStore getNameStore() {
        return this.nameStore;
    }

    public List<NamedToken> getTokens(StoreCursors storeCursors) {
        return this.readAllTokens(false, storeCursors);
    }

    public List<NamedToken> getAllReadableTokens(StoreCursors storeCursors) {
        return this.readAllTokens(true, storeCursors);
    }

    private List<NamedToken> readAllTokens(boolean ignoreInconsistentTokens, StoreCursors storeCursors) {
        long highId = this.getIdGenerator().getHighId();
        ArrayList<NamedToken> records = new ArrayList<NamedToken>(Math.toIntExact(highId));
        TokenRecord record = (TokenRecord)this.newRecord();
        PageCursor cursor = this.getTokenStoreCursor(storeCursors);
        int i = 0;
        while ((long)i < highId) {
            block4: {
                if (this.getRecordByCursor(i, record, RecordLoad.LENIENT_CHECK, cursor).inUse() && record.getNameId() != Record.RESERVED.intValue()) {
                    try {
                        String name = this.getStringFor(record, storeCursors);
                        records.add(new NamedToken(name, i, record.isInternal()));
                    }
                    catch (Exception e) {
                        if (ignoreInconsistentTokens) break block4;
                        throw e;
                    }
                }
            }
            ++i;
        }
        return records;
    }

    public NamedToken getToken(int id, StoreCursors storeCursors) {
        TokenRecord record = this.getRecordByCursor(id, (TokenRecord)this.newRecord(), RecordLoad.NORMAL, this.getTokenStoreCursor(storeCursors));
        return new NamedToken(this.getStringFor(record, storeCursors), record.getIntId(), record.isInternal());
    }

    public Collection<DynamicRecord> allocateNameRecords(byte[] chars, DynamicRecordAllocator nameStoreRecordAllocator, CursorContext cursorContext, MemoryTracker memoryTracker) {
        HeapTrackingArrayList records = HeapTrackingCollections.newArrayList((MemoryTracker)memoryTracker);
        AbstractDynamicStore.allocateRecordsFromBytes((Collection<DynamicRecord>)records, chars, nameStoreRecordAllocator, cursorContext, memoryTracker);
        return records;
    }

    @Override
    public void updateRecord(RECORD record, IdUpdateListener idUpdateListener, PageCursor cursor, CursorContext cursorContext, StoreCursors storeCursors) {
        super.updateRecord(record, idUpdateListener, cursor, cursorContext, storeCursors);
        if (!((TokenRecord)record).isLight()) {
            try (PageCursor nameCursor = this.getWriteDynamicTokenCursor(storeCursors);){
                for (DynamicRecord keyRecord : ((TokenRecord)record).getNameRecords()) {
                    this.nameStore.updateRecord(keyRecord, idUpdateListener, nameCursor, cursorContext, storeCursors);
                }
            }
        }
    }

    @Override
    public void ensureHeavy(RECORD record, StoreCursors storeCursors) {
        if (!((TokenRecord)record).isLight()) {
            return;
        }
        ((TokenRecord)record).addNameRecords(this.nameStore.getRecords(((TokenRecord)record).getNameId(), RecordLoad.NORMAL, true, this.getDynamicTokenCursor(storeCursors)));
    }

    public PageCursor getTokenStoreCursor(StoreCursors storeCursors) {
        return storeCursors.readCursor(this.cursorType);
    }

    public PageCursor getDynamicTokenCursor(StoreCursors storeCursors) {
        return storeCursors.readCursor(this.dynamicCursorType);
    }

    public PageCursor getWriteDynamicTokenCursor(StoreCursors storeCursors) {
        return storeCursors.writeCursor(this.dynamicCursorType);
    }

    public String getStringFor(RECORD nameRecord, StoreCursors storeCursors) {
        this.ensureHeavy(nameRecord, storeCursors);
        int recordToFind = ((TokenRecord)nameRecord).getNameId();
        Iterator<DynamicRecord> records = ((TokenRecord)nameRecord).getNameRecords().iterator();
        ArrayList<DynamicRecord> relevantRecords = new ArrayList<DynamicRecord>();
        while (recordToFind != Record.NO_NEXT_BLOCK.intValue() && records.hasNext()) {
            DynamicRecord record = records.next();
            if (!record.inUse() || record.getId() != (long)recordToFind) continue;
            recordToFind = (int)record.getNextBlock();
            relevantRecords.add(record);
            records = ((TokenRecord)nameRecord).getNameRecords().iterator();
        }
        return PropertyStore.decodeString(this.nameStore.readFullByteArray(relevantRecords, PropertyType.STRING, storeCursors).data());
    }
}

