/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.standard;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.BaseOneByteHeaderRecordFormat;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class MetaDataRecordFormat
extends BaseOneByteHeaderRecordFormat<MetaDataRecord> {
    public static final int RECORD_SIZE = 9;
    private static final int ID_BITS = 32;

    public MetaDataRecordFormat() {
        this(true);
    }

    public MetaDataRecordFormat(boolean pageAligned) {
        super(MetaDataRecordFormat.fixedRecordSize(9), 0, 1, 32, pageAligned);
    }

    @Override
    public MetaDataRecord newRecord() {
        return new MetaDataRecord();
    }

    @Override
    public void read(MetaDataRecord record, PageCursor cursor, RecordLoad mode, int recordSize, int recordsPerPage) {
        int id = record.getIntId();
        if ((long)id > MetaDataStore.lastOccupiedSlot() && !mode.shouldLoad(false)) {
            record.initialize(false, 0L);
            return;
        }
        int offset = id * recordSize;
        cursor.setOffset(offset);
        boolean inUse = cursor.getByte() == Record.IN_USE.byteValue();
        long value = inUse ? cursor.getLong() : 0L;
        record.initialize(inUse, value);
    }

    @Override
    public void write(MetaDataRecord record, PageCursor cursor, int recordSize, int recordsPerPage) {
        assert (record.inUse());
        cursor.putByte(Record.IN_USE.byteValue());
        cursor.putLong(record.getValue());
    }
}

