/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.memory.HeapEstimator;

public class PropertyRecord
extends AbstractBaseRecord
implements Iterable<PropertyBlock> {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(PropertyRecord.class);
    private static final int PAYLOAD_SIZE = PropertyType.getPayloadSizeLongs();
    public static final long INITIAL_SIZE = SHALLOW_SIZE + HeapEstimator.sizeOf((long[])new long[PAYLOAD_SIZE]) + HeapEstimator.shallowSizeOfObjectArray((int)PAYLOAD_SIZE) + PropertyBlock.HEAP_SIZE;
    private static final byte TYPE_NODE = 1;
    private static final byte TYPE_REL = 2;
    private static final byte TYPE_SCHEMA_RULE = 3;
    private long nextProp;
    private long prevProp;
    private final long[] blocks = new long[PAYLOAD_SIZE];
    private int blocksCursor;
    private final PropertyBlock[] blockRecords = new PropertyBlock[PAYLOAD_SIZE];
    private int blockRecordsCursor;
    private boolean blocksLoaded;
    private long entityId;
    private byte entityType;
    private List<DynamicRecord> deletedRecords;

    public PropertyRecord(long id) {
        super(id);
    }

    public PropertyRecord(long id, PrimitiveRecord primitive) {
        super(id);
        primitive.setIdTo(this);
    }

    public PropertyRecord(PropertyRecord other) {
        super(other);
        this.nextProp = other.nextProp;
        this.prevProp = other.prevProp;
        System.arraycopy(other.blocks, 0, this.blocks, 0, other.blocks.length);
        this.blocksCursor = other.blocksCursor;
        this.blockRecordsCursor = other.blockRecordsCursor;
        this.blocksLoaded = other.blocksLoaded;
        this.entityId = other.entityId;
        this.entityType = other.entityType;
        for (int i = 0; i < this.blockRecordsCursor; ++i) {
            this.blockRecords[i] = new PropertyBlock(other.blockRecords[i]);
        }
        if (other.deletedRecords != null) {
            this.deletedRecords = new ArrayList<DynamicRecord>(other.deletedRecords.size());
            for (DynamicRecord deletedRecord : other.deletedRecords) {
                this.deletedRecords.add(new DynamicRecord(deletedRecord));
            }
        }
    }

    public PropertyRecord initialize(boolean inUse, long prevProp, long nextProp) {
        super.initialize(inUse);
        this.prevProp = prevProp;
        this.nextProp = nextProp;
        this.deletedRecords = null;
        this.blocksCursor = 0;
        this.blockRecordsCursor = 0;
        this.blocksLoaded = false;
        return this;
    }

    @Override
    public void clear() {
        super.initialize(false);
        this.entityId = -1L;
        this.entityType = 0;
        this.prevProp = Record.NO_PREVIOUS_PROPERTY.intValue();
        this.nextProp = Record.NO_NEXT_PROPERTY.intValue();
        this.deletedRecords = null;
        this.blocksCursor = 0;
        this.blockRecordsCursor = 0;
        this.blocksLoaded = false;
    }

    public void setNodeId(long nodeId) {
        this.entityType = 1;
        this.entityId = nodeId;
    }

    public void setRelId(long relId) {
        this.entityType = (byte)2;
        this.entityId = relId;
    }

    public void setSchemaRuleId(long id) {
        this.entityType = (byte)3;
        this.entityId = id;
    }

    public void setEntity(PropertyRecord other) {
        this.entityType = other.entityType;
        this.entityId = other.entityId;
    }

    public boolean isNodeSet() {
        return this.entityType == 1;
    }

    public boolean isRelSet() {
        return this.entityType == 2;
    }

    public boolean isSchemaSet() {
        return this.entityType == 3;
    }

    public long getNodeId() {
        if (this.isNodeSet()) {
            return this.entityId;
        }
        return -1L;
    }

    public long getRelId() {
        if (this.isRelSet()) {
            return this.entityId;
        }
        return -1L;
    }

    public long getSchemaRuleId() {
        if (this.isSchemaSet()) {
            return this.entityId;
        }
        return -1L;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public int size() {
        this.ensureBlocksLoaded();
        int result = 0;
        for (int i = 0; i < this.blockRecordsCursor; ++i) {
            result += this.blockRecords[i].getSize();
        }
        return result;
    }

    public int numberOfProperties() {
        this.ensureBlocksLoaded();
        return this.blockRecordsCursor;
    }

    public PropertyBlock[] getPropertyBlocks() {
        return this.blockRecords;
    }

    @Override
    public Iterator<PropertyBlock> iterator() {
        this.ensureBlocksLoaded();
        return new Iterator<PropertyBlock>(){
            private int blockRecordsIteratorCursor;
            private boolean canRemoveFromIterator;

            @Override
            public boolean hasNext() {
                return this.blockRecordsIteratorCursor < PropertyRecord.this.blockRecordsCursor;
            }

            @Override
            public PropertyBlock next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.canRemoveFromIterator = true;
                return PropertyRecord.this.blockRecords[this.blockRecordsIteratorCursor++];
            }

            @Override
            public void remove() {
                if (!this.canRemoveFromIterator) {
                    throw new IllegalStateException("cursor:" + this.blockRecordsIteratorCursor + " canRemove:" + this.canRemoveFromIterator);
                }
                if (--PropertyRecord.this.blockRecordsCursor > --this.blockRecordsIteratorCursor) {
                    PropertyRecord.this.blockRecords[this.blockRecordsIteratorCursor] = PropertyRecord.this.blockRecords[PropertyRecord.this.blockRecordsCursor];
                }
                this.canRemoveFromIterator = false;
            }
        };
    }

    public List<DynamicRecord> getDeletedRecords() {
        return this.deletedRecords != null ? this.deletedRecords : Collections.emptyList();
    }

    public void addDeletedRecord(DynamicRecord record) {
        assert (!record.inUse());
        if (this.deletedRecords == null) {
            this.deletedRecords = new ArrayList<DynamicRecord>(1);
        }
        this.deletedRecords.add(record);
    }

    public void addPropertyBlock(PropertyBlock block) {
        this.ensureBlocksLoaded();
        assert (this.hasSpaceFor(block)) : "Exceeded capacity of property record " + this + ". My current size is reported as " + this.size() + "The added block was " + block + " (note that size is " + block.getSize() + ")";
        this.blockRecords[this.blockRecordsCursor++] = block;
    }

    public boolean hasSpaceFor(PropertyBlock block) {
        return this.size() + block.getSize() <= PropertyType.getPayloadSize();
    }

    public void ensureBlocksLoaded() {
        if (!this.blocksLoaded) {
            int length;
            assert (this.blockRecordsCursor == 0);
            for (int index = 0; index < this.blocksCursor; index += length) {
                PropertyType type = PropertyType.getPropertyTypeOrThrow(this.blocks[index]);
                PropertyBlock block = new PropertyBlock();
                length = type.calculateNumberOfBlocksUsed(this.blocks[index]);
                block.setValueBlocks(Arrays.copyOfRange(this.blocks, index, index + length));
                this.blockRecords[this.blockRecordsCursor++] = block;
            }
            this.blocksLoaded = true;
        }
    }

    public PropertyBlock getPropertyBlock(int keyIndex) {
        this.ensureBlocksLoaded();
        for (int i = 0; i < this.blockRecordsCursor; ++i) {
            PropertyBlock block = this.blockRecords[i];
            if (block.getKeyIndexId() != keyIndex) continue;
            return block;
        }
        return null;
    }

    public PropertyBlock removePropertyBlock(int keyIndex) {
        this.ensureBlocksLoaded();
        for (int i = 0; i < this.blockRecordsCursor; ++i) {
            if (this.blockRecords[i].getKeyIndexId() != keyIndex) continue;
            PropertyBlock block = this.blockRecords[i];
            if (--this.blockRecordsCursor > i) {
                this.blockRecords[i] = this.blockRecords[this.blockRecordsCursor];
            }
            return block;
        }
        return null;
    }

    public void clearPropertyBlocks() {
        this.blockRecordsCursor = 0;
    }

    public long getNextProp() {
        return this.nextProp;
    }

    public void setNextProp(long nextProp) {
        this.nextProp = nextProp;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Property[").append(this.getId()).append(",used=").append(this.inUse()).append(",prev=").append(this.prevProp).append(",next=").append(this.nextProp).append(",created=").append(this.isCreated()).append(",");
        switch (this.entityType) {
            case 1: {
                buf.append("node");
                break;
            }
            case 2: {
                buf.append("rel");
                break;
            }
            case 3: {
                buf.append("schema");
                break;
            }
            default: {
                buf.append("unkownType(").append(this.entityType).append(")");
            }
        }
        buf.append("=").append(this.entityId);
        if (this.blocksLoaded) {
            for (int i = 0; i < this.blockRecordsCursor; ++i) {
                buf.append(',').append(this.blockRecords[i]);
            }
        } else {
            buf.append(", (blocks not loaded)");
        }
        if (this.deletedRecords != null) {
            for (DynamicRecord dyn : this.deletedRecords) {
                buf.append(", del:").append(dyn);
            }
        }
        buf.append(']');
        return buf.toString();
    }

    public void setChanged(PrimitiveRecord primitive) {
        primitive.setIdTo(this);
    }

    public long getPrevProp() {
        return this.prevProp;
    }

    public void setPrevProp(long prev) {
        this.prevProp = prev;
    }

    public long[] getBlocks() {
        return this.blocks;
    }

    public void addLoadedBlock(long block) {
        assert (this.blocksCursor + 1 <= this.blocks.length) : "Capacity of " + this.blocks.length + " exceeded";
        this.blocks[this.blocksCursor++] = block;
    }

    public int getBlockCapacity() {
        return this.blocks.length;
    }

    public int getNumberOfBlocks() {
        return this.blocksCursor;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nextProp, this.prevProp, Arrays.hashCode(this.blocks), this.entityId, this.entityType);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        PropertyRecord other = (PropertyRecord)obj;
        return this.nextProp == other.nextProp && this.prevProp == other.prevProp && Arrays.equals(this.blocks, 0, this.blocksCursor, other.blocks, 0, other.blocksCursor) && this.entityId == other.entityId && this.entityType == other.entityType;
    }
}

