/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.util.Objects;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.memory.HeapEstimator;

public class SchemaRecord
extends PrimitiveRecord {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(SchemaRecord.class);
    public static final byte COMMAND_HAS_NO_SCHEMA_RULE = 0;
    public static final byte COMMAND_HAS_SCHEMA_RULE = 1;
    public static final byte SCHEMA_FLAG_IS_CONSTRAINT = 1;
    private boolean constraint;

    public SchemaRecord(long id) {
        super(id);
    }

    public SchemaRecord(SchemaRecord other) {
        super(other);
        this.constraint = other.constraint;
    }

    @Override
    public void setIdTo(PropertyRecord property) {
        property.setSchemaRuleId(this.getId());
    }

    @Override
    public SchemaRecord initialize(boolean inUse, long nextProp) {
        super.initialize(inUse, nextProp);
        return this;
    }

    public String toString() {
        return "SchemaRecord[" + this.getId() + ",used=" + this.inUse() + ",created=" + this.isCreated() + ",nextProp=" + this.nextProp + ",constraint=" + this.constraint + ",secondaryUnitId" + this.getSecondaryUnitId() + ",fixedReferences=" + this.isUseFixedReferences() + "]";
    }

    public boolean isConstraint() {
        return this.constraint;
    }

    public void setConstraint(boolean constraint) {
        this.constraint = constraint;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.constraint);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        SchemaRecord other = (SchemaRecord)obj;
        return this.constraint == other.constraint;
    }
}

