/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.SchemaIdType;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseFile;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.SchemaStoreMigration;
import org.neo4j.kernel.impl.storemigration.StoreMigratorFileOperation;
import org.neo4j.kernel.impl.storemigration.legacy.SchemaStore44Reader;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.SchemaRule44;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.migration.SchemaRuleMigrationAccess;
import org.neo4j.token.TokenHolders;

public class SchemaStore44Migration {
    public static final IndexPrototype NLI_PROTOTYPE = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE), (IndexProviderDescriptor)new IndexProviderDescriptor("token-lookup", "1.0")).withIndexType(IndexType.LOOKUP).withName("__org_neo4j_schema_index_label_scan_store_converted_to_token_index");

    /*
     * Exception decompiling
     */
    static SchemaStore44Migrator getSchemaStore44Migrator(FileSystemAbstraction fileSystem, RecordFormats oldFormat, RecordDatabaseLayout directoryLayout, CursorContext cursorContext, boolean shouldCreateNewSchemaStore, boolean forceBtreeIndexesToRange, Config config, PageCache pageCache, PageCacheTracer pageCacheTracer, CursorContextFactory contextFactory, IdGeneratorFactory srcIdGeneratorFactory, StoreFactory srcFactory) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static SchemaStore44Migrator getSchemaStoreMigration44(SchemaStore44Reader schemaStore44Reader, StoreCursors srcCursors, boolean forceBtreeIndexesToRange, boolean shouldCreateNewSchemaStore, TokenHolders srcTokenHolders) {
        SchemaRule44.Index nli;
        List<SchemaRule44> all = schemaStore44Reader.loadAllSchemaRules(srcCursors);
        ArrayList<SchemaRule44> toDelete = new ArrayList<SchemaRule44>();
        ArrayList<SchemaRule> toCreate = new ArrayList<SchemaRule>();
        HashMap<SchemaDescriptor, List> indexesBySchema = new HashMap<SchemaDescriptor, List>();
        HashMap<String, SchemaRule44.Index> uniqueIndexesByName = new HashMap<String, SchemaRule44.Index>();
        HashMap<SchemaDescriptor, EnumMap> constraintBySchemaAndType = new HashMap<SchemaDescriptor, EnumMap>();
        for (SchemaRule44 schemaRule : all) {
            if (schemaRule instanceof SchemaRule44.Index) {
                SchemaRule44.Index index = (SchemaRule44.Index)schemaRule;
                if (!index.unique()) {
                    indexesBySchema.computeIfAbsent(index.schema(), k -> new ArrayList()).add(index);
                } else {
                    uniqueIndexesByName.put(index.name(), index);
                }
                if (shouldCreateNewSchemaStore && index.indexType() != SchemaRule44.IndexType.BTREE) {
                    toCreate.add(schemaRule.convertTo50rule());
                }
            }
            if (!(schemaRule instanceof SchemaRule44.Constraint)) continue;
            SchemaRule44.Constraint constraint = (SchemaRule44.Constraint)schemaRule;
            boolean indexBacked = constraint.constraintRuleType().isIndexBacked();
            if (indexBacked) {
                EnumMap constraintsByType = constraintBySchemaAndType.computeIfAbsent(constraint.schema(), k -> new EnumMap(SchemaRule44.ConstraintRuleType.class));
                constraintsByType.computeIfAbsent(constraint.constraintRuleType(), k -> new ArrayList()).add(constraint);
            }
            if (!shouldCreateNewSchemaStore || indexBacked && constraint.indexType() != SchemaRule44.IndexType.RANGE) continue;
            toCreate.add(schemaRule.convertTo50rule());
        }
        List nlis = (List)indexesBySchema.get(SchemaStore44Reader.FORMER_LABEL_SCAN_STORE_SCHEMA);
        if (!shouldCreateNewSchemaStore && nlis != null && !nlis.isEmpty() && "__org_neo4j_schema_index_label_scan_store_converted_to_token_index".equals((nli = (SchemaRule44.Index)nlis.get(0)).name())) {
            toCreate.add(nli.convertTo50rule());
        }
        ArrayList<SchemaRule44.Index> nonReplacedIndexes = new ArrayList<SchemaRule44.Index>();
        for (SchemaDescriptor schema : indexesBySchema.keySet()) {
            List indexes = (List)indexesBySchema.get(schema);
            for (SchemaRule44.Index index : indexes) {
                if (index.indexType() != SchemaRule44.IndexType.BTREE) continue;
                if (indexes.size() == 1) {
                    nonReplacedIndexes.add(index);
                    continue;
                }
                toDelete.add((SchemaRule44)index);
            }
        }
        ArrayList<Pair<SchemaRule44.Constraint, SchemaRule44.Index>> nonReplacedConstraints = new ArrayList<Pair<SchemaRule44.Constraint, SchemaRule44.Index>>();
        constraintBySchemaAndType.values().stream().flatMap(enumMap -> enumMap.values().stream()).forEach(constraintsGroupedBySchemaAndType -> {
            for (SchemaRule44.Constraint constraint : constraintsGroupedBySchemaAndType) {
                SchemaRule44.Index backingIndex = (SchemaRule44.Index)uniqueIndexesByName.remove(constraint.name());
                if (backingIndex.indexType() != SchemaRule44.IndexType.BTREE) continue;
                if (constraintsGroupedBySchemaAndType.size() == 1) {
                    nonReplacedConstraints.add(Pair.of((Object)constraint, (Object)backingIndex));
                    continue;
                }
                toDelete.add((SchemaRule44)constraint);
                toDelete.add((SchemaRule44)backingIndex);
            }
        });
        for (SchemaRule44.Index uniqueIndex : uniqueIndexesByName.values()) {
            if (uniqueIndex.indexType() != SchemaRule44.IndexType.BTREE) continue;
            nonReplacedIndexes.add(uniqueIndex);
        }
        return new SchemaStore44Migrator(shouldCreateNewSchemaStore, forceBtreeIndexesToRange, nonReplacedIndexes, nonReplacedConstraints, toDelete, toCreate, srcTokenHolders);
    }

    private static ConstraintDescriptor asRangeBackedConstraint(SchemaRule44.Constraint constraint, IndexDescriptor rangeIndex, SchemaRuleMigrationAccess dstAccess, TokenHolders dstTokensHolders) {
        UniquenessConstraintDescriptor newConstraint;
        if (constraint.constraintRuleType() == SchemaRule44.ConstraintRuleType.UNIQUE) {
            newConstraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)constraint.schema(), (IndexType)rangeIndex.getIndexType());
        } else if (constraint.constraintRuleType() == SchemaRule44.ConstraintRuleType.UNIQUE_EXISTS) {
            newConstraint = ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)constraint.schema(), (IndexType)rangeIndex.getIndexType());
        } else {
            throw new IllegalStateException("We should never see non-index-backed constraint here, but got: " + constraint.userDescription((TokenNameLookup)dstTokensHolders));
        }
        return newConstraint.withOwnedIndexId(rangeIndex.getId()).withName(constraint.name()).withId(dstAccess.nextId());
    }

    private static IndexDescriptor asRangeIndex(SchemaRule44.Index btreeIndex, SchemaRuleMigrationAccess dstAccess) {
        IndexPrototype prototype = btreeIndex.unique() ? IndexPrototype.uniqueForSchema((SchemaDescriptor)btreeIndex.schema()) : IndexPrototype.forSchema((SchemaDescriptor)btreeIndex.schema());
        return prototype.withName(btreeIndex.name()).withIndexType(IndexType.RANGE).withIndexProvider(new IndexProviderDescriptor("range", "1.0")).materialise(dstAccess.nextId());
    }

    private static SchemaStore44Reader getSchemaStore44Reader(FileSystemAbstraction fileSystem, RecordDatabaseLayout recordDatabaseLayout, RecordFormats formats, IdGeneratorFactory idGeneratorFactory, NeoStores neoStores, TokenHolders tokenHolders, Config config, PageCache pageCache, PageCacheTracer pageCacheTracer, CursorContextFactory contextFactory, KernelVersion kernelVersion) {
        return new SchemaStore44Reader(fileSystem, neoStores.getPropertyStore(), tokenHolders, kernelVersion, recordDatabaseLayout.schemaStore(), recordDatabaseLayout.idSchemaStore(), config, (IdType)SchemaIdType.SCHEMA, idGeneratorFactory, pageCache, pageCacheTracer, contextFactory, (InternalLogProvider)NullLogProvider.getInstance(), formats, recordDatabaseLayout.getDatabaseName(), neoStores.getOpenOptions());
    }

    public record SchemaStore44Migrator(boolean shouldCreateNewSchemaStore, boolean forceBtreeIndexesToRange, List<SchemaRule44.Index> nonReplacedIndexes, List<Pair<SchemaRule44.Constraint, SchemaRule44.Index>> nonReplacedConstraints, List<SchemaRule44> toDelete, List<SchemaRule> existingSchemaRulesToAdd, TokenHolders srcTokenHolders) implements SchemaStoreMigration.SchemaStoreMigrator
    {
        @Override
        public void assertCanMigrate() throws IllegalStateException {
            if (!(this.forceBtreeIndexesToRange || this.nonReplacedIndexes.isEmpty() && this.nonReplacedConstraints.isEmpty())) {
                StringJoiner nonReplacedIndexString = new StringJoiner(", ", "[", "]");
                StringJoiner nonReplacedConstraintsString = new StringJoiner(", ", "[", "]");
                this.nonReplacedIndexes.forEach(index -> nonReplacedIndexString.add(index.userDescription((TokenNameLookup)this.srcTokenHolders)));
                this.nonReplacedConstraints.forEach(pair -> nonReplacedConstraintsString.add(((SchemaRule44.Constraint)pair.first()).userDescription((TokenNameLookup)this.srcTokenHolders)));
                throw new IllegalStateException("Migration will remove all BTREE indexes and constraints backed by BTREE indexes. To guard against unintentionally removing indexes or constraints, it is recommended for all BTREE indexes or constraints backed by BTREE indexes to have a valid replacement. Indexes can be replaced by RANGE, TEXT or POINT index and constraints can be replaced by constraints backed by RANGE index. Please drop your indexes and constraints or create replacements and retry the migration. The indexes and constraints without replacement are: " + nonReplacedIndexString + " and " + nonReplacedConstraintsString + ". Alternatively, you can use the option --force-btree-indexes-to-range to force all BTREE indexes or constraints backed by BTREE indexes to be replaced by RANGE equivalents. Be aware that RANGE indexes are not always the optimal replacement of BTREEs and performance may be affected while the new indexes are populated. See the Neo4j v5 migration guide online for more information.");
            }
        }

        @Override
        public void copyFilesInPreparationForMigration(FileSystemAbstraction fileSystem, RecordDatabaseLayout directoryLayout, RecordDatabaseLayout migrationLayout) throws IOException {
            List<DatabaseFile> databaseFiles = this.shouldCreateNewSchemaStore ? Arrays.asList(RecordDatabaseFile.PROPERTY_STORE, RecordDatabaseFile.PROPERTY_ARRAY_STORE, RecordDatabaseFile.PROPERTY_STRING_STORE, RecordDatabaseFile.PROPERTY_KEY_TOKEN_STORE, RecordDatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE, RecordDatabaseFile.LABEL_TOKEN_STORE, RecordDatabaseFile.LABEL_TOKEN_NAMES_STORE, RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE, RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE) : Arrays.asList(RecordDatabaseFile.SCHEMA_STORE, RecordDatabaseFile.PROPERTY_STORE, RecordDatabaseFile.PROPERTY_ARRAY_STORE, RecordDatabaseFile.PROPERTY_STRING_STORE, RecordDatabaseFile.PROPERTY_KEY_TOKEN_STORE, RecordDatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE, RecordDatabaseFile.LABEL_TOKEN_STORE, RecordDatabaseFile.LABEL_TOKEN_NAMES_STORE, RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE, RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE);
            StoreMigratorFileOperation.fileOperation(FileOperation.COPY, fileSystem, (DatabaseLayout)directoryLayout, (DatabaseLayout)migrationLayout, databaseFiles, true, true, ExistingTargetStrategy.SKIP);
        }

        @Override
        public void migrate(SchemaRuleMigrationAccess dstAccess, TokenHolders dstTokensHolders) throws KernelException {
            boolean foundNliWithoutId = false;
            for (SchemaRule schemaRule : this.existingSchemaRulesToAdd) {
                if (schemaRule.getId() == -2L) {
                    foundNliWithoutId = true;
                    continue;
                }
                dstAccess.writeSchemaRule(schemaRule);
            }
            if (foundNliWithoutId) {
                dstAccess.writeSchemaRule((SchemaRule)NLI_PROTOTYPE.materialise(dstAccess.nextId()));
            }
            if (this.forceBtreeIndexesToRange) {
                for (SchemaRule44.Index index : this.nonReplacedIndexes) {
                    IndexDescriptor rangeIndex = SchemaStore44Migration.asRangeIndex(index, dstAccess);
                    dstAccess.writeSchemaRule((SchemaRule)rangeIndex);
                    this.toDelete.add((SchemaRule44)index);
                }
                for (Pair pair : this.nonReplacedConstraints) {
                    SchemaRule44.Constraint oldConstraint = (SchemaRule44.Constraint)pair.first();
                    SchemaRule44.Index oldIndex = (SchemaRule44.Index)pair.other();
                    IndexDescriptor rangeIndex = SchemaStore44Migration.asRangeIndex(oldIndex, dstAccess);
                    ConstraintDescriptor rangeBackedConstraint = SchemaStore44Migration.asRangeBackedConstraint(oldConstraint, rangeIndex, dstAccess, dstTokensHolders);
                    rangeIndex = rangeIndex.withOwningConstraintId(rangeBackedConstraint.getId());
                    dstAccess.writeSchemaRule((SchemaRule)rangeIndex);
                    dstAccess.writeSchemaRule((SchemaRule)rangeBackedConstraint);
                    this.toDelete.add((SchemaRule44)oldIndex);
                    this.toDelete.add((SchemaRule44)oldConstraint);
                }
            }
            if (!this.shouldCreateNewSchemaStore) {
                for (SchemaRule44 schemaRule44 : this.toDelete) {
                    dstAccess.deleteSchemaRule(schemaRule44.id());
                }
            }
        }
    }
}

