/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import java.util.function.Function;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class ClientSideHostnameVerificationEngineModification
implements Function<SSLEngine, SSLEngine> {
    @Override
    public SSLEngine apply(SSLEngine sslEngine) {
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        sslParameters.setEndpointIdentificationAlgorithm(VerificationAlgorithm.HTTPS.getValue());
        sslEngine.setSSLParameters(sslParameters);
        return sslEngine;
    }

    private static enum VerificationAlgorithm {
        HTTPS("HTTPS"),
        LDAPS("LDAPS");

        private final String value;

        private VerificationAlgorithm(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

