/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.concurrent.Callable;
import org.neo4j.common.Subject;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;

public class PopulationWorkJobScheduler
implements IndexPopulator.PopulationWorkScheduler {
    private final JobScheduler jobScheduler;
    private final DatabaseLayout databaseLayout;

    public PopulationWorkJobScheduler(JobScheduler jobScheduler, DatabaseLayout databaseLayout) {
        this.jobScheduler = jobScheduler;
        this.databaseLayout = databaseLayout;
    }

    public <T> JobHandle<T> schedule(IndexPopulator.JobDescriptionSupplier descriptionSupplier, Callable<T> job) {
        return this.jobScheduler.schedule(Group.INDEX_POPULATION_WORK, new JobMonitoringParams(Subject.ANONYMOUS, this.databaseLayout.getDatabaseName(), "complete index population scan"), job);
    }

    public JobScheduler jobScheduler() {
        return this.jobScheduler;
    }
}

