/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.csv.Type;
import org.neo4j.values.storable.CSVHeaderInformation;

public class Header {
    private final Entry[] entries;
    public static final Monitor NO_MONITOR = (source, header, from, to) -> {};

    public Header(Entry ... entries) {
        this.entries = entries;
    }

    public Entry[] entries() {
        return this.entries;
    }

    public String toString() {
        return Arrays.toString(this.entries);
    }

    public record Entry(String rawEntry, String name, Type type, Group group, Extractor<?> extractor, Map<String, String> rawOptions, CSVHeaderInformation optionalParameter) {
        public Entry(String name, Type type, Group group, Extractor<?> extractor) {
            this(null, name, type, group, extractor);
        }

        public Entry(String rawEntry, String name, Type type, Group group, Extractor<?> extractor) {
            this(rawEntry, name, type, group, extractor, Collections.emptyMap(), null);
        }

        @Override
        public String toString() {
            if (this.rawEntry != null) {
                return this.rawEntry;
            }
            return String.format("Entry[name:%s, type:%s, group:%s, options:%s, optionalParameter:%s]", new Object[]{this.name, this.type, this.group, this.rawOptions, this.optionalParameter});
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return Objects.equals(this.name, entry.name) && this.type == entry.type && Objects.equals(this.group, entry.group) && Objects.equals(this.extractor, entry.extractor) && this.rawOptions.equals(entry.rawOptions) && Objects.equals(this.optionalParameter, entry.optionalParameter);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.type, this.group, this.extractor, this.rawOptions, this.optionalParameter});
        }
    }

    public static interface Monitor {
        public void typeNormalized(String var1, String var2, String var3, String var4);
    }

    public static class PrintingMonitor
    implements Monitor {
        private final PrintStream out;
        private boolean first = true;

        PrintingMonitor(PrintStream out) {
            this.out = out;
        }

        @Override
        public void typeNormalized(String sourceDescription, String name, String fromType, String toType) {
            if (this.first) {
                this.out.println("Cypher type normalization is enabled (disable with --normalize-types=false):");
                this.first = false;
            }
            this.out.printf("  Property type of '%s' normalized from '%s' --> '%s' in %s%n", name, fromType, toType, sourceDescription);
        }
    }

    public static interface Factory {
        default public Header create(CharSeeker dataSeeker, Configuration configuration, IdType idType, Groups groups) {
            return this.create(dataSeeker, configuration, idType, groups, NO_MONITOR);
        }

        public Header create(CharSeeker var1, Configuration var2, IdType var3, Groups var4, Monitor var5);

        public boolean isDefined();
    }
}

