/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.util.concurrent.TimeUnit;
import org.neo4j.internal.batchimport.Parallelizable;
import org.neo4j.internal.batchimport.staging.Panicable;
import org.neo4j.internal.batchimport.stats.Key;
import org.neo4j.internal.batchimport.stats.StepStats;

public interface Step<T>
extends Parallelizable,
AutoCloseable,
Panicable {
    public static final int ORDER_SEND_DOWNSTREAM = 1;
    public static final int RECYCLE_BATCHES = 2;

    public void start(int var1);

    public String name();

    public long receive(long var1, T var3);

    public StepStats stats();

    default public boolean isIdle() {
        return false;
    }

    default public long longStat(Key key) {
        return this.stats().stat(key).asLong();
    }

    default public int maxProcessors() {
        return 1;
    }

    public void endOfUpstream();

    public boolean isCompleted();

    default public void awaitCompleted() throws InterruptedException {
        this.awaitCompleted(Long.MAX_VALUE, TimeUnit.HOURS);
    }

    public boolean awaitCompleted(long var1, TimeUnit var3) throws InterruptedException;

    public void setDownstream(Step<?> var1);

    @Override
    public void close() throws Exception;
}

