/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands;

import java.io.Serializable;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import org.eclipse.collections.impl.block.factory.primitive.LongPredicates;
import org.neo4j.cypher.internal.expressions.SemanticDirection;
import org.neo4j.cypher.internal.logical.plans.Expand;
import org.neo4j.cypher.internal.logical.plans.NFA;
import org.neo4j.cypher.internal.planner.spi.ReadTokenContext;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.ast.ExpressionVariable;
import org.neo4j.cypher.internal.runtime.ast.ExpressionVariable$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.CommandNFA;
import org.neo4j.cypher.internal.runtime.interpreted.commands.KeyTokenResolver$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.convert.ExpressionConverters;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Predicate;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.RelationshipTypes;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.RelationshipTypes$;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;

public final class CommandNFA$
implements Serializable {
    public static final CommandNFA$ MODULE$ = new CommandNFA$();

    public Direction kernelDirection(SemanticDirection dir) {
        SemanticDirection semanticDirection = dir;
        if (SemanticDirection.OUTGOING$.MODULE$.equals(semanticDirection)) {
            return Direction.OUTGOING;
        }
        if (SemanticDirection.INCOMING$.MODULE$.equals(semanticDirection)) {
            return Direction.INCOMING;
        }
        if (SemanticDirection.BOTH$.MODULE$.equals(semanticDirection)) {
            return Direction.BOTH;
        }
        throw new MatchError((Object)semanticDirection);
    }

    public CommandNFA fromLogicalNFA(int id, NFA logicalNFA, IntPredicate stateCorrespondsToGroupVariable, ExpressionConverters expressionConverters, ReadTokenContext tokenContext) {
        ObjectRef startState = ObjectRef.create(null);
        Builder finalStates = Predef$.MODULE$.Set().newBuilder();
        Map stateLookup = logicalNFA.states().iterator().map((Function1 & Serializable)logicalState -> {
            State.VarName varName = new State.VarName(logicalState.variable().name(), stateCorrespondsToGroupVariable.test(logicalState.id()));
            CommandNFA.State commandState = new CommandNFA.State(logicalState.id(), varName, null, null);
            NFA.State state = logicalNFA.startState();
            NFA.State state2 = logicalState;
            if (!(state != null ? !state.equals(state2) : state2 != null)) {
                Predef$.MODULE$.assert((CommandNFA.State)startState$1.elem == null, (Function0 & Serializable)() -> "There should only be one start state in an NFA");
                startState$1.elem = commandState;
            }
            Object object = logicalNFA.finalStates().contains(logicalState) ? finalStates.addOne((Object)commandState) : BoxedUnit.UNIT;
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(logicalState), (Object)commandState);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        logicalNFA.states().foreach((Function1 & Serializable)logicalState -> {
            CommandNFA$.$anonfun$fromLogicalNFA$3(logicalNFA, id, stateLookup, expressionConverters, tokenContext, stateCorrespondsToGroupVariable, logicalState);
            return BoxedUnit.UNIT;
        });
        return new CommandNFA((Set<CommandNFA.State>)stateLookup.values().toSet(), (CommandNFA.State)startState.elem, (Set<CommandNFA.State>)((Set)finalStates.result()));
    }

    public CommandNFA.NodeJuxtapositionTransition compileStubbedNodeJuxtaposition(int id, NFA.NodeJuxtapositionPredicate logicalPredicate, CommandNFA.State end, ExpressionConverters expressionConverters, ReadTokenContext tokenContext) {
        Option<Function3<CypherRow, QueryState, AnyValue, Object>> commandPred = this.asCommand(id, (Option<Expand.VariablePredicate>)logicalPredicate.variablePredicate(), expressionConverters, tokenContext);
        return new CommandNFA.NodeJuxtapositionTransition(commandPred, end);
    }

    public CommandNFA.RelationshipExpansionTransition compileStubbedRelationshipExpansion(int id, NFA.RelationshipExpansionPredicate logicalPredicate, CommandNFA.State end, boolean relVarIsGroupVariable, ExpressionConverters expressionConverters, ReadTokenContext tokenContext) {
        Option<Function3<CypherRow, QueryState, AnyValue, Object>> commandRelPred = this.asCommand(id, (Option<Expand.VariablePredicate>)logicalPredicate.relPred(), expressionConverters, tokenContext);
        Option<Function3<CypherRow, QueryState, AnyValue, Object>> commandNodePred = this.asCommand(id, (Option<Expand.VariablePredicate>)logicalPredicate.nodePred(), expressionConverters, tokenContext);
        Seq types = logicalPredicate.types();
        RelationshipTypes relTypes = types.isEmpty() ? null : RelationshipTypes$.MODULE$.apply((String[])((IterableOnceOps)types.map((Function1 & Serializable)x$4 -> x$4.name())).toArray(ClassTag$.MODULE$.apply(String.class)), tokenContext);
        return new CommandNFA.RelationshipExpansionTransition(commandRelPred, new State.VarName(logicalPredicate.relationshipVariable().name(), relVarIsGroupVariable), relTypes, logicalPredicate.dir(), commandNodePred, end);
    }

    public Option<Function3<CypherRow, QueryState, AnyValue, Object>> asCommand(int id, Option<Expand.VariablePredicate> variablePredicateOpt, ExpressionConverters expressionConverters, ReadTokenContext tokenContext) {
        return variablePredicateOpt.map((Function1 & Serializable)variablePredicate -> {
            Predicate command = (Predicate)expressionConverters.toCommandPredicate(id, variablePredicate.predicate()).rewrite((Function1<Expression, Expression>)(Function1 & Serializable)x$5 -> KeyTokenResolver$.MODULE$.resolveExpressions((Expression)x$5, tokenContext));
            ExpressionVariable ev = ExpressionVariable$.MODULE$.cast(variablePredicate.variable());
            return (Function3 & Serializable)(context, state, entity) -> BoxesRunTime.boxToBoolean((boolean)CommandNFA$.$anonfun$asCommand$3(ev, command, context, state, entity));
        });
    }

    public LongPredicate compileNodeJuxtapositionPredicate(CommandNFA.NodeJuxtapositionTransition commandPredicate, CypherRow row, QueryState state) {
        Option<Function3<CypherRow, QueryState, AnyValue, Object>> option = commandPredicate.inner();
        if (option instanceof Some) {
            Some some = (Some)option;
            Function3 inner = (Function3)some.value();
            return l -> BoxesRunTime.unboxToBoolean((Object)inner.apply((Object)row, (Object)state, (Object)VirtualValues.node((long)l)));
        }
        return LongPredicates.alwaysTrue();
    }

    public Tuple2<java.util.function.Predicate<RelationshipTraversalCursor>, LongPredicate> compileRelationshipExpansionPredicate(CommandNFA.RelationshipExpansionTransition commandPredicate, CypherRow row, QueryState state) {
        Object object;
        java.util.function.Predicate<RelationshipTraversalCursor> predicate;
        Option<Function3<CypherRow, QueryState, AnyValue, Object>> option = commandPredicate.innerRelPred();
        if (option instanceof Some) {
            Some some = (Some)option;
            Function3 inner = (Function3)some.value();
            predicate = cursor -> BoxesRunTime.unboxToBoolean((Object)inner.apply((Object)row, (Object)state, (Object)VirtualValues.relationship((long)cursor.relationshipReference(), (long)cursor.sourceNodeReference(), (long)cursor.targetNodeReference(), (int)cursor.type())));
        } else {
            predicate = Predicates.alwaysTrue();
        }
        Option<Function3<CypherRow, QueryState, AnyValue, Object>> option2 = commandPredicate.innerNodePred();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Function3 inner = (Function3)some.value();
            object = l -> BoxesRunTime.unboxToBoolean((Object)inner.apply((Object)row, (Object)state, (Object)VirtualValues.node((long)l)));
        } else {
            object = LongPredicates.alwaysTrue();
        }
        return new Tuple2(predicate, object);
    }

    public CommandNFA apply(Set<CommandNFA.State> states, CommandNFA.State startState, Set<CommandNFA.State> finalStates) {
        return new CommandNFA(states, startState, finalStates);
    }

    public Option<Tuple3<Set<CommandNFA.State>, CommandNFA.State, Set<CommandNFA.State>>> unapply(CommandNFA x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3(x$0.states(), (Object)x$0.startState(), x$0.finalStates()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CommandNFA$.class);
    }

    public static final /* synthetic */ void $anonfun$fromLogicalNFA$3(NFA logicalNFA$1, int id$1, Map stateLookup$2, ExpressionConverters expressionConverters$1, ReadTokenContext tokenContext$1, IntPredicate stateCorrespondsToGroupVariable$1, NFA.State logicalState) {
        Iterable transitions = (Iterable)logicalNFA$1.transitions().getOrElse((Object)logicalState, (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
        Tuple2 tuple2 = transitions.partitionMap((Function1 & Serializable)x0$1 -> {
            NFA.Transition transition = x0$1;
            if (transition != null) {
                NFA.Predicate np = transition.predicate();
                NFA.State end = transition.end();
                if (np instanceof NFA.NodeJuxtapositionPredicate) {
                    NFA.NodeJuxtapositionPredicate nodeJuxtapositionPredicate = (NFA.NodeJuxtapositionPredicate)np;
                    return package$.MODULE$.Left().apply((Object)MODULE$.compileStubbedNodeJuxtaposition(id$1, nodeJuxtapositionPredicate, (CommandNFA.State)stateLookup$2.apply((Object)end), expressionConverters$1, tokenContext$1));
                }
            }
            if (transition != null) {
                NFA.Predicate rp = transition.predicate();
                NFA.State end = transition.end();
                if (rp instanceof NFA.RelationshipExpansionPredicate) {
                    NFA.RelationshipExpansionPredicate relationshipExpansionPredicate = (NFA.RelationshipExpansionPredicate)rp;
                    return package$.MODULE$.Right().apply((Object)MODULE$.compileStubbedRelationshipExpansion(id$1, relationshipExpansionPredicate, (CommandNFA.State)stateLookup$2.apply((Object)end), stateCorrespondsToGroupVariable$1.test(logicalState.id()), expressionConverters$1, tokenContext$1));
                }
            }
            throw new MatchError((Object)transition);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable nodeTransitions = (Iterable)tuple2._1();
        Iterable relTransitions = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nodeTransitions, (Object)relTransitions);
        Iterable nodeTransitions2 = (Iterable)tuple22._1();
        Iterable relTransitions2 = (Iterable)tuple22._2();
        CommandNFA.State commandState = (CommandNFA.State)stateLookup$2.apply((Object)logicalState);
        commandState.nodeTransitions_$eq((Seq<CommandNFA.NodeJuxtapositionTransition>)nodeTransitions2.toSeq());
        commandState.relTransitions_$eq((Seq<CommandNFA.RelationshipExpansionTransition>)relTransitions2.toSeq());
    }

    public static final /* synthetic */ boolean $anonfun$asCommand$3(ExpressionVariable ev$1, Predicate command$1, CypherRow context, QueryState state, AnyValue entity) {
        state.expressionVariables()[ev$1.offset()] = entity;
        return command$1.isTrue((ReadableRow)context, state);
    }

    private CommandNFA$() {
    }
}

