/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import org.neo4j.internal.helpers.Numbers;

public final class BitUtils {
    private BitUtils() {
    }

    public static boolean bitFlag(byte flags, byte flag) {
        assert (Numbers.isPowerOfTwo(flag)) : "flag should be a power of 2, not: 0x" + Integer.toHexString(flag);
        return (flags & flag) == flag;
    }

    public static boolean bitFlag(int flags, int flag) {
        assert (Numbers.isPowerOfTwo(flag)) : "flag should be a power of 2, not: 0x" + Integer.toHexString(flag);
        return (flags & flag) == flag;
    }

    public static int bitFlag(boolean value, int flag) {
        assert (Numbers.isPowerOfTwo(flag)) : "flag should be a power of 2, not: 0x" + Integer.toHexString(flag);
        return value ? flag : 0;
    }

    public static byte bitFlag(boolean value, byte flag) {
        assert (Numbers.isPowerOfTwo(flag)) : "flag should be a power of 2, not: 0x" + Integer.toHexString(flag);
        return value ? flag : (byte)0;
    }

    public static byte bitFlags(int flag1, int flag2, int flag3, int flag4, int flag5, int flag6, int flag7, int flag8) {
        int result = flag1 | flag2 | flag3 | flag4 | flag5 | flag6 | flag7 | flag8;
        assert ((result & 0xFFFFFF00) == 0);
        return (byte)result;
    }

    public static byte bitFlags(int flag1, int flag2, int flag3, int flag4, int flag5, int flag6, int flag7) {
        int result = flag1 | flag2 | flag3 | flag4 | flag5 | flag6 | flag7;
        assert ((result & 0xFFFFFF00) == 0);
        return (byte)result;
    }

    public static byte bitFlags(int flag1, int flag2, int flag3, int flag4, int flag5, int flag6) {
        int result = flag1 | flag2 | flag3 | flag4 | flag5 | flag6;
        assert ((result & 0xFFFFFF00) == 0);
        return (byte)result;
    }

    public static byte bitFlags(int flag1, int flag2, int flag3, int flag4, int flag5) {
        int result = flag1 | flag2 | flag3 | flag4 | flag5;
        assert ((result & 0xFFFFFF00) == 0);
        return (byte)result;
    }

    public static byte bitFlags(int flag1, int flag2, int flag3, int flag4) {
        int result = flag1 | flag2 | flag3 | flag4;
        assert ((result & 0xFFFFFF00) == 0);
        return (byte)result;
    }

    public static byte bitFlags(int flag1, int flag2, int flag3) {
        int result = flag1 | flag2 | flag3;
        assert ((result & 0xFFFFFF00) == 0);
        return (byte)result;
    }

    public static byte bitFlags(int flag1, int flag2) {
        int result = flag1 | flag2;
        assert ((result & 0xFFFFFF00) == 0);
        return (byte)result;
    }

    public static void numberToString(StringBuilder builder, long value, int numberOfBytes) {
        builder.append('[');
        for (int i = 8 * numberOfBytes - 1; i >= 0; --i) {
            boolean isSet = (value & 1L << i) != 0L;
            builder.append(isSet ? "1" : "0");
            if (i <= 0 || i % 8 != 0) continue;
            builder.append(',');
        }
        builder.append(']');
    }

    public static String numbersToBitString(long[] values) {
        StringBuilder builder = new StringBuilder();
        for (long value : values) {
            BitUtils.numberToString(builder, value, 8);
        }
        return builder.toString();
    }
}

