/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm;

import java.util.function.Consumer;
import org.neo4j.bolt.fsm.StateMachine;
import org.neo4j.bolt.fsm.StateMachineFactoryImpl;
import org.neo4j.bolt.fsm.error.NoSuchStateException;
import org.neo4j.bolt.fsm.state.State;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.fsm.state.transition.StateTransition;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.logging.internal.LogService;

public interface StateMachineConfiguration {
    public static Factory builder() {
        return new StateMachineFactoryImpl();
    }

    public Factory builderOf();

    public StateReference initialState();

    public State lookup(StateReference var1) throws NoSuchStateException;

    public StateMachine createInstance(Connection var1, LogService var2);

    public static interface Factory {
        public StateMachineConfiguration build();

        public Factory withInitialState(StateReference var1);

        public Factory withInitialState(StateReference var1, Consumer<State.Factory> var2);

        default public Factory withInitialState(StateReference reference, StateTransition<?> ... transitions) {
            return this.withInitialState(reference, (State.Factory state) -> {
                for (StateTransition transition : transitions) {
                    state.withTransition(transition);
                }
            });
        }

        public Factory withState(StateReference var1, Consumer<State.Factory> var2);

        default public Factory withState(StateReference reference, StateTransition<?> ... transitions) {
            return this.withState(reference, (State.Factory state) -> {
                for (StateTransition transition : transitions) {
                    state.withTransition(transition);
                }
            });
        }

        public Factory withoutState(StateReference var1);
    }
}

