/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.transition.authentication;

import java.util.Locale;
import org.neo4j.bolt.fsm.Context;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.fsm.state.transition.AbstractStateTransition;
import org.neo4j.bolt.protocol.common.connector.connection.authentication.AuthenticationFlag;
import org.neo4j.bolt.protocol.common.fsm.States;
import org.neo4j.bolt.protocol.common.fsm.error.AuthenticationStateTransitionException;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.request.authentication.AuthenticationMessage;
import org.neo4j.bolt.security.error.AuthenticationException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public final class AuthenticationStateTransition
extends AbstractStateTransition<AuthenticationMessage> {
    private static final AuthenticationStateTransition INSTANCE = new AuthenticationStateTransition();

    private AuthenticationStateTransition() {
        super(AuthenticationMessage.class);
    }

    public static AuthenticationStateTransition getInstance() {
        return INSTANCE;
    }

    @Override
    public StateReference process(Context ctx, AuthenticationMessage message, ResponseHandler handler) throws StateMachineException {
        AuthenticationFlag flags;
        try {
            flags = ctx.connection().logon(message.authToken());
        }
        catch (AuthenticationException ex) {
            throw new AuthenticationStateTransitionException(ex);
        }
        if (flags != null) {
            handler.onMetadata(flags.name().toLowerCase(Locale.ROOT), (AnyValue)Values.TRUE);
        }
        ctx.defaultState(States.READY);
        return States.READY;
    }
}

