/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message;

import java.util.Objects;
import java.util.UUID;
import org.neo4j.bolt.fsm.error.ConnectionTerminating;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.kernel.api.exceptions.HasQuery;
import org.neo4j.kernel.api.exceptions.Status;

public class Error {
    private final Status status;
    private final String message;
    private final Throwable cause;
    private final UUID reference;
    private final boolean fatal;
    private final Long queryId;

    private Error(Status status, String message, Throwable cause, boolean fatal, Long queryId) {
        this.status = status;
        this.message = message;
        this.cause = cause;
        this.fatal = fatal;
        this.reference = UUID.randomUUID();
        this.queryId = queryId;
    }

    private Error(Status status, String message, boolean fatal) {
        this(status, message, null, fatal, null);
    }

    private Error(Status status, Throwable cause, boolean fatal, Long queryId) {
        this(status, status.code().description(), cause, fatal, queryId);
    }

    public Status status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    public Throwable cause() {
        return this.cause;
    }

    public UUID reference() {
        return this.reference;
    }

    public Long queryId() {
        return this.queryId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error that = (Error)o;
        return Objects.equals(this.status, that.status) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        int result = this.status != null ? this.status.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Neo4jError{status=" + this.status + ", message='" + this.message + "', cause=" + this.cause + ", reference=" + this.reference + "}";
    }

    public static Error from(Status status, String message) {
        return new Error(status, message, false);
    }

    public static Error from(Throwable any) {
        boolean fatal = false;
        for (Throwable cause = any; cause != null; cause = cause.getCause()) {
            Long queryId = null;
            if (cause instanceof ConnectionTerminating) {
                fatal = true;
            }
            if (cause instanceof HasQuery) {
                queryId = ((HasQuery)cause).query();
            }
            if (cause instanceof DatabaseShutdownException) {
                return new Error((Status)Status.General.DatabaseUnavailable, cause, fatal, queryId);
            }
            if (cause instanceof Status.HasStatus) {
                return new Error(((Status.HasStatus)cause).status(), cause.getMessage(), any, false, queryId);
            }
            if (cause instanceof OutOfMemoryError) {
                return new Error((Status)Status.General.OutOfMemoryError, cause, fatal, queryId);
            }
            if (!(cause instanceof StackOverflowError)) continue;
            return new Error((Status)Status.General.StackOverFlowError, cause, fatal, queryId);
        }
        return new Error((Status)Status.General.UnknownError, any != null ? any.getMessage() : null, any, fatal, null);
    }

    public static Error fatalFrom(Status status, String message) {
        return new Error(status, message, true);
    }

    public boolean isFatal() {
        return this.fatal;
    }
}

