/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.index.internal.gbptree.CleanupJob;
import org.neo4j.index.internal.gbptree.GenerationSafePointer;
import org.neo4j.index.internal.gbptree.InternalNodeBehaviour;
import org.neo4j.index.internal.gbptree.MultiRootGBPTree;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.TreeNodeUtil;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageCursorUtil;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.time.Stopwatch;
import org.neo4j.util.FeatureToggles;

class CrashGenerationCleaner {
    private static final String INDEX_CLEANER_TAG = "indexCleaner";
    private static final String NUMBER_OF_WORKERS_NAME = "number_of_workers";
    private static final int NUMBER_OF_WORKERS_DEFAULT = Math.min(8, Runtime.getRuntime().availableProcessors());
    private static final int NUMBER_OF_WORKERS = FeatureToggles.getInteger(CrashGenerationCleaner.class, (String)"number_of_workers", (int)NUMBER_OF_WORKERS_DEFAULT);
    private static final long MIN_BATCH_SIZE = 10L;
    static final long MAX_BATCH_SIZE = 100L;
    private final PagedFile pagedFile;
    private final InternalNodeBehaviour<?> dataTreeNode;
    private final InternalNodeBehaviour<?> rootTreeNode;
    private final long lowTreeNodeId;
    private final long highTreeNodeId;
    private final long stableGeneration;
    private final long unstableGeneration;
    private final MultiRootGBPTree.Monitor monitor;
    private final CursorContextFactory contextFactory;
    private final String treeName;

    CrashGenerationCleaner(PagedFile pagedFile, InternalNodeBehaviour<?> rootTreeNode, InternalNodeBehaviour<?> dataTreeNode, long lowTreeNodeId, long highTreeNodeId, long stableGeneration, long unstableGeneration, MultiRootGBPTree.Monitor monitor, CursorContextFactory contextFactory, String treeName) {
        this.pagedFile = pagedFile;
        this.dataTreeNode = dataTreeNode;
        this.rootTreeNode = rootTreeNode;
        this.lowTreeNodeId = lowTreeNodeId;
        this.highTreeNodeId = highTreeNodeId;
        this.stableGeneration = stableGeneration;
        this.unstableGeneration = unstableGeneration;
        this.monitor = monitor;
        this.contextFactory = contextFactory;
        this.treeName = treeName;
    }

    private static long batchSize(long pagesToClean, int threads) {
        return Math.min(100L, Math.max(10L, pagesToClean / (100L * (long)threads)));
    }

    public void clean(CleanupJob.Executor executor) {
        this.monitor.cleanupStarted();
        assert (this.unstableGeneration > this.stableGeneration) : this.unexpectedGenerations();
        assert (this.unstableGeneration - this.stableGeneration > 1L) : this.unexpectedGenerations();
        Stopwatch startTime = Stopwatch.start();
        long pagesToClean = this.highTreeNodeId - this.lowTreeNodeId;
        int threads = NUMBER_OF_WORKERS;
        long batchSize = CrashGenerationCleaner.batchSize(pagesToClean, threads);
        AtomicLong nextId = new AtomicLong(this.lowTreeNodeId);
        AtomicBoolean stopFlag = new AtomicBoolean();
        LongAdder cleanedPointers = new LongAdder();
        LongAdder numberOfTreeNodes = new LongAdder();
        ArrayList jobResults = new ArrayList();
        for (int i = 0; i < threads; ++i) {
            Callable<?> cleanerTask = this.cleaner(nextId, batchSize, numberOfTreeNodes, cleanedPointers, stopFlag);
            CleanupJob.JobResult<?> jobHandle = executor.submit("Recovery clean up of '" + this.treeName + "'", cleanerTask);
            jobResults.add(jobHandle);
        }
        CrashGenerationCleaner.awaitAll(jobResults);
        this.monitor.cleanupFinished(pagesToClean, numberOfTreeNodes.sum(), cleanedPointers.sum(), startTime.elapsed(TimeUnit.MILLISECONDS));
    }

    private Callable<?> cleaner(AtomicLong nextId, long batchSize, LongAdder numberOfTreeNodes, LongAdder cleanedPointers, AtomicBoolean stopFlag) {
        return () -> {
            try (CursorContext cursorContext = this.contextFactory.create(INDEX_CLEANER_TAG);
                 PageCursor cursor = this.pagedFile.io(0L, 1, cursorContext);
                 PageCursor writeCursor = this.pagedFile.io(0L, 2, cursorContext);){
                long localNextId;
                while ((localNextId = nextId.getAndAdd(batchSize)) < this.highTreeNodeId) {
                    int localNumberOfTreeNodes = 0;
                    int i = 0;
                    while ((long)i < batchSize && localNextId < this.highTreeNodeId) {
                        PageCursorUtil.goTo((PageCursor)cursor, (String)"clean", (long)localNextId);
                        boolean isTreeNode = CrashGenerationCleaner.isTreeNode(cursor);
                        if (isTreeNode) {
                            ++localNumberOfTreeNodes;
                            if (this.hasCrashedGSPP(cursor)) {
                                writeCursor.next(cursor.getCurrentPageId());
                                this.cleanTreeNode(writeCursor, cleanedPointers);
                            }
                        }
                        ++i;
                        ++localNextId;
                    }
                    numberOfTreeNodes.add(localNumberOfTreeNodes);
                    if (!stopFlag.get()) continue;
                    break;
                }
            }
            catch (Throwable e) {
                stopFlag.set(true);
                throw e;
            }
            return null;
        };
    }

    private static boolean isTreeNode(PageCursor cursor) throws IOException {
        boolean isTreeNode;
        do {
            boolean bl = isTreeNode = TreeNodeUtil.nodeType(cursor) == 1;
        } while (cursor.shouldRetry());
        PointerChecking.checkOutOfBounds(cursor);
        return isTreeNode;
    }

    private boolean hasCrashedGSPP(PageCursor cursor) throws IOException {
        boolean hasCrashed;
        byte layerType;
        int keyCount;
        do {
            keyCount = TreeNodeUtil.keyCount(cursor);
            layerType = TreeNodeUtil.layerType(cursor);
        } while (cursor.shouldRetry());
        PointerChecking.checkOutOfBounds(cursor);
        InternalNodeBehaviour<?> treeNode = this.selectTreeNode(layerType);
        do {
            boolean bl = hasCrashed = this.hasCrashedGSPP(cursor, 58) || this.hasCrashedGSPP(cursor, 34) || this.hasCrashedGSPP(cursor, 10);
            if (hasCrashed || !TreeNodeUtil.isInternal(cursor)) continue;
            for (int i = 0; i <= keyCount && treeNode.reasonableKeyCount(i) && !hasCrashed; ++i) {
                hasCrashed = this.hasCrashedGSPP(cursor, treeNode.childOffset(i));
            }
        } while (cursor.shouldRetry());
        PointerChecking.checkOutOfBounds(cursor);
        return hasCrashed;
    }

    private InternalNodeBehaviour<?> selectTreeNode(byte layerType) {
        return layerType == 0 ? this.dataTreeNode : this.rootTreeNode;
    }

    private boolean hasCrashedGSPP(PageCursor cursor, int gsppOffset) {
        return this.hasCrashedGSP(cursor, gsppOffset) || this.hasCrashedGSP(cursor, gsppOffset + 12);
    }

    private boolean hasCrashedGSP(PageCursor cursor, int offset) {
        cursor.setOffset(offset);
        long generation = GenerationSafePointer.readGeneration(cursor);
        return generation > this.stableGeneration && generation < this.unstableGeneration;
    }

    private void cleanTreeNode(PageCursor cursor, LongAdder cleanedPointers) {
        this.cleanCrashedGSPP(cursor, 58, cleanedPointers);
        this.cleanCrashedGSPP(cursor, 34, cleanedPointers);
        this.cleanCrashedGSPP(cursor, 10, cleanedPointers);
        if (TreeNodeUtil.isInternal(cursor)) {
            int keyCount = TreeNodeUtil.keyCount(cursor);
            byte layerType = TreeNodeUtil.layerType(cursor);
            InternalNodeBehaviour<?> treeNode = this.selectTreeNode(layerType);
            for (int i = 0; i <= keyCount && treeNode.reasonableKeyCount(i); ++i) {
                this.cleanCrashedGSPP(cursor, treeNode.childOffset(i), cleanedPointers);
            }
        }
    }

    private void cleanCrashedGSPP(PageCursor cursor, int gsppOffset, LongAdder cleanedPointers) {
        this.cleanCrashedGSP(cursor, gsppOffset, cleanedPointers);
        this.cleanCrashedGSP(cursor, gsppOffset + 12, cleanedPointers);
    }

    private void cleanCrashedGSP(PageCursor cursor, int gspOffset, LongAdder cleanedPointers) {
        if (this.hasCrashedGSP(cursor, gspOffset)) {
            cursor.setOffset(gspOffset);
            GenerationSafePointer.clean(cursor);
            cleanedPointers.increment();
        }
    }

    private String unexpectedGenerations() {
        return "Unexpected generations, stableGeneration=" + this.stableGeneration + ", unstableGeneration=" + this.unstableGeneration;
    }

    private static void awaitAll(Iterable<? extends CleanupJob.JobResult<?>> jobHandles) {
        Throwable finalError = null;
        for (CleanupJob.JobResult<?> jobHandle : jobHandles) {
            try {
                jobHandle.get();
            }
            catch (Throwable e) {
                finalError = Exceptions.chain(finalError, (Throwable)e);
            }
        }
        if (finalError != null) {
            Exceptions.throwIfUnchecked(finalError);
            throw new RuntimeException(finalError);
        }
    }
}

