/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.consistency.checker.Checker;
import org.neo4j.consistency.checker.CountsState;
import org.neo4j.consistency.checker.EntityBasedMemoryLimiter;
import org.neo4j.consistency.checker.FreeIdCache;
import org.neo4j.consistency.checker.IndexSizes;
import org.neo4j.consistency.checker.ParallelExecution;
import org.neo4j.consistency.checker.RecordLoading;
import org.neo4j.consistency.checking.ConsistencyFlags;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.internal.helpers.Format;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.logging.InternalLog;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.time.Stopwatch;
import org.neo4j.token.TokenHolders;

class CheckerContext {
    final NeoStores neoStores;
    final IndexAccessors indexAccessors;
    final ConsistencyFlags consistencyFlags;
    final IndexSizes indexSizes;
    final ParallelExecution execution;
    final ConsistencyReport.Reporter reporter;
    final CacheAccess cacheAccess;
    final TokenHolders tokenHolders;
    final RecordLoading recordLoader;
    final CountsState observedCounts;
    final EntityBasedMemoryLimiter limiter;
    final ProgressMonitorFactory.MultiPartBuilder progress;
    final TokenNameLookup tokenNameLookup;
    final PageCache pageCache;
    final MemoryTracker memoryTracker;
    final long highNodeId;
    final long highRelationshipId;
    final IndexAccessor nodeLabelIndex;
    final IndexAccessor relationshipTypeIndex;
    final CursorContextFactory contextFactory;
    final FreeIdCache propertyFreeIdCache;
    private final AtomicBoolean cancelled;
    private final InternalLog log;
    private final boolean verbose;

    CheckerContext(NeoStores neoStores, IndexAccessors indexAccessors, ParallelExecution execution, ConsistencyReport.Reporter reporter, CacheAccess cacheAccess, TokenHolders tokenHolders, RecordLoading recordLoader, CountsState observedCounts, EntityBasedMemoryLimiter limiter, ProgressMonitorFactory.MultiPartBuilder progress, PageCache pageCache, MemoryTracker memoryTracker, InternalLog log, boolean verbose, ConsistencyFlags consistencyFlags, CursorContextFactory contextFactory) {
        this(neoStores, indexAccessors, execution, reporter, cacheAccess, tokenHolders, recordLoader, observedCounts, new FreeIdCache(neoStores.getPropertyStore().getIdGenerator()), limiter, progress, pageCache, memoryTracker, log, verbose, new AtomicBoolean(), consistencyFlags, contextFactory);
    }

    private CheckerContext(NeoStores neoStores, IndexAccessors indexAccessors, ParallelExecution execution, ConsistencyReport.Reporter reporter, CacheAccess cacheAccess, TokenHolders tokenHolders, RecordLoading recordLoader, CountsState observedCounts, FreeIdCache propertyFreeIdCache, EntityBasedMemoryLimiter limiter, ProgressMonitorFactory.MultiPartBuilder progress, PageCache pageCache, MemoryTracker memoryTracker, InternalLog log, boolean verbose, AtomicBoolean cancelled, ConsistencyFlags consistencyFlags, CursorContextFactory contextFactory) {
        this.neoStores = neoStores;
        this.highNodeId = neoStores.getNodeStore().getIdGenerator().getHighId();
        this.highRelationshipId = neoStores.getRelationshipStore().getIdGenerator().getHighId();
        this.indexAccessors = indexAccessors;
        this.nodeLabelIndex = indexAccessors.nodeLabelIndex();
        this.relationshipTypeIndex = indexAccessors.relationshipTypeIndex();
        this.log = log;
        this.verbose = verbose;
        this.consistencyFlags = consistencyFlags;
        this.contextFactory = contextFactory;
        this.indexSizes = new IndexSizes(execution, indexAccessors, this.highNodeId, this.highRelationshipId, contextFactory);
        this.execution = execution;
        this.reporter = reporter;
        this.cacheAccess = cacheAccess;
        this.tokenHolders = tokenHolders;
        this.recordLoader = recordLoader;
        this.observedCounts = observedCounts;
        this.limiter = limiter;
        this.progress = progress;
        this.cancelled = cancelled;
        this.tokenNameLookup = tokenHolders.lookupWithIds();
        this.pageCache = pageCache;
        this.memoryTracker = memoryTracker;
        this.propertyFreeIdCache = propertyFreeIdCache;
    }

    CheckerContext withoutReporting() {
        return new CheckerContext(this.neoStores, this.indexAccessors, this.execution, ConsistencyReport.NO_REPORT, this.cacheAccess, this.tokenHolders, this.recordLoader, this.observedCounts, this.propertyFreeIdCache, this.limiter, this.progress, this.pageCache, this.memoryTracker, this.log, this.verbose, this.cancelled, this.consistencyFlags, this.contextFactory);
    }

    void initialize() throws Exception {
        this.debug(this.limiter.toString(), new Object[0]);
        this.timeOperation("Initialize index sizes", this.indexSizes::initialize, false);
        this.timeOperation("Initialize free-id cache for properties", this.propertyFreeIdCache::initialize, false);
        if (this.verbose) {
            this.debugPrintIndexes(this.indexSizes.largeIndexes(EntityType.NODE), "considered large node indexes");
            this.debugPrintIndexes(this.indexSizes.smallIndexes(EntityType.NODE), "considered small node indexes");
            this.debugPrintIndexes(this.indexSizes.largeIndexes(EntityType.RELATIONSHIP), "considered large relationship indexes");
            this.debugPrintIndexes(this.indexSizes.smallIndexes(EntityType.RELATIONSHIP), "considered small relationship indexes");
        }
    }

    void initializeRange() {
        this.observedCounts.clearDynamicNodeLabelsCache();
    }

    private void debugPrintIndexes(List<IndexDescriptor> indexes, String description) {
        if (!indexes.isEmpty()) {
            this.debug("These are %s (%d):", description, indexes.size());
            indexes.forEach(index -> this.debug("  %s", index));
        }
    }

    private void timeOperation(String description, ParallelExecution.ThrowingRunnable action, boolean linePadding) throws Exception {
        Stopwatch stopwatch = Stopwatch.start();
        try {
            this.debug(linePadding, "STARTED %s", description);
            action.doRun();
            this.debug(linePadding, "COMPLETED %s, took %s", description, Format.duration((long)stopwatch.elapsed(TimeUnit.MILLISECONDS)));
        }
        catch (Exception e) {
            this.debug(linePadding, "FAILED %s after %s", description, Format.duration((long)stopwatch.elapsed(TimeUnit.MILLISECONDS)));
            throw e;
        }
    }

    boolean isCancelled() {
        return this.cancelled.get();
    }

    void cancel() {
        this.cancelled.set(true);
    }

    void runIfAllowed(Checker checker, LongRange range) throws Exception {
        if (!this.isCancelled() && checker.shouldBeChecked(this.consistencyFlags)) {
            this.timeOperation(checker.toString(), () -> checker.check(range, EntityBasedMemoryLimiter.isFirst(range), this.limiter.isLast(range, checker.isNodeBasedCheck())), true);
        }
    }

    void paddedDebug(String format, Object ... params) {
        this.debug(true, format, params);
    }

    void debug(String format, Object ... params) {
        this.debug(false, format, params);
    }

    private void debug(boolean linePadded, String format, Object ... params) {
        if (this.verbose) {
            this.log.info((linePadded ? "%n" : "") + format, params);
        }
    }

    void error(String format, Object ... params) {
        if (this.verbose) {
            this.log.error(format, params);
        }
    }

    ProgressListener progressReporter(Checker checker, String name, long totalCount) {
        int nbrRanges = checker.isNodeBasedCheck() ? this.limiter.numberOfNodeRanges() : this.limiter.numberOfRelationshipRanges();
        return this.roundInsensitiveProgressReporter(checker, name, totalCount * (long)nbrRanges);
    }

    ProgressListener roundInsensitiveProgressReporter(Checker checker, String name, long totalCount) {
        if (!checker.shouldBeChecked(this.consistencyFlags)) {
            return ProgressListener.NONE;
        }
        return this.progress.progressForPart(name, totalCount);
    }

    boolean isVerbose() {
        return this.verbose;
    }
}

