/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.NoSuchElementException;
import org.neo4j.annotations.service.Service;
import org.neo4j.configuration.Config;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.BatchImporter;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.batchimport.Monitor;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.service.NamedService;
import org.neo4j.service.Services;
import org.neo4j.storageengine.api.LogFilesInitializer;

@Service
public abstract class BatchImporterFactory
implements NamedService {
    private final int priority;

    protected BatchImporterFactory(int priority) {
        this.priority = priority;
    }

    public abstract BatchImporter instantiate(DatabaseLayout var1, FileSystemAbstraction var2, PageCacheTracer var3, Configuration var4, LogService var5, ExecutionMonitor var6, AdditionalInitialIds var7, LogTailMetadata var8, Config var9, Monitor var10, JobScheduler var11, Collector var12, LogFilesInitializer var13, IndexImporterFactory var14, MemoryTracker var15, CursorContextFactory var16);

    public static BatchImporterFactory withHighestPriority() {
        BatchImporterFactory highestPrioritized = null;
        for (BatchImporterFactory candidate : Services.loadAll(BatchImporterFactory.class)) {
            if (highestPrioritized != null && candidate.priority <= highestPrioritized.priority) continue;
            highestPrioritized = candidate;
        }
        if (highestPrioritized == null) {
            throw new NoSuchElementException("No batch importers found");
        }
        return highestPrioritized;
    }
}

